/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.kiosk.pages.item;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Transient;
import ordermate.database.kiosk.menu.KioskMenuUnitPriceLevel;
import ordermate.database.kiosk.pages.AbstractOrderingKioskPage;
import ordermate.database.kiosk.pages.item.KioskPageItem;
import ordermate.database.kiosk.pages.item.KioskPageItemType;

@Entity
@DiscriminatorValue(value="UnitPrice")
public class KioskPageUnitPrice
extends KioskPageItem {
    public static final Props Properties = new Props();
    private Reference<KioskMenuUnitPriceLevel> orderableUnitPriceLevel;

    @Deprecated
    public KioskPageUnitPrice() {
        this.orderableUnitPriceLevel = this.createReference(KioskPageUnitPrice.Properties.ORDERABLE_UNIT_PRICE_LEVEL);
    }

    public KioskPageUnitPrice(AbstractOrderingKioskPage parentPage, KioskMenuUnitPriceLevel level) {
        super(parentPage);
        this.orderableUnitPriceLevel = this.createReference(KioskPageUnitPrice.Properties.ORDERABLE_UNIT_PRICE_LEVEL);
        if (level == null) {
            throw new IllegalStateException("Cannot have a null unit price");
        }
        this.orderableUnitPriceLevel.set(level);
    }

    @ManyToOne(optional=true)
    @JoinColumn(name="fk_kiosk_unit_price_level", referencedColumnName="ID", nullable=true)
    public KioskMenuUnitPriceLevel getOrderableUnitPriceLevel() {
        return this.orderableUnitPriceLevel.get();
    }

    public void setOrderableUnitPriceLevel(KioskMenuUnitPriceLevel newUnit) {
        this.orderableUnitPriceLevel.set(newUnit);
    }

    @Override
    @Transient
    public KioskPageItemType getItemType() {
        return KioskPageItemType.UnitPrice;
    }

    public static class Props
    extends KioskPageItem.Props {
        public PropertiedObject.Property<KioskMenuUnitPriceLevel> ORDERABLE_UNIT_PRICE_LEVEL;
    }
}

