/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.message;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_command")
@AccessType(value="property")
public class Command
extends PersistentObject {
    public static final Props Properties = new Props();
    private static LocalCacheListManager<Command> allCommands = new LocalCacheListManager<Command>(Query.createQueryList(Command.class, Query.select(Command.class).orderByDesc(Command.Properties.ID)));
    private String command;
    private String name;

    @Column(name="public_command")
    public String getCommand() {
        return this.command;
    }

    @Column(name="internal_name")
    public String getName() {
        return this.name;
    }

    public static Command getCommandByName(String name) {
        String nameParam = name.trim();
        return PersistenceManager.getObject(Command.class, "SELECT * FROM config_command WHERE internal_name = ?", new Object[]{nameParam});
    }

    public static Command getCommandByCommand(String command) {
        String commandParam = command.trim();
        return PersistenceManager.getObject(Command.class, "SELECT * FROM config_command WHERE public_command = ?", new Object[]{commandParam});
    }

    public static List<Command> getAllCommands() {
        return allCommands.getList();
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setCommand(String command) {
        this.command = command;
    }

    @Override
    public String toString() {
        if (this.getName() != null) {
            return this.getName();
        }
        return super.toString();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property COMMAND;
        public PropertiedObject.Property NAME;
    }
}

