/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.message;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.encryption.BlowfishEasy;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_mail_server")
@AccessType(value="property")
public class MailServer
extends PersistentObject
implements Saveable {
    public static final String BLOWFISH_ENCRYPTER_DEFINITION = "MailServerPassword";
    private transient BlowfishEasy blowFishEncrypter;
    public static final Props Properties = new Props();
    private String type;
    private String host;
    private int port;
    private boolean sslConnection;
    private boolean tlsConnection;
    private String username;
    private String password;
    private String passwordRaw;

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    @Column(name="host")
    public String getHost() {
        return this.host;
    }

    @Column(name="port")
    public int getPort() {
        return this.port;
    }

    @Column(name="ssl_connection")
    public boolean isSslConnection() {
        return this.sslConnection;
    }

    @Column(name="tls_connection")
    public boolean isTlsConnection() {
        return this.tlsConnection;
    }

    @Column(name="username")
    public String getUsername() {
        return this.username;
    }

    @Column(name="password")
    private String getPassword() {
        return this.password;
    }

    @Transient
    public String getPasswordRaw() {
        if (this.passwordRaw == null) {
            if (this.getPassword() == null || this.getPassword().equals("")) {
                return "";
            }
            try {
                this.passwordRaw = this.getBlowFish().decryptString(this.getPassword());
            }
            catch (IllegalArgumentException ex) {
                OrderMate.LOG.error("Cannot decrypt the password ", (Throwable)ex);
            }
        }
        return this.passwordRaw;
    }

    public static MailServer getMailServer(String type) {
        ObjectQuery query = Query.select(MailServer.class).equals(MailServer.Properties.TYPE, type);
        if (PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            query.equals(MailServer.Properties.STORE_ID, 0.0);
        }
        return PersistenceManager.getObject(MailServer.class, query.toString(), null);
    }

    public static MailServer createServer(String type) {
        MailServer server = MailServer.getMailServer(type);
        if (server == null) {
            server = new MailServer();
            server.setType(type);
            server.setUsername("");
            server.setHost("");
            server.setPasswordRaw("");
            server.setPort(0);
            server.setSslConnection(false);
            server.setTlsConnection(true);
        }
        return server;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setSslConnection(boolean ssl) {
        this.sslConnection = ssl;
    }

    public void setTlsConnection(boolean tls) {
        this.tlsConnection = tls;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    private void setPassword(String password) {
        this.password = password;
    }

    public void setPasswordRaw(String uncryptedPassword) {
        this.passwordRaw = uncryptedPassword;
        try {
            this.setPassword(this.getBlowFish().encryptString(uncryptedPassword));
        }
        catch (IllegalArgumentException ex) {
            OrderMate.LOG.error("Cannot encrypt the password ", (Throwable)ex);
        }
    }

    protected void setType(String type) {
        this.type = type;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.validateSSLandTSLSettings(this);
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Transient
    private BlowfishEasy getBlowFish() {
        if (this.blowFishEncrypter == null) {
            this.blowFishEncrypter = new BlowfishEasy(BLOWFISH_ENCRYPTER_DEFINITION);
        }
        return this.blowFishEncrypter;
    }

    private void validateSSLandTSLSettings(MailServer mailServerObject) {
        if (mailServerObject.isSslConnection() && mailServerObject.isTlsConnection()) {
            mailServerObject.setTlsConnection(false);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TYPE;
        public PropertiedObject.Property HOST;
        public PropertiedObject.Property PORT;
        public PropertiedObject.Property SSL_CONNECTION;
        public PropertiedObject.Property TLS_CONNECTION;
        public PropertiedObject.Property USERNAME;
        public PropertiedObject.Property PASSWORD;
        public PropertiedObject.Property PASSWORD_RAW;
    }
}

