/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.message;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.message.ScheduledMessage;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_scheduled_message_destination")
@AccessType(value="property")
public class MessageDestination
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String destination;
    private Reference<ScheduledMessage> scheduledMessage;
    private SystemState systemState;

    public MessageDestination() {
        this.scheduledMessage = this.createReference(MessageDestination.Properties.SCHEDULED_MESSAGE);
        this.systemState = SystemState.ACTIVE_STATE;
    }

    @Column(name="destination")
    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String newDestination) {
        this.destination = newDestination;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_scheduled_message")
    public ScheduledMessage getScheduledMessage() {
        return this.scheduledMessage.get();
    }

    public void setScheduledMessage(ScheduledMessage newScheduledMessage) {
        this.scheduledMessage.set(newScheduledMessage);
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.SystemStateMapping")
    @Column(name="system_state")
    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState newSystemState) {
        this.systemState = newSystemState;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        String toReturn = this.getDestination();
        if (toReturn == null) {
            toReturn = "null Destination Set";
        }
        return toReturn;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DESTINATION;
        public PropertiedObject.Property<ScheduledMessage> SCHEDULED_MESSAGE;
        public PropertiedObject.Property SYSTEM_STATE;
    }
}

