/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.message;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.message.Command;
import ordermate.database.message.MessageDestination;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_scheduled_message")
@AccessType(value="property")
public class ScheduledMessage
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private PersistentWriteableList<MessageDestination> destination;
    private Date time;
    private Reference<Command> command;
    private String day;

    public ScheduledMessage() {
        this.destination = this.createWriteableList(ScheduledMessage.Properties.DESTINATION);
        this.time = new Date();
        this.command = this.createReference(ScheduledMessage.Properties.COMMAND);
        int today = Calendar.getInstance().get(7);
        this.day = ScheduledMessage.dayAsString(today);
    }

    @Transient
    public Collection<MessageDestination> getDestinations() {
        return this.destination.getUnmodifiable();
    }

    @Column(name="time")
    @Temporal(value=TemporalType.TIME)
    public Date getTime() {
        return this.time;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_command")
    public Command getCommand() {
        return this.command.get();
    }

    @Column(name="day")
    public String getDay() {
        return this.day;
    }

    public void setDay(String day) {
        this.day = day;
    }

    public void setDestination(List<MessageDestination> destination) {
        this.destination = this.destination.clone();
        this.destination.set(destination);
    }

    public void setTime(Date time) {
        this.time = time;
    }

    public void setCommand(Command value) {
        this.command.set(value);
    }

    public static Collection<ScheduledMessage> getScheduledMessages() {
        ArrayList<ScheduledMessage> messages = new ArrayList<ScheduledMessage>();
        int today = Calendar.getInstance().get(7);
        String dayStr = ScheduledMessage.dayAsString(today);
        messages.addAll(PersistenceManager.getObjectList(ScheduledMessage.class, "SELECT * FROM config_scheduled_message WHERE day = ? AND system_state = 'ACTIVE'", new Object[]{dayStr}));
        messages.addAll(PersistenceManager.getObjectList(ScheduledMessage.class, "SELECT * FROM config_scheduled_message WHERE day IS NULL AND system_state = 'ACTIVE'", new Object[0]));
        return messages;
    }

    public static String dayAsString(int today) {
        String dayStr;
        switch (today) {
            case 2: {
                dayStr = "MONDAY";
                break;
            }
            case 3: {
                dayStr = "TUESDAY";
                break;
            }
            case 4: {
                dayStr = "WEDNESDAY";
                break;
            }
            case 5: {
                dayStr = "THURSDAY";
                break;
            }
            case 6: {
                dayStr = "FRIDAY";
                break;
            }
            case 7: {
                dayStr = "SATURDAY";
                break;
            }
            case 1: {
                dayStr = "SUNDAY";
                break;
            }
            default: {
                throw new IllegalArgumentException("The value " + today + " is not a valid Calendar day of week.");
            }
        }
        return dayStr;
    }

    public static ScheduledMessage getScheduledMessage(Long ID) {
        return PersistenceManager.getByID(ID, ScheduledMessage.class);
    }

    @OneToMany(mappedBy="scheduledMessage", targetEntity=MessageDestination.class)
    public List<MessageDestination> getDestination() {
        return this.destination;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.destination.saveChild();
    }

    @Override
    public void delete() {
        this.destination.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DESTINATION;
        public PropertiedObject.Property TIME;
        public PropertiedObject.Property COMMAND;
        public PropertiedObject.Property DAY;
    }
}

