/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.message;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_sms_provider")
@AccessType(value="property")
public class SmsProvider
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String emailSuffix;
    private String subject;
    private String senderEmail;
    private String senderName;
    private SMSProviderType providerType;
    private String url;
    private String prefix;
    private String placeholderMessageKey;
    private String placeholderNumberKey;
    private String placeholder1Key;
    private String placeholder1Value;
    private String placeholder2Key;
    private String placeholder2Value;
    private String placeholder3Key;
    private String placeholder3Value;
    private String placeholder4Key;
    private String placeholder4Value;
    private String placeholder5Key;
    private String placeholder5Value;

    @Column(name="email_suffix")
    public String getEmailSuffix() {
        return this.emailSuffix;
    }

    @Column(name="subject")
    public String getSubject() {
        return this.subject;
    }

    @Column(name="sender_email")
    public String getSenderEmail() {
        return this.senderEmail;
    }

    @Column(name="sender_name")
    public String getSenderName() {
        return this.senderName;
    }

    public static SmsProvider getProvider() {
        ObjectQuery query = Query.select(SmsProvider.class);
        if (PersistenceManager.getPersistenceDelegate().isHeadOffice()) {
            query.equals(SmsProvider.Properties.STORE_ID, 0.0);
        }
        return PersistenceManager.getObject(SmsProvider.class, query.toString(), new Object[0]);
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public void setEmailSuffix(String emailSuffix) {
        this.emailSuffix = emailSuffix;
    }

    public void setSenderEmail(String senderEmail) {
        this.senderEmail = senderEmail;
    }

    public void setSenderName(String senderName) {
        this.senderName = senderName;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="provider_type")
    @Enumerated(value=EnumType.STRING)
    public SMSProviderType getProviderType() {
        return this.providerType;
    }

    public void setProviderType(SMSProviderType providerType) {
        this.providerType = providerType;
    }

    @Column(name="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @Column(name="prefix")
    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    @Column(name="placeholder_message_key")
    public String getPlaceholderMessageKey() {
        return this.placeholderMessageKey;
    }

    public void setPlaceholderMessageKey(String placeholderMessageKey) {
        this.placeholderMessageKey = placeholderMessageKey;
    }

    @Column(name="placeholder_number_key")
    public String getPlaceholderNumberKey() {
        return this.placeholderNumberKey;
    }

    public void setPlaceholderNumberKey(String placeholderNumberKey) {
        this.placeholderNumberKey = placeholderNumberKey;
    }

    @Column(name="placeholder_1_key")
    public String getPlaceholder1Key() {
        return this.placeholder1Key;
    }

    public void setPlaceholder1Key(String placeholder1Key) {
        this.placeholder1Key = placeholder1Key;
    }

    @Column(name="placeholder_1_value")
    public String getPlaceholder1Value() {
        return this.placeholder1Value;
    }

    public void setPlaceholder1Value(String placeholder1Value) {
        this.placeholder1Value = placeholder1Value;
    }

    @Column(name="placeholder_2_key")
    public String getPlaceholder2Key() {
        return this.placeholder2Key;
    }

    public void setPlaceholder2Key(String placeholder2Key) {
        this.placeholder2Key = placeholder2Key;
    }

    @Column(name="placeholder_2_value")
    public String getPlaceholder2Value() {
        return this.placeholder2Value;
    }

    public void setPlaceholder2Value(String placeholder2Value) {
        this.placeholder2Value = placeholder2Value;
    }

    @Column(name="placeholder_3_key")
    public String getPlaceholder3Key() {
        return this.placeholder3Key;
    }

    public void setPlaceholder3Key(String placeholder3Key) {
        this.placeholder3Key = placeholder3Key;
    }

    @Column(name="placeholder_3_value")
    public String getPlaceholder3Value() {
        return this.placeholder3Value;
    }

    public void setPlaceholder3Value(String placeholder3Value) {
        this.placeholder3Value = placeholder3Value;
    }

    @Column(name="placeholder_4_key")
    public String getPlaceholder4Key() {
        return this.placeholder4Key;
    }

    public void setPlaceholder4Key(String placeholder4Key) {
        this.placeholder4Key = placeholder4Key;
    }

    @Column(name="placeholder_4_value")
    public String getPlaceholder4Value() {
        return this.placeholder4Value;
    }

    public void setPlaceholder4Value(String placeholder4Value) {
        this.placeholder4Value = placeholder4Value;
    }

    @Column(name="placeholder_5_key")
    public String getPlaceholder5Key() {
        return this.placeholder5Key;
    }

    public void setPlaceholder5Key(String placeholder5Key) {
        this.placeholder5Key = placeholder5Key;
    }

    @Column(name="placeholder_5_value")
    public String getPlaceholder5Value() {
        return this.placeholder5Value;
    }

    public void setPlaceholder5Value(String placeholder5Value) {
        this.placeholder5Value = placeholder5Value;
    }

    @Transient
    public String getPrefixValidated() {
        String formattedPrefix = "";
        if (!this.prefix.isEmpty()) {
            for (int i = 0; i != this.prefix.length(); ++i) {
                if (!Character.isDigit(this.prefix.charAt(i)) || formattedPrefix.length() <= 0 && this.prefix.charAt(i) == '0') continue;
                formattedPrefix = formattedPrefix + this.prefix.charAt(i);
            }
        }
        return formattedPrefix;
    }

    private boolean IsNumeric(String s) {
        if (s == null) {
            return false;
        }
        if (s.length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isDigit(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static enum SMSProviderType {
        Email,
        HTTP;

        public static final Map<String, SMSProviderType> register;

        public static final Map<String, SMSProviderType> getRegister() {
            return register;
        }

        static {
            register = new HashMap<String, SMSProviderType>();
            for (SMSProviderType type : SMSProviderType.values()) {
                register.put(type.toString(), type);
            }
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property EMAIL_SUFFIX;
        public PropertiedObject.Property SUBJECT;
        public PropertiedObject.Property SENDER_EMAIL;
        public PropertiedObject.Property SENDER_NAME;
        public PropertiedObject.Property<SMSProviderType> PROVIDER_TYPE;
        public PropertiedObject.Property<String> URL;
        public PropertiedObject.Property<String> PREFIX;
        public PropertiedObject.Property<String> PLACEHOLDER_MESSAGE_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_NUMBER_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_1_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_1_VALUE;
        public PropertiedObject.Property<String> PLACEHOLDER_2_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_2_VALUE;
        public PropertiedObject.Property<String> PLACEHOLDER_3_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_3_VALUE;
        public PropertiedObject.Property<String> PLACEHOLDER_4_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_4_VALUE;
        public PropertiedObject.Property<String> PLACEHOLDER_5_KEY;
        public PropertiedObject.Property<String> PLACEHOLDER_5_VALUE;
    }
}

