/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.EventLogWriterI;
import ordermate.database.users.User;

public abstract class AbstractEventLog {
    private String name;
    private EventLogWriterI writer;

    protected AbstractEventLog(EventLogWriterI theWriter, String logName) {
        this.name = logName;
        this.writer = theWriter;
    }

    public abstract List<String> getAllEvents();

    public String getName() {
        return this.name;
    }

    protected EventLogWriterI getWriter() {
        return this.writer;
    }

    protected void logActivity(EventContext context, String theType, String message) {
        if (context.getTerminal() == null) {
            String s = "Terminal cannot be null!";
            throw new IllegalArgumentException(s);
        }
        EventLogRecord record = new EventLogRecord(context, theType, message);
        this.writer.writeLog(record);
    }

    protected void logActivity(User theUser, String theType, String message) {
        EventContext context = new EventContext(null, theUser);
        EventLogRecord record = new EventLogRecord(context, theType, message);
        this.writer.writeLog(record);
    }
}

