/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import java.util.concurrent.LinkedBlockingQueue;
import ordermate.OrderMate;
import ordermate.database.misc.EventLogRecord;
import ordermate.database.misc.EventLogWriterI;

public class AsynchronousEventLogWriter
implements EventLogWriterI {
    private Thread loggingThread;
    private LinkedBlockingQueue<EventLogRecord> safeQueue = new LinkedBlockingQueue();

    private void ensureRunning() {
        if (this.loggingThread == null || !this.loggingThread.isAlive()) {
            this.loggingThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            EventLogRecord eventLog = (EventLogRecord)AsynchronousEventLogWriter.this.safeQueue.take();
                            OrderMate.LOG.info("Tran Journal : " + eventLog.getMessage());
                            eventLog.save();
                        }
                    }
                    catch (InterruptedException ex) {
                        OrderMate.LOG.info("Logging thread interrupted", (Throwable)ex);
                        return;
                    }
                }
            }, "Event Log Writer");
            this.loggingThread.start();
        }
    }

    @Override
    public void writeLog(EventLogRecord record) {
        this.safeQueue.add(record);
        this.ensureRunning();
    }
}

