/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.util.StringUtils;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.integration.BarcodePrefix;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.enums.ItemBarcodeType;

public class BarcodeUtils {
    private static final int EAN_LENGTH_SANS_CHECKSUM = 12;
    private static final int FOUR_DIGIT_PRICE_INDEX = 6;
    private static final int FIVE_DIGIT_PRICE_INDEX = 5;

    public static boolean isBarcodeString(String data) {
        List<BarcodePrefix> prefixes = PersistenceManager.getObjectList(BarcodePrefix.class, Query.select(BarcodePrefix.class).toString());
        for (BarcodePrefix prefix : prefixes) {
            if (prefix.isInternal() || !data.startsWith(prefix.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public static String stripExternalPrefix(String data) {
        List<BarcodePrefix> prefixes = PersistenceManager.getObjectList(BarcodePrefix.class, Query.select(BarcodePrefix.class).equals(BarcodePrefix.Properties.INTERNAL, Boolean.FALSE).toString());
        for (BarcodePrefix prefix : prefixes) {
            if (!data.startsWith(prefix.getPrefix())) continue;
            return data.substring(prefix.getPrefix().length());
        }
        return data;
    }

    public static String stripBarcodeDelimiter(String barcode) {
        if (!BarcodeUtils.isBarcodeString(barcode)) {
            return barcode;
        }
        String toReturn = barcode;
        for (int i = 0; i < barcode.length(); ++i) {
            if (!BarcodeUtils.isNumeric(barcode.charAt(i))) continue;
            toReturn = barcode.substring(i, barcode.length());
            break;
        }
        return toReturn;
    }

    public static boolean isNumeric(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (BarcodeUtils.isNumeric(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(char c) {
        return c >= '0' && c <= '9';
    }

    public static String makeBarcodeString(long value, BarcodePrefixGroup prefixGroup) {
        BarcodePrefix prefix = PersistenceManager.getObject(BarcodePrefix.class, Query.select(BarcodePrefix.class).equals(BarcodePrefix.Properties.NAME, prefixGroup.toString()).toString(), null);
        if (prefix == null) {
            return Long.toString(value);
        }
        StringBuilder SB = new StringBuilder(prefix.getPrefix());
        String valueString = Long.toString(value);
        for (int i = 0; i < 12 - prefix.getPrefix().length() - valueString.length(); ++i) {
            SB.append("0");
        }
        SB.append(value);
        return SB.toString();
    }

    public static BarcodePrefix getInternalPrefix(String data) {
        List<BarcodePrefix> prefixes = PersistenceManager.getObjectList(BarcodePrefix.class, Query.select(BarcodePrefix.class).not().equals(BarcodePrefix.Properties.INTERNAL, Boolean.FALSE).toString(), null);
        for (BarcodePrefix prefix : prefixes) {
            if (StringUtils.isEmpty(prefix.getPrefix()) || !data.startsWith(prefix.getPrefix())) continue;
            return prefix;
        }
        return null;
    }

    public static String stripInternalData(BarcodePrefix prefix, String data) {
        return data.substring(prefix.getPrefix().length(), data.length() - 1);
    }

    public static String getPLUFromInternalBarcode(String dataString, BarcodePrefix prefix) {
        return Integer.valueOf(BarcodeUtils.stripInternalData(prefix, dataString).substring(0, 5)).toString();
    }

    public static Double getPayloadFromInternalBarcode(String dataString, BarcodePrefix prefix) {
        String substring = BarcodeUtils.stripInternalData(prefix, dataString);
        Double payload = null;
        double factor = 100.0;
        boolean asWeight = ItemBarcodeType.Weight.equals((Object)SystemProperty.getInstance().getItemBarcodeType());
        if (asWeight) {
            factor = 1000.0;
        }
        try {
            int beginIndex = SystemProperty.getInstance().isIncludeMiddleChecksum() ? 6 : 5;
            payload = Double.valueOf(substring.substring(beginIndex, substring.length())) / factor;
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Malformed price or weight on open price barcode input:" + dataString, (Throwable)ex);
            payload = null;
        }
        return payload;
    }

    public static String cleanCode(String code) {
        String cleanCode = code;
        BarcodePrefix prefix = BarcodeUtils.getInternalPrefix(cleanCode = BarcodeUtils.stripBarcodeDelimiter(cleanCode));
        if (prefix != null && BarcodePrefixGroup.SalesItem.name().equals(prefix.getName())) {
            cleanCode = BarcodeUtils.getPLUFromInternalBarcode(cleanCode, prefix);
        }
        try {
            cleanCode = Integer.valueOf(cleanCode).toString();
        }
        catch (NumberFormatException ex) {
            OrderMate.LOG.warn("Cannot set the code to a numeric, not a number");
        }
        return cleanCode;
    }

    public static enum BarcodePrefixGroup {
        Account,
        SalesItem,
        Coupon,
        GiftVoucher;

    }
}

