/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.SingletonReference;
import au.com.ordermate.util.Price;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.finance.tax.TaxCode;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_business_detail")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class BusinessInfo
extends PersistentObject
implements Saveable {
    public static final String FORMAT_12_HOURS = "12h";
    public static final String FORMAT_24_HOURS = "24h";
    private static final String DEFAULT_LABEL_REPORT = "/ordermate/reports/labels/ShelfLabelsReport.jrxml";
    public static final Props Properties = new Props();
    private static Reference<BusinessInfo> instance = new SingletonReference<BusinessInfo>(BusinessInfo.class);
    private String name;
    private String abn;
    private String phone;
    private String location;
    private String address1;
    private String address2;
    private String message;
    private String defaultState;
    private String country;
    private int numberOfLines;
    private String phoneAreaCodePrefix;
    private Price defaultFloatAmount;
    private String gstPercentage;
    private String logo;
    private String labelLogo;
    private String labelReport;
    private String docketHourFormat;
    private String menuImportFtpUser;
    private String menuImportFtpPassword;
    private String menuImportFtpServer;
    private String menuImportFtpFolder;
    private String businessNumberType;
    private String gstNum;

    @Column(name="ABN")
    public String getAbn() {
        return this.abn;
    }

    @Column(name="Address_1")
    public String getAddress1() {
        return this.address1;
    }

    @Column(name="Address_2")
    public String getAddress2() {
        return this.address2;
    }

    @Column(name="Location")
    public String getLocation() {
        return this.location;
    }

    @Column(name="Name")
    public String getName() {
        return this.name;
    }

    @Column(name="Phone")
    public String getPhone() {
        return this.phone;
    }

    @Column(name="Message")
    public String getMessage() {
        return this.message;
    }

    @Column(name="Default State")
    public String getDefaultState() {
        return this.defaultState;
    }

    @Column(name="Number Of Delivery Phone Lines")
    public int getNumberOfLines() {
        return this.numberOfLines;
    }

    @Column(name="Area Code")
    public String getPhoneAreaCodePrefix() {
        return this.phoneAreaCodePrefix;
    }

    @Transient
    public Price getDefaultFloatAmount() {
        return this.defaultFloatAmount;
    }

    @Deprecated
    @Column(name="GST")
    public double getGstPercentage() {
        return TaxCode.getGSTPercentage();
    }

    @Column(name="Logo")
    public String getLogo() {
        return this.logo;
    }

    @Column(name="Label logo")
    public String getLabelLogo() {
        if (this.labelLogo == null || this.labelLogo.isEmpty()) {
            return this.logo;
        }
        return this.labelLogo;
    }

    @Column(name="Label report")
    public String getLabelReport() {
        if (this.labelReport == null || this.labelReport.isEmpty()) {
            return DEFAULT_LABEL_REPORT;
        }
        return this.labelReport;
    }

    @Column(name="Docket hour format")
    public String getDocketHourFormat() {
        if (this.docketHourFormat == null || this.docketHourFormat.isEmpty()) {
            this.docketHourFormat = FORMAT_24_HOURS;
        }
        return this.docketHourFormat;
    }

    public void setDocketHourFormat(String docketHourFormat) {
        if (!docketHourFormat.equals(FORMAT_12_HOURS) && !docketHourFormat.equals(FORMAT_24_HOURS)) {
            throw new IllegalArgumentException("The " + docketHourFormat + " is incorrect. Use " + FORMAT_12_HOURS + " or " + FORMAT_24_HOURS);
        }
        this.docketHourFormat = docketHourFormat;
    }

    @Column(name="menu_import_FTP_folder")
    public String getMenuImportFtpFolder() {
        return this.menuImportFtpFolder;
    }

    @Column(name="menu_import_FTP_password")
    public String getMenuImportFtpPassword() {
        return this.menuImportFtpPassword;
    }

    @Column(name="menu_import_FTP_server")
    public String getMenuImportFtpServer() {
        return this.menuImportFtpServer;
    }

    @Column(name="menu_import_FTP_user")
    public String getMenuImportFtpUser() {
        return this.menuImportFtpUser;
    }

    public static BusinessInfo getInstance() {
        return instance.get();
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("Business info is a Singleton so a new instance must not be created.");
        }
        PersistenceManager.save(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Not supported for a singleton.");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void setMenuImportFtpPassword(String menuImportFtpPassword) {
        this.menuImportFtpPassword = menuImportFtpPassword;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setNumberOfLines(int numberOfLines) {
        this.numberOfLines = numberOfLines;
    }

    public void setLabelLogo(String labelLogo) {
        this.labelLogo = labelLogo;
    }

    public void setDefaultState(String defaultState) {
        this.defaultState = defaultState;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public void setMenuImportFtpServer(String menuImportFtpServer) {
        this.menuImportFtpServer = menuImportFtpServer;
    }

    public void setPhoneAreaCodePrefix(String phoneAreaCodePrefix) {
        this.phoneAreaCodePrefix = phoneAreaCodePrefix;
    }

    public void setLabelReport(String labelReport) {
        this.labelReport = labelReport;
    }

    public void setMenuImportFtpUser(String menuImportFtpUser) {
        this.menuImportFtpUser = menuImportFtpUser;
    }

    public void setMenuImportFtpFolder(String menuImportFtpFolder) {
        this.menuImportFtpFolder = menuImportFtpFolder;
    }

    public void setAbn(String abn) {
        this.abn = abn;
    }

    public void setDefaultFloatAmount(Price defaultFloatAmount) {
        this.defaultFloatAmount = defaultFloatAmount;
    }

    public void setGstPercentage(String gstPercentage) {
        this.gstPercentage = gstPercentage;
    }

    public void setGstPercentage(double gstPercentage) {
        this.gstPercentage = "" + gstPercentage;
    }

    @Transient
    public String getAddressString() {
        return this.getAddress1() + "\n" + this.getAddress2();
    }

    @Column(name="Business Number Type")
    public String getBusinessNumberType() {
        return this.businessNumberType;
    }

    public void setBusinessNumberType(String businessNumberType) {
        this.businessNumberType = businessNumberType;
    }

    @Column(name="GST Number")
    public String getGstNum() {
        return this.gstNum;
    }

    public void setGstNum(String gstNum) {
        this.gstNum = gstNum;
    }

    @Column(name="Country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property NAME;
        public PropertiedObject.Property ABN;
        public PropertiedObject.Property PHONE;
        public PropertiedObject.Property LOCATION;
        public PropertiedObject.Property ADDRESS1;
        public PropertiedObject.Property ADDRESS2;
        public PropertiedObject.Property MESSAGE;
        public PropertiedObject.Property DEFAULT_STATE;
        public PropertiedObject.Property COUNTRY;
        public PropertiedObject.Property NUMBER_OF_LINES;
        public PropertiedObject.Property PHONE_AREA_CODE_PREFIX;
        public PropertiedObject.Property DEFAULT_FLOAT_AMOUNT;
        public PropertiedObject.Property GST_PERCENTAGE;
        public PropertiedObject.Property LOGO;
        public PropertiedObject.Property LABEL_LOGO;
        public PropertiedObject.Property LABEL_REPORT;
        public PropertiedObject.Property DOCKET_HOUR_FORMAT;
        public PropertiedObject.Property MENU_IMPORT_FTP_USER;
        public PropertiedObject.Property MENU_IMPORT_FTP_PASSWORD;
        public PropertiedObject.Property MENU_IMPORT_FTP_SERVER;
        public PropertiedObject.Property MENU_IMPORT_FTP_FOLDER;
        public PropertiedObject.Property BUSINESS_NUMBER_TYPE;
        public PropertiedObject.Property GST_NUM;
    }
}

