/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.integration.jaxb.ExportableObject;
import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentDisplayableObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_shift")
@AccessType(value="property")
@AttributeOverride(name="label", column=@Column(name="Name"))
public class ConfigShift
extends PersistentDisplayableObject
implements Saveable,
ExportableObject {
    public static final Props Properties = new Props();
    private Integer sequence;
    private Long masterId;
    private String systemState = "ACTIVE";

    public ConfigShift() {
    }

    private ConfigShift(String name) {
        this.setLabel(name);
        this.setSequence(this.getLastSequence());
    }

    @Column(name="Sequence")
    public Integer getSequence() {
        return this.sequence;
    }

    public static ConfigShift createConfigShift(String name) {
        ConfigShift configShift = new ConfigShift(name);
        configShift.save();
        return configShift;
    }

    public void setSequence(Integer newSequence) {
        if (newSequence == null || newSequence < 0) {
            throw new IllegalArgumentException("Sequence cannot be less than zero");
        }
        this.sequence = newSequence;
    }

    @Transient
    public Integer getLastSequence() {
        String sql = Query.select(ConfigShift.class).orderByDesc(ConfigShift.Properties.SEQUENCE).limit(1).toString();
        ConfigShift shiftConfig = PersistenceManager.getObject(ConfigShift.class, sql, null);
        return shiftConfig.getSequence();
    }

    public static List<ConfigShift> getAllConfigShifts() {
        ObjectQuery query = new ObjectQuery();
        query.select(ConfigShift.class).active(ConfigShift.class);
        return PersistenceManager.getObjectList(ConfigShift.class, query.toString(), null);
    }

    public static ConfigShift getConfigShiftWithName(String name) {
        ObjectQuery query = new ObjectQuery();
        query.select(ConfigShift.class).equals(ConfigShift.Properties.LABEL, name).active(ConfigShift.class);
        return PersistenceManager.getObject(ConfigShift.class, query.toString(), null);
    }

    public static List<String> getAllConfigShiftsNames() {
        List<ConfigShift> allConfigShifts = ConfigShift.getAllConfigShifts();
        ArrayList<String> allConfigShiftsNames = new ArrayList<String>();
        for (ConfigShift configShift : allConfigShifts) {
            allConfigShiftsNames.add(configShift.getLabel());
        }
        return allConfigShiftsNames;
    }

    public static List<Long> getAllConfigShiftIds() {
        List<ConfigShift> allConfigShifts = ConfigShift.getAllConfigShifts();
        ArrayList<Long> allConfigShiftIds = new ArrayList<Long>();
        for (ConfigShift configShift : allConfigShifts) {
            allConfigShiftIds.add(configShift.getID());
        }
        return allConfigShiftIds;
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        this.setSequence(new Integer(9999999));
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    @Column(name="masterId")
    public Long getMasterId() {
        return this.masterId;
    }

    @Override
    public void setMasterId(Long id) {
        this.masterId = id;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    public static class Props
    extends PersistentDisplayableObject.Props {
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<String> SYSTEM_STATE;
        public PropertiedObject.Property<Long> MASTER_ID;
    }
}

