/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import ordermate.database.users.User;

public class ConfigTermsOfServiceUserLink
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String email;
    private Date agreedAt;
    private String version;
    private String userName;
    private Reference<User> user;

    public ConfigTermsOfServiceUserLink() {
        this.user = this.createReference(ConfigTermsOfServiceUserLink.Properties.USER);
    }

    public ConfigTermsOfServiceUserLink(User user, String version) {
        this.user = this.createReference(ConfigTermsOfServiceUserLink.Properties.USER);
        this.userName = user.getFirstName() + " " + user.getLastName();
        this.agreedAt = new Date();
        this.email = user.getEmail();
        this.setUser(user);
        this.version = version;
    }

    public static ConfigTermsOfServiceUserLink getTOSLinkFromUser(User user) {
        ConfigTermsOfServiceUserLink userTOS = PersistenceManager.getObject(ConfigTermsOfServiceUserLink.class, Query.select(ConfigTermsOfServiceUserLink.class).equals(ConfigTermsOfServiceUserLink.Properties.USER, user).orderBy(ConfigTermsOfServiceUserLink.Properties.ID, true).toString());
        if (userTOS == null && user.getEmail() != null) {
            userTOS = PersistenceManager.getObject(ConfigTermsOfServiceUserLink.class, Query.select(ConfigTermsOfServiceUserLink.class).equals(ConfigTermsOfServiceUserLink.Properties.EMAIL, user.getEmail()).orderBy(ConfigTermsOfServiceUserLink.Properties.ID, true).toString());
        }
        if (userTOS == null) {
            String userName = user.getFirstName() + " " + user.getLastName();
            userTOS = PersistenceManager.getObject(ConfigTermsOfServiceUserLink.class, Query.select(ConfigTermsOfServiceUserLink.class).equals(ConfigTermsOfServiceUserLink.Properties.USER_NAME, userName).orderBy(ConfigTermsOfServiceUserLink.Properties.ID, true).toString());
            if (userTOS == null) {
                return null;
            }
            if (userTOS.getEmail() != null && !userTOS.getEmail().isEmpty()) {
                return null;
            }
        }
        if (userTOS.getUser() == null) {
            userTOS.setUser(user);
            userTOS.save();
        }
        if (user.getEmail() != null && !user.getEmail().isEmpty()) {
            userTOS.setEmail(user.getEmail());
            userTOS.save();
        }
        return userTOS;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public Date getAgreedAt() {
        return this.agreedAt;
    }

    public void setAgreedAt(Date agreedAt) {
        this.agreedAt = agreedAt;
    }

    public String getTOSVersion() {
        return this.version;
    }

    public void setTOSVersion(String version) {
        this.version = version;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public User getUser() {
        return this.user.get();
    }

    public void setUser(User user) {
        this.user.set(user);
    }

    @Override
    public String toString() {
        return this.version == null ? "No Version" : this.version;
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> EMAIL;
        public PropertiedObject.Property<Date> AGREED_AT;
        public PropertiedObject.Property<String> VERSION;
        public PropertiedObject.Property<String> USER_NAME;
        public PropertiedObject.Property<User> USER;
    }
}

