/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Iterator;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.course.CourseHoldStrategy;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_course")
@AccessType(value="property")
public class Course
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String name = "No Label";
    private int sequence;
    private boolean defaultCourse;
    private CourseHoldStrategy courseHoldStrategy = CourseHoldStrategy.DISABLED;
    private static String[] courseNames;
    private static LocalCacheListManager<Course> courses;
    private static LocalCachedReference<Course> defaultCourseRef;

    public Course() {
    }

    public Course(String courseName, int seq, boolean defaultcourse) {
        this.name = courseName;
        this.sequence = seq;
        this.defaultCourse = defaultcourse;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    @Column(name="default_course")
    public boolean isDefaultCourse() {
        return this.defaultCourse;
    }

    public void setDefaultCourse(boolean defaultCourse) {
        this.defaultCourse = defaultCourse;
    }

    public void setSequence(int seq) {
        this.sequence = seq;
    }

    @Column(name="course_hold_strategy")
    @Enumerated(value=EnumType.STRING)
    public CourseHoldStrategy getCourseHoldStrategy() {
        return this.courseHoldStrategy;
    }

    public void setCourseHoldStrategy(CourseHoldStrategy courseHoldStrategy) {
        this.courseHoldStrategy = courseHoldStrategy;
    }

    public static synchronized String[] getCourseNames() {
        if (courseNames == null) {
            List<Course> coursesList = courses.getList();
            courseNames = new String[coursesList.size()];
            for (int i = 0; i < coursesList.size(); ++i) {
                Course.courseNames[i] = coursesList.get(i).getName();
            }
        }
        String[] copy = new String[courseNames.length];
        System.arraycopy(courseNames, 0, copy, 0, courseNames.length);
        return copy;
    }

    public static List<Course> getCourses() {
        return courses.getList();
    }

    public static Course getCourse(int index) {
        Course result = null;
        List<Course> courseList = Course.getCourses();
        for (Course course : courseList) {
            if (course.getCourseIndex() != index) continue;
            result = course;
            break;
        }
        return result;
    }

    public static void clearCache() {
        courseNames = null;
        courses.clearCache();
    }

    public static Course getCourseByName(String name) {
        for (Course c : courses.getList()) {
            if (!c.getName().equalsIgnoreCase(name)) continue;
            return c;
        }
        return null;
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.isDefaultCourse()) {
            Course oldDefault = defaultCourseRef.get();
            if (oldDefault != null) {
                oldDefault.setDefaultCourse(false);
                PersistenceManager.save(oldDefault);
            }
            PersistenceManager.save(this);
            defaultCourseRef.collapse();
        } else {
            if (this.equals(defaultCourseRef.get()) || defaultCourseRef.get() == null) {
                this.setDefaultCourse(true);
            }
            PersistenceManager.save(this);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Transient
    public int getCourseIndex() {
        Iterator<Course> it = Course.getCourses().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (((Object)it.next()).equals(this)) {
                return i;
            }
            ++i;
        }
        throw new IllegalArgumentException("This course : " + this + " not found in list of all courses " + Course.getCourses());
    }

    @Transient
    public static Course getDefault() {
        Course defaultCourse = defaultCourseRef.get();
        if (defaultCourse == null && !Course.getCourses().isEmpty()) {
            defaultCourse = Course.getCourses().get(0);
            defaultCourse.setDefaultCourse(true);
            defaultCourse.save();
        }
        return defaultCourse;
    }

    static {
        courses = new LocalCacheListManager<Course>(Query.createQueryList(Course.class, Query.select(Course.class).orderBy(Course.Properties.SEQUENCE)));
        defaultCourseRef = new LocalCachedReference<Course>(new QueryReference<Course>(Course.class, Query.select(Course.class).equals(Course.Properties.DEFAULT_COURSE, 1.0)));
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Integer> SEQUENCE;
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<Boolean> DEFAULT_COURSE;
        public PropertiedObject.Property<CourseHoldStrategy> COURSE_HOLD_STRATEGY;
    }
}

