/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import ordermate.OrderMate;
import ordermate.database.dbconstants.SystemState;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_store_custom_parameter")
@AccessType(value="property")
public class CustomParameter
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String category;
    private String name;
    private String value;
    private String systemState = "ACTIVE";

    @Deprecated
    public CustomParameter() {
    }

    public CustomParameter(String paramCategory, String paramName, String paramValue) {
        this.category = paramCategory;
        this.name = paramName;
        this.value = paramValue;
    }

    @Column(name="category")
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    @Column(name="name")
    public String getName() {
        return this.name;
    }

    @Column(name="value")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Column(name="system_state")
    public String getSystemState() {
        return this.systemState;
    }

    public void setSystemState(String systemState) {
        this.systemState = systemState;
    }

    @Override
    public void delete() {
        this.setSystemState("DELETED");
        this.save();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    public static CustomParameter getCustomParameter(String category, String name) {
        return PersistenceManager.getObject(CustomParameter.class, Query.select(CustomParameter.class).equals(CustomParameter.Properties.CATEGORY, category).equals(CustomParameter.Properties.NAME, name).toString());
    }

    public Boolean getBoolean(Boolean defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return Boolean.valueOf(this.value);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot parse " + this.category + " " + this.name + " as a Boolean: " + this.value);
            return defaultValue;
        }
    }

    public Long getLong(Long defaultValue) {
        if (this.value == null) {
            return defaultValue;
        }
        try {
            return Long.valueOf(this.getValue());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Cannot parse " + this.category + " " + this.name + " as a Long: " + this.value);
            return defaultValue;
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> CATEGORY;
        public PropertiedObject.Property<String> NAME;
        public PropertiedObject.Property<String> VALUE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
    }
}

