/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

@Entity
@Table(name="config_day_part")
public class DayPart
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private Date startTime;
    private static List<DayPart> cachedList;

    public DayPart() {
    }

    public DayPart(DayPart toCopy) {
        this(toCopy.getLabel(), toCopy.getStartTime());
    }

    private DayPart(String label, Date startTime) {
        this.label = label;
        this.startTime = startTime;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="start_time")
    @Temporal(value=TemporalType.TIME)
    public Date getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Date newStartTime) {
        this.startTime = newStartTime;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public String toString() {
        if (this.label == null) {
            return "No Label";
        }
        return this.label;
    }

    public boolean equalsTimeRange(Date startDate, Date endDate) {
        if (startDate == null || endDate == null) {
            return false;
        }
        if (this.startTime.equals(DateTimeUtils.cleanDatePart(startDate))) {
            return this.getEndTime().equals(DateTimeUtils.cleanDatePart(endDate));
        }
        return false;
    }

    @Transient
    public Date getEndTime() {
        int index;
        List<DayPart> parts = PersistenceManager.getObjectList(DayPart.class, Query.select(DayPart.class).orderBy(DayPart.Properties.START_TIME).toString());
        DayPart part = null;
        part = parts == null || parts.isEmpty() ? this : ((index = parts.indexOf(this)) == parts.size() - 1 ? parts.get(0) : parts.get(index + 1));
        Calendar cal = Calendar.getInstance();
        cal.setTime(part.getStartTime());
        cal.add(12, -1);
        cal.set(13, 59);
        return cal.getTime();
    }

    public static List<DayPart> getAllDayPartsCached() {
        if (cachedList == null) {
            cachedList = DayPart.getAllDayParts(true);
        }
        return cachedList;
    }

    public static List<DayPart> getAllDayParts(boolean ordered) {
        ObjectQuery query = Query.select(DayPart.class);
        if (ordered) {
            query.orderBy(DayPart.Properties.START_TIME);
        }
        return PersistenceManager.getObjectList(DayPart.class, query.toString());
    }

    public static List<DayPart> getAllDayPartsOrdered(boolean desc) {
        if (desc) {
            return PersistenceManager.getObjectList(DayPart.class, Query.select(DayPart.class).orderBy(DayPart.Properties.START_TIME, true).toString());
        }
        return DayPart.getAllDayParts(true);
    }

    public static boolean isDayPartsDefined() {
        List<DayPart> dayParts = DayPart.getAllDayPartsOrdered(true);
        return dayParts != null && !dayParts.isEmpty();
    }

    private static Date getDateTime(Date date, Date time) {
        Calendar dateCal = DateTimeUtils.getCalendar(date);
        Calendar timeCal = DateTimeUtils.getCalendar(time);
        dateCal.set(11, timeCal.get(11));
        dateCal.set(12, timeCal.get(12));
        dateCal.set(13, timeCal.get(13));
        return dateCal.getTime();
    }

    public static Date[] getQuantityDayPartRange(Date quantityCreationTime, Date dayPartStartTime, Date dayPartEndTime) {
        Calendar dayPartStartCal = DateTimeUtils.getCalendar(quantityCreationTime);
        Calendar startTimeCal = DateTimeUtils.getCalendar(dayPartStartTime);
        dayPartStartCal.set(11, startTimeCal.get(11));
        dayPartStartCal.set(12, startTimeCal.get(12));
        dayPartStartCal.set(13, startTimeCal.get(13));
        Date dayPartStartDT = dayPartStartCal.getTime();
        Calendar dayPartEndCal = DateTimeUtils.getCalendar(quantityCreationTime);
        if (dayPartEndTime.compareTo(dayPartStartTime) < 0) {
            dayPartEndCal.add(5, 1);
        }
        Calendar endTimeCal = DateTimeUtils.getCalendar(dayPartEndTime);
        dayPartEndCal.set(11, endTimeCal.get(11));
        dayPartEndCal.set(12, endTimeCal.get(12));
        dayPartEndCal.set(13, endTimeCal.get(13));
        Date dayPartEndDT = dayPartEndCal.getTime();
        Date[] dateTimeRange = new Date[]{dayPartStartDT, dayPartEndDT};
        return dateTimeRange;
    }

    public static DayPart getDayPart(Date quantityCreationTime) {
        List<DayPart> dayParts = DayPart.getAllDayPartsOrdered(false);
        Date earlistDayPartDT = DayPart.getDateTime(quantityCreationTime, dayParts.get(0).getStartTime());
        if (quantityCreationTime.compareTo(earlistDayPartDT) < 0) {
            return dayParts.get(dayParts.size() - 1);
        }
        for (DayPart dayPart : dayParts) {
            Date[] dayPartRange = DayPart.getQuantityDayPartRange(quantityCreationTime, dayPart.getStartTime(), dayPart.getEndTime());
            Date dpStartTime = dayPartRange[0];
            Date dpEndTime = dayPartRange[1];
            if (quantityCreationTime.compareTo(dpStartTime) < 0 || quantityCreationTime.compareTo(dpEndTime) >= 0) continue;
            return dayPart;
        }
        return null;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<Date> START_TIME;
    }
}

