/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.DayPart;

public enum DayPartHelper {
    INSTANCE;

    public static final String allDayFlag = "All Day";
    public static final String allDayID = "null";

    public String getSelectDayPartQuery(String timeParam) {
        List<DayPart> dayParts = DayPart.getAllDayPartsOrdered(true);
        StringBuilder sb = new StringBuilder("(CASE ");
        if (dayParts.isEmpty()) {
            OrderMate.LOG.warn("There is no day part defined in the system, you cannot create select daypart query!");
            sb.append("WHEN (TIME(").append(timeParam).append(") BETWEEN TIME('").append("00:00:00").append("') ").append("AND TIME('").append("23:59:59").append("') ").append(") THEN '").append(allDayFlag).append("' ").append("END) AS day_part ");
        } else {
            int i = dayParts.size();
            for (DayPart part : dayParts) {
                sb.append("WHEN (TIME(").append(timeParam).append(") BETWEEN TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getStartTime())).append("') ").append("AND TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getEndTime())).append("') ").append(") THEN '").append(i).append(".").append(part.getLabel()).append("' ");
                --i;
            }
            sb.append("ELSE '").append(dayParts.size()).append(".").append(dayParts.get(0).getLabel()).append("' END) AS day_part ");
        }
        return sb.toString();
    }

    public String getSelectDayPartAsIDQuery(String timeParam) {
        List<DayPart> dayParts = DayPart.getAllDayPartsOrdered(true);
        StringBuilder sb = new StringBuilder("(CASE ");
        if (dayParts.isEmpty()) {
            OrderMate.LOG.warn("There is no day part defined in the system, you cannot create select daypart query!");
            sb.append("WHEN (TIME(").append(timeParam).append(") BETWEEN TIME('").append("00:00:00").append("') ").append("AND TIME('").append("23:59:59").append("') ").append(") THEN ").append(allDayID).append(" ").append("END) AS fk_config_day_part ");
        } else {
            int i = dayParts.size();
            for (DayPart part : dayParts) {
                sb.append("WHEN (TIME(").append(timeParam).append(") BETWEEN TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getStartTime())).append("') ").append("AND TIME('").append(DateTimeUtils.getSQLTimeFormat().format(part.getEndTime())).append("') ").append(") THEN '").append(part.getID()).append("' ");
                --i;
            }
            sb.append("ELSE '").append(dayParts.get(0).getID()).append("' END) AS fk_config_day_part ");
        }
        return sb.toString();
    }

    public Long getDayPartIDFor(Date time) {
        DayPart part = DayPart.getDayPart(time);
        if (part == null) {
            return -1L;
        }
        return part.getID();
    }
}

