/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.sql.Time;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.EventContext;
import ordermate.database.finance.Shift;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.TradingDay;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="system_log")
@AccessType(value="property")
public class EventLogRecord
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Reference<User> user;
    private Reference<Terminal> terminal;
    private Reference<TradingDay> tradingDay;
    private Reference<Shift> shift;
    private Date eventDate;
    private Time eventTime;
    private String type;
    private String message;

    public EventLogRecord(EventContext context, String newType, String newMessage) {
        this.user = this.createReference(EventLogRecord.Properties.USER);
        this.terminal = this.createReference(EventLogRecord.Properties.TERMINAL);
        this.tradingDay = this.createReference(EventLogRecord.Properties.TRADING_DAY);
        this.shift = this.createReference(EventLogRecord.Properties.SHIFT);
        this.user.set(context.getUser());
        this.terminal.set(context.getTerminal());
        this.tradingDay.set(context.getTradingDay());
        this.shift.set(context.getShift());
        this.type = newType;
        this.message = newMessage;
    }

    public EventLogRecord() {
        this.user = this.createReference(EventLogRecord.Properties.USER);
        this.terminal = this.createReference(EventLogRecord.Properties.TERMINAL);
        this.tradingDay = this.createReference(EventLogRecord.Properties.TRADING_DAY);
        this.shift = this.createReference(EventLogRecord.Properties.SHIFT);
    }

    @Column(name="event_date")
    @Temporal(value=TemporalType.DATE)
    public Date getEventDate() {
        return this.eventDate;
    }

    @Transient
    public Time getEventTime() {
        return this.eventTime;
    }

    @Column(name="type")
    public String getType() {
        return this.type;
    }

    @Column(name="message")
    public String getMessage() {
        return this.message;
    }

    @ManyToOne
    @JoinColumn(name="FK_config_user")
    public User getUser() {
        return this.user.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_config_terminal")
    public Terminal getTerminal() {
        return this.terminal.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getTradingDay() {
        return this.tradingDay.get();
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_shift")
    public Shift getShift() {
        return this.shift.get();
    }

    @Override
    public void save() {
        if (this.eventDate == null) {
            this.eventDate = new Date();
        }
        if (this.eventTime == null) {
            this.eventTime = new Time(System.currentTimeMillis());
        }
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("EventLogRecords cannot be deleted.");
    }

    @Override
    public boolean hasChanged() {
        return this.isPersistent();
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    protected void setShift(Shift shift) {
        this.shift.set(shift);
    }

    protected void setMessage(String message) {
        this.message = message;
    }

    protected void setTerminal(Terminal terminal) {
        this.terminal.set(terminal);
    }

    protected void setTradingDay(TradingDay tradingDay) {
        this.tradingDay.set(tradingDay);
    }

    protected void setType(String type) {
        this.type = type;
    }

    protected void setUser(User user) {
        this.user.set(user);
    }

    public void setEventDate(Date eventDate) {
        this.eventDate = eventDate;
    }

    public void setEventTime(Time eventTime) {
        this.eventTime = eventTime;
    }

    @Transient
    public String getShiftLabel() {
        if (this.getShift() == null) {
            return "";
        }
        return this.getShift().getLabel();
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<User> USER;
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<String> TYPE;
        public PropertiedObject.Property<String> MESSAGE;
        public PropertiedObject.Property<TradingDay> TRADING_DAY;
        public PropertiedObject.Property<Shift> SHIFT;
        public PropertiedObject.Property<Time> EVENT_TIME;
        public PropertiedObject.Property<Date> EVENT_DATE;
        public PersistentObject.DerivedProperty<String> SHIFT_LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)EventLogRecord.class), "shiftLabel");
    }
}

