/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.database.misc.StoreGroup;

@Entity
@Table(name="config_ho")
public class HOConfig
extends PersistentObject
implements Saveable {
    private static Reference<HOConfig> instance = new LocalCachedReference<HOConfig>(new QueryReference<HOConfig>(HOConfig.class, Query.select(HOConfig.class)));
    public static final Props Properties = new Props();
    private boolean enabled;
    private String serverLocation;
    private long timeDifference;
    private Date lastCustomerUpdate;
    private int syncSendDelayMs;
    private boolean menuMasterSite;
    private boolean multisiteCustomers;
    private boolean ignorePricesOnImport;
    private int maxIdsPerVerMsg;
    private boolean hoLite = false;
    private Date lastMenuImportTime;

    public static synchronized HOConfig getInstance() {
        return instance.get();
    }

    @Deprecated
    public HOConfig() {
    }

    @Transient
    public boolean isConfigured() {
        return this.enabled && StoreGroup.getInstance() != null && StoreGroup.getInstance().getStoreId() != null;
    }

    @Column(name="enabled")
    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean value) {
        this.enabled = value;
    }

    @Column(name="server_location")
    public String getServerLocation() {
        return this.serverLocation;
    }

    public void setServerLocation(String value) {
        this.serverLocation = value;
        if (this.serverLocation != null && !this.serverLocation.isEmpty() && !this.serverLocation.endsWith("/")) {
            this.serverLocation = this.serverLocation.concat("/");
        }
    }

    @Column(name="time_difference")
    public long getTimeDifference() {
        return this.timeDifference;
    }

    public void setTimeDifference(long value) {
        this.timeDifference = value;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_customer_update")
    public Date getLastCustomerUpdate() {
        return this.lastCustomerUpdate;
    }

    public void setLastCustomerUpdate(Date value) {
        this.lastCustomerUpdate = value;
    }

    @Column(updatable=true, name="sync_send_delay_ms")
    public int getSyncSendDelayMs() {
        return this.syncSendDelayMs;
    }

    public void setSyncSendDelayMs(int syncSendDelayMs) {
        this.syncSendDelayMs = syncSendDelayMs;
    }

    @Transient
    public Date getRelativeDate(long time) {
        return new Date(time + this.timeDifference);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="menu_master_site")
    public boolean isMenuMasterSite() {
        return this.menuMasterSite;
    }

    public void setMenuMasterSite(boolean menuMasterSite) {
        this.menuMasterSite = menuMasterSite;
    }

    @Column(name="multisite_customers")
    public boolean isMultisiteCustomers() {
        return this.multisiteCustomers;
    }

    public void setMultisiteCustomers(boolean value) {
        this.multisiteCustomers = value;
    }

    @Column(name="ignore_prices_on_import")
    public boolean isIgnorePricesOnImport() {
        return this.ignorePricesOnImport;
    }

    public void setIgnorePricesOnImport(boolean ignorePricesOnImport) {
        this.ignorePricesOnImport = ignorePricesOnImport;
    }

    @Column(name="max_ids_per_ver_msg")
    public int getMaxIdsPerVerMsg() {
        return this.maxIdsPerVerMsg;
    }

    public void setMaxIdsPerVerMsg(int maxIdsPerVerMsg) {
        this.maxIdsPerVerMsg = maxIdsPerVerMsg;
    }

    @Column(name="ho_lite")
    public boolean isHoLite() {
        return this.hoLite;
    }

    public void setHoLite(boolean value) {
        this.hoLite = value;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="last_menu_import_time")
    public Date getLastMenuImportTime() {
        return this.lastMenuImportTime;
    }

    public void setLastMenuImportTime(Date value) {
        this.lastMenuImportTime = value;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property ENABLED;
        public PropertiedObject.Property<String> SERVER_LOCATION;
        public PropertiedObject.Property TIME_DIFFERENCE;
        public PropertiedObject.Property<Date> LAST_CUSTOMER_UPDATE;
        public PropertiedObject.Property SYNC_SEND_DELAY_MS;
        public PropertiedObject.Property MENU_MASTER_SITE;
        public PropertiedObject.Property MULTISITE_CUSTOMERS;
        public PropertiedObject.Property<Boolean> IGNORE_PRICES_ON_IMPORT;
        public PropertiedObject.Property<Integer> MAX_IDS_PER_VER_MSG;
        public PropertiedObject.Property<Boolean> HO_LITE;
        public PropertiedObject.Property<Date> LAST_MENU_IMPORT_TIME;
    }
}

