/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.persistence.Auditable;
import au.com.ordermate.util.DateDMY;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.group.DebtorGroup;
import ordermate.database.inventory.InventoryCategory;
import ordermate.database.misc.AbstractEventLog;
import ordermate.database.misc.AsynchronousEventLogWriter;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.stock.StockInvoice;
import ordermate.database.users.User;

public final class OfficeMateEventLog
extends AbstractEventLog {
    private static final List<String> allEvents = new ArrayList<String>();
    private static OfficeMateEventLog instance = new OfficeMateEventLog();
    public static final String OFFICEMATE_DELETION = "OfficeMate deletion";
    public static final String OFFICEMATE_SAVED = "OfficeMate saved";
    public static final String OFFICEMATE_CREATION = "OfficeMate creation";
    public static final String STOCK_EXPORT_CUSTOMER_ACCOUNTS = "Export Customer Accounts";
    private static final String ACC_EXPORT = "Accounting Export";
    private static final String EMAIL_PURCHASE_ORDER = "Email Purchase Order";
    public static final String CREATE_MENU_CATEGORY = "Create Menu Category";
    public static final String DELETE_MENU_CATEGORY = "Delete Menu Category";

    private OfficeMateEventLog() {
        super(new AsynchronousEventLogWriter(), "OfficeMate Events");
        if (TerminalEventLog.getInst() != null) {
            TerminalEventLog.initInstance(this.getWriter());
        }
        allEvents.add(OFFICEMATE_DELETION);
        allEvents.add(STOCK_EXPORT_CUSTOMER_ACCOUNTS);
        allEvents.add(ACC_EXPORT);
        allEvents.add(EMAIL_PURCHASE_ORDER);
        allEvents.add(CREATE_MENU_CATEGORY);
        allEvents.add(DELETE_MENU_CATEGORY);
    }

    @Override
    public List<String> getAllEvents() {
        return allEvents;
    }

    public static synchronized OfficeMateEventLog getInst() {
        return instance;
    }

    public void logObjectDeletion(Object obj, User user) {
        String msg = obj + " was deleted by user " + user;
        this.logActivity(user, OFFICEMATE_DELETION, msg);
    }

    public void logObjectSaved(Object updatedObj, User user) {
        String name = updatedObj.getClass().getSimpleName();
        String objDetail = updatedObj.toString();
        if (updatedObj instanceof Auditable) {
            Auditable auditableObject = (Auditable)updatedObj;
            objDetail = auditableObject.getLogDetail();
            name = auditableObject.getAuditName();
        }
        String msg = name + " - " + objDetail + " was saved by user " + user;
        this.logActivity(user, OFFICEMATE_SAVED, msg);
    }

    public void logObjectCreation(Object newObj, User user) {
        String name = newObj.getClass().getSimpleName();
        if (newObj instanceof Auditable) {
            Auditable auditableObject = (Auditable)newObj;
            name = auditableObject.getAuditName();
        }
        String msg = "A new " + name + " was created by user " + user;
        this.logActivity(user, OFFICEMATE_CREATION, msg);
    }

    public void logObjectDeletion(Collection objects, User user) {
        if (objects == null || objects.size() == 0) {
            return;
        }
        StringBuilder SB = new StringBuilder();
        for (Object nextObj : objects) {
            SB.append(nextObj).append(", ");
        }
        SB.replace(SB.length() - 2, SB.length(), "");
        SB.append(objects.size() > 1 ? " were" : " was");
        SB.append(" deleted by user : ").append(user);
        this.logActivity(user, OFFICEMATE_DELETION, SB.toString());
    }

    public static void logExportCustomerAccounts(User user, AbstractDebtor debtor, Price totalExported, String filename, Date from, Date to, DebtorGroup forGroup) {
        String msgString = "Customer account data successfully exported:\nCustomer: " + (debtor != null ? debtor.getLabel() : "(All)") + "\nTotal: " + new Price(totalExported, 0.0) + "\nFile: \"" + filename + "\"\nDate range: " + new DateDMY(from) + " to " + new DateDMY(to) + "\nAcct group: " + (forGroup != null ? forGroup.getLabel() : "(All)");
        OfficeMateEventLog.getInst().logActivity(user, STOCK_EXPORT_CUSTOMER_ACCOUNTS, msgString);
    }

    private static String create(String toCreate) {
        allEvents.add(toCreate);
        return toCreate;
    }

    public static void logAccountingExportEvent(String desc, Date startDate, Date endDate, EventContext context) {
        StringBuilder SB = new StringBuilder().append(desc).append(" for ").append(DateTimeUtils.getShortDateFormat().format(startDate)).append(" to ").append(DateTimeUtils.getShortDateFormat().format(endDate));
        try {
            OfficeMateEventLog.getInst().logActivity(context, ACC_EXPORT, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Accounting Export activity: " + context, (Throwable)ex);
        }
    }

    public void logEmailPurchaseOrder(StockInvoice invoice, EventContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append("Purchase Order ").append(invoice.getOrderNumber());
        sb.append(" emailed to ").append(invoice.getSupplier().getName());
        sb.append(" at ").append(invoice.getSupplier().getEmail());
        try {
            this.logActivity(context, EMAIL_PURCHASE_ORDER, sb.toString());
        }
        catch (Exception e) {
            OrderMate.LOG.warn("Exception while logging Email sent to Purchase Order: " + context, (Throwable)e);
        }
    }

    public static void logCreateMenuCategory(User user, InventoryCategory category) {
        OfficeMateEventLog.getInst().logActivity(user, CREATE_MENU_CATEGORY, "User " + user.getName() + " created menu category \"" + category.getLabel() + "\"");
    }

    public static void logDeleteMenuCategory(User user, InventoryCategory category) {
        OfficeMateEventLog.getInst().logActivity(user, DELETE_MENU_CATEGORY, "User " + user.getName() + " deleted menu category \"" + category.getLabel() + "\"");
    }
}

