/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.util.IPAddressUtils;
import au.com.ordermate.util.MACAddress;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.VirtualPrinter;
import ordermate.database.hardware.physical.Camera;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.hardware.physical.Device;
import ordermate.database.hardware.physical.PhysicalPrinter;
import ordermate.database.hardware.physical.PoleDisplay;
import ordermate.database.hardware.physical.ProximityReader;
import ordermate.database.hardware.physical.VirtualEftpos;
import ordermate.database.hardware.physical.callerid.CallerIDUnit;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.SystemVersionHistory;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.queries.hardware.TerminalQueries;
import ordermate.database.stock.StockControlProperty;

public class OrderMateInfo {
    public String getVersion() {
        return OrderMate.VERSION;
    }

    public String getABN() {
        return BusinessInfo.getInstance().getAbn();
    }

    public String getBusinessName() {
        return BusinessInfo.getInstance().getName();
    }

    public String getBusinessPhone() {
        return BusinessInfo.getInstance().getPhone();
    }

    public String getBusinessLocation() {
        return BusinessInfo.getInstance().getLocation();
    }

    public String getBusinessAddressLine1() {
        return BusinessInfo.getInstance().getAddress1();
    }

    public String getBusinessAddressLine2() {
        return BusinessInfo.getInstance().getAddress2();
    }

    public int getDatamateLevel() {
        return OrderMate.REQUIRED_DATABASE_VERSION();
    }

    public String getDatabaseName() {
        return Config.getStringValue("database_name");
    }

    public String getLocalIPAddress() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            OrderMate.LOG.warn("Could not get local host to resolve local IP address", (Throwable)ex);
            return "";
        }
    }

    public Iterator getMacAddresses() {
        Iterator<String> macAddressIt = MACAddress.getMacAddress().iterator();
        return macAddressIt;
    }

    public String getMacAddressesCommaSeperated() {
        StringBuilder retVal = new StringBuilder("");
        Iterator macAddressIt = this.getMacAddresses();
        while (macAddressIt.hasNext()) {
            String macAddressString = macAddressIt.next().toString();
            if (macAddressString.startsWith("000000")) continue;
            retVal.append(macAddressString);
            if (!macAddressIt.hasNext()) continue;
            retVal.append(" , ");
        }
        return retVal.toString();
    }

    public int getNumWaitermateTerminals() {
        return Terminal.getAllWaiterMateTerminals().size();
    }

    public int getNumHomeDeliver() {
        return TerminalQueries.getTerminalModesWithDelivery().size();
    }

    public boolean isStockControlEnabled() {
        return StockControlProperty.getInstance().isStockControlEnabled();
    }

    public List<SystemVersionHistory> getVersionHistory() {
        return PersistenceManager.getObjectList(SystemVersionHistory.class, Query.select(SystemVersionHistory.class).orderByDesc(SystemVersionHistory.Properties.FIRST_USED).toString());
    }

    public static String getInfoString() {
        OrderMateInfo info = new OrderMateInfo();
        StringBuilder builder = new StringBuilder();
        builder.append(info.getSystemSummary());
        builder.append(info.getLicensingDetails());
        builder.append(info.getDocketDetails());
        builder.append(info.getDeviceDetails());
        builder.append(info.getSystemProperties());
        builder.append(info.getTerminalConfigurations());
        builder.append(info.getVersionHistoryInfo());
        return builder.toString();
    }

    protected String getSystemSummary() {
        StringBuilder SB = new StringBuilder("\r\n\r\nSystem Summary\r\n----------------");
        SB.append("\r\nVersion:\t");
        SB.append(this.getVersion());
        SB.append("\r\nBusiness:\t");
        SB.append(this.getBusinessName());
        SB.append("\r\n" + BusinessInfo.getInstance().getBusinessNumberType() + ":\t");
        SB.append(this.getABN());
        SB.append("\r\nLocation:\t");
        SB.append(this.getBusinessLocation());
        SB.append("\r\nAddress:\t");
        SB.append(this.getBusinessAddressLine1());
        SB.append("\r\n\t");
        SB.append(this.getBusinessAddressLine2());
        SB.append("\r\nPhone:\t");
        SB.append(this.getBusinessPhone());
        SB.append("\r\n\r\n# Waitermate :\t");
        SB.append(this.getNumWaitermateTerminals());
        SB.append("\r\nStore Id:\t");
        SB.append(this.getStoreId());
        SB.append("\r\nUpdatemate Id:\t");
        SB.append(this.getUpdatemateId());
        SB.append("\r\n# Delivery :\t");
        SB.append(this.getNumHomeDeliver());
        SB.append("\r\nStock Ctrl Enabled :\t");
        SB.append(this.isStockControlEnabled());
        SB.append("\r\nLiquorfile Enabled :\t");
        SB.append(SystemProperty.getInstance().isLiquorfileEnabled());
        SB.append("\r\nProperty Management Enabled :\t");
        SB.append(SystemProperty.getInstance().isPropertyManagementIntegrationEnabled());
        SB.append("\r\n\r\nDB Level:\t");
        SB.append(this.getDatamateLevel());
        SB.append("\r\nDB Name :\t");
        SB.append(this.getDatabaseName());
        SB.append("\r\n\r\nMAC :\t");
        SB.append(this.getMacAddressesCommaSeperated());
        String ipAddr = this.getLocalIPAddress();
        if (!ipAddr.equals("")) {
            SB.append("\r\nLocal IP :\t");
            SB.append(this.getLocalIPAddress());
        }
        SB.append("\r\nExternal IP :\t");
        SB.append(IPAddressUtils.getIPAddress());
        SB.append("\r\n\r\nDate :\t");
        SB.append(new Date());
        SB.append("\r\n");
        return SB.toString();
    }

    private Long getStoreId() {
        return SystemCurrentInfo.getInstance().getRedbackId();
    }

    private Long getUpdatemateId() {
        return SystemCurrentInfo.getInstance().getUpdatemateId();
    }

    private String getLicensingDetails() {
        PersistentLicenseManager license = PersistentLicenseManager.getInstance();
        StringBuilder SB = new StringBuilder("\r\n\r\nLicensing\r\n----------------");
        for (LicenseType type : LicenseType.values()) {
            SB.append("\r\n").append(type.getDescription()).append(" :\t").append(license.getLicenseValue(type));
        }
        return SB.toString();
    }

    private String getDeviceDetails() {
        StringBuilder SB = new StringBuilder("\r\n\r\nDevices\r\n----------------");
        SB.append("\r\n\r\nTerminals\r\n----------------");
        List<Terminal> terminals = Terminal.getAllTerminals();
        for (Terminal terminal : terminals) {
            SB.append("\r\n");
            SB.append(terminal.getIPAddress());
            SB.append("\t");
            SB.append(terminal.getLabel());
            SB.append("\t");
            SB.append(terminal.getTerminalType());
        }
        SB.append("\r\n\r\nPrinters\r\n----------------");
        List<PhysicalPrinter> printers = PhysicalPrinter.getAllPrinters();
        for (PhysicalPrinter physicalPrinter : printers) {
            this.appendDevice(SB, physicalPrinter);
            SB.append("\t");
            SB.append((Object)physicalPrinter.getEncoding());
        }
        SB.append("\r\n\r\nCashDrawers\r\n----------------");
        List<CashDrawer> list = PersistenceManager.getObjectList(CashDrawer.class, Query.select(CashDrawer.class).active(CashDrawer.class).toString());
        for (CashDrawer cashDrawer : list) {
            this.appendDevice(SB, cashDrawer);
            SB.append("\t");
            SB.append(cashDrawer.getKickerType());
        }
        SB.append("\r\n\r\nProximity Readers\r\n----------------");
        List<ProximityReader> list2 = PersistenceManager.getObjectList(ProximityReader.class, Query.select(ProximityReader.class).toString());
        for (ProximityReader proximityReader : list2) {
            this.appendDevice(SB, proximityReader);
        }
        SB.append("\r\n\r\nCaller ID Units\r\n----------------");
        List<CallerIDUnit> list3 = PersistenceManager.getObjectList(CallerIDUnit.class, Query.select(CallerIDUnit.class).toString());
        for (CallerIDUnit callerIDUnit : list3) {
            this.appendDevice(SB, callerIDUnit);
        }
        SB.append("\r\n\r\nCamera\r\n----------------");
        List<Camera> list4 = PersistenceManager.getObjectList(Camera.class, Query.select(Camera.class).toString());
        for (Camera camera : list4) {
            this.appendDevice(SB, camera);
        }
        SB.append("\r\n\r\nPole Displays\r\n----------------");
        List<PoleDisplay> list5 = PersistenceManager.getObjectList(PoleDisplay.class, Query.select(PoleDisplay.class).toString());
        for (PoleDisplay pole : list5) {
            this.appendDevice(SB, pole);
        }
        SB.append("\r\n\r\nEftpos Terminals\r\n----------------");
        List<VirtualEftpos> list6 = PersistenceManager.getObjectList(VirtualEftpos.class, Query.select(VirtualEftpos.class).active(VirtualEftpos.class).toString());
        for (VirtualEftpos vEft : list6) {
            SB.append("\r\n");
            SB.append(vEft.getLabel());
            SB.append("\t");
            SB.append(vEft.getIpAddress());
            SB.append("\t");
            SB.append(vEft.getPort());
            SB.append("\t");
            SB.append(vEft.getFileSwapDirectory());
            SB.append("\t");
        }
        return SB.toString();
    }

    private String getDocketDetails() {
        SystemProperty instance = SystemProperty.getInstance();
        StringBuilder SB = new StringBuilder("\r\n\r\nDockets\r\n----------------");
        SB.append("\r\nPrep Docket :\t");
        SB.append(instance.getPrepDocketLocation());
        SB.append("\r\nReceipt Docket :\t");
        SB.append(instance.getReceiptDocketLocation());
        SB.append("\r\nDebtor Docket :\t");
        SB.append(instance.getDebtorDocketLocation());
        SB.append("\r\nReservations Docket :\t");
        SB.append(instance.getReservationsDocketLocation());
        SB.append("\r\nSales Docket :\t");
        SB.append(instance.getSalesDocketLocation());
        SB.append("\r\nSkims Docket :\t");
        SB.append(instance.getSkimsDocketLocation());
        SB.append("\r\nTakings Docket :\t");
        SB.append(instance.getTakingsDocketLocation());
        List<VirtualPrinter> vPrinters = VirtualPrinter.getAllPrinters();
        for (VirtualPrinter vPrinter : vPrinters) {
            String prep = vPrinter.getPrepDocketFile();
            if (prep == null || prep.trim().length() <= 0) continue;
            SB.append("\r\nVirtual Printer - ");
            SB.append(vPrinter.getLabel());
            SB.append(" :\tPrep Docket : ");
            SB.append(prep);
        }
        return SB.toString();
    }

    private void appendDevice(StringBuilder SB, Device device) {
        SB.append("\r\n");
        SB.append(device.getLabel());
        SB.append("\t");
        if (device.getHost() != null) {
            SB.append(device.getHost().getLabel());
        } else {
            SB.append("Host=null");
        }
        SB.append("\t");
        SB.append(device.getPort());
        SB.append("\t");
        SB.append(device.getPortSpeed());
        SB.append("\t");
        SB.append(device.getPortType());
        SB.append("\t");
        SB.append(device.getFlowControl());
    }

    private String getSystemProperties() {
        StringBuilder SB = new StringBuilder("\r\n\r\nSystem Properties\r\n----------------");
        Iterator<PropertiedObject.Property> it = SystemProperty.Properties.iterator();
        SystemProperty instance = SystemProperty.getInstance();
        while (it.hasNext()) {
            PropertiedObject.Property nextProperty = it.next();
            if (nextProperty.getLabel().endsWith("Password")) continue;
            SB.append("\r\n");
            SB.append(nextProperty.getName());
            SB.append(" :\t");
            SB.append(instance.getPropertyValue(nextProperty));
        }
        return SB.toString();
    }

    private String getTerminalConfigurations() {
        StringBuilder SB = new StringBuilder("\r\n\r\nTerminal Properties\r\n----------------");
        List<Terminal> terminals = Terminal.getAllTerminals();
        for (Terminal terminal : terminals) {
            SB.append("\r\n\r\nTerminal ");
            SB.append(terminal.getLabel());
            for (PropertiedObject.Property nextProperty : Terminal.Properties) {
                SB.append("\r\n");
                SB.append(nextProperty.getName());
                SB.append(" :\t");
                Object value = terminal.getPropertyValue(nextProperty);
                if (value instanceof List) {
                    this.stringifyList(SB, (List)value);
                    continue;
                }
                this.stringify(SB, value);
            }
        }
        return SB.toString();
    }

    private String getVersionHistoryInfo() {
        List<SystemVersionHistory> history = this.getVersionHistory();
        StringBuilder builder = new StringBuilder("\r\n\r\nVersion History\r\n----------------");
        int maxIndex = history.size() > 5 ? 5 : history.size();
        for (SystemVersionHistory version : history.subList(0, maxIndex)) {
            builder.append("\r\n");
            builder.append(version.toString());
        }
        return builder.toString();
    }

    private void stringify(StringBuilder SB, Object value) {
        Method labelMethod;
        if (value instanceof PersistentObject && (labelMethod = this.getLabelMethod(value)) != null) {
            try {
                SB.append(String.valueOf(labelMethod.invoke(value, new Object[0])));
                return;
            }
            catch (Exception ex) {
                OrderMateLog.LOG.error("Error invoking labelMethod on object:" + value.getClass(), (Throwable)ex);
            }
        }
        SB.append(String.valueOf(value));
    }

    private void stringifyList(StringBuilder SB, List toStringify) {
        if (toStringify.isEmpty()) {
            return;
        }
        Method labelMethod = this.getLabelMethod(toStringify.get(0));
        if (labelMethod != null) {
            Iterator it = toStringify.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                String label = null;
                try {
                    label = String.valueOf(labelMethod.invoke(next, new Object[0]));
                }
                catch (Exception ex) {
                    OrderMateLog.LOG.error("Method access invalid:" + labelMethod.getName() + " for " + next.getClass(), (Throwable)ex);
                    label = String.valueOf(next);
                }
                SB.append(label);
                if (!it.hasNext()) continue;
                SB.append(", ");
            }
        } else {
            Iterator it = toStringify.iterator();
            while (it.hasNext()) {
                Object next = it.next();
                SB.append(String.valueOf(next));
                if (!it.hasNext()) continue;
                SB.append(", ");
            }
        }
    }

    private Method getLabelMethod(Object value) {
        if (value == null) {
            return null;
        }
        Class<?> clazz = value.getClass();
        Method labelMethod = null;
        try {
            labelMethod = clazz.getMethod("getLabel", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            try {
                labelMethod = clazz.getMethod("getName", new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                labelMethod = null;
            }
        }
        return labelMethod;
    }
}

