/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.util.DateTimeUtils;
import java.util.LinkedList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.AbstractEventLog;
import ordermate.database.misc.AsynchronousEventLogWriter;
import ordermate.database.misc.SystemVersionHistory;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.license.PersistentLicense;
import ordermate.database.users.User;

public class ServermateEventLog
extends AbstractEventLog {
    private static final List allEvents = new LinkedList();
    private static final String LICENSE_CHANGED = "License Change";
    private static final String AUTO_MENU_IMPORT = "Auto menu import";
    private static final String VERSION_UPDATE = "System Version Update";
    private static final String DATABASE_OPTIMISE = "Database Optimise";
    private static ServermateEventLog instance = new ServermateEventLog();

    private ServermateEventLog() {
        super(new AsynchronousEventLogWriter(), "Servermate");
        TerminalEventLog.initInstance(this.getWriter());
        allEvents.add(LICENSE_CHANGED);
        allEvents.add(AUTO_MENU_IMPORT);
        allEvents.add(VERSION_UPDATE);
        allEvents.add(DATABASE_OPTIMISE);
    }

    public static ServermateEventLog getInst() {
        return instance;
    }

    @Override
    public List<String> getAllEvents() {
        return allEvents;
    }

    public void logLicenseChange(EventContext context, PersistentLicense oldLicense, PersistentLicense newLicense) {
        this.logActivity(context, LICENSE_CHANGED, "Software license changed from : " + oldLicense.toString() + " to: " + newLicense);
    }

    public void logAutoMenuImport(EventContext context, String file, String failure) {
        if (failure == null) {
            this.logActivity(context, AUTO_MENU_IMPORT, "Imported file " + file + " succesfully");
        } else {
            this.logActivity(context, AUTO_MENU_IMPORT, "Failed to import file " + file + "; " + failure);
        }
    }

    public void logSystemVersionUpdate(SystemVersionHistory newVersionHistory) {
        StringBuilder builder = new StringBuilder();
        builder.append("New system version ").append(newVersionHistory.getVersionString()).append(" first used on ").append(DateTimeUtils.getMediumDateFormat().format(newVersionHistory.getFirstUsed()));
        this.logActivity(User.getSystemAdministrator(), VERSION_UPDATE, builder.toString());
    }

    public static void logDatabaseOptimise(User user, Terminal terminal) {
        ServermateEventLog.getInst().logActivity(new EventContext(terminal, user), DATABASE_OPTIMISE, "Optimising database.");
    }
}

