/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.util.Price;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.EventContext;
import ordermate.database.config.Quantity;
import ordermate.database.inventory.InventoryItemUnit;
import ordermate.database.inventory.InventoryOption;
import ordermate.database.misc.AbstractEventLog;
import ordermate.database.misc.AsynchronousEventLogWriter;
import ordermate.database.misc.ObjectChange;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.stock.StockArea;
import ordermate.database.stock.StockInvoice;
import ordermate.database.stock.StockInvoiceEntry;
import ordermate.database.stock.StockItem;
import ordermate.database.stock.StockSupplier;
import ordermate.database.stock.StockTake;
import ordermate.database.stock.StockTakeEntry;
import ordermate.database.stock.usage.StockAdjustment;
import ordermate.database.stock.usage.StockTransfer;
import ordermate.database.stock.usage.StockWastage;
import ordermate.database.users.User;

public final class StockControlEventLog
extends AbstractEventLog {
    private static final List<String> allEvents = new ArrayList<String>();
    public static final String STOCK_LOGIN = "Stock Login";
    public static final String STOCK_FAILED_LOGIN = "Failed Stock Login";
    public static final String STOCK_LOGOUT = "Stock Logout";
    public static final String STOCK_CREATE_ADJUSTMENT = "Create Stock Adjustment";
    public static final String STOCK_CREATE_INVOICE = "Create Stock Invoice";
    public static final String STOCK_CREATE_INVOICE_ENTRY = "Create Stock Invoice Entry";
    public static final String STOCK_CREATE_AREA = "Create Stock Area";
    public static final String STOCK_CREATE_ITEM = "Create Stock Item";
    public static final String STOCK_CREATE_STOCKTAKE = "Create Stocktake";
    public static final String STOCK_CREATE_SUPPLIER = "Create Stock Supplier";
    public static final String STOCK_CREATE_TRANSFER = "Create Stock Transfer";
    public static final String STOCK_CREATE_WASTAGE = "Create Stock Wastage";
    public static final String STOCK_ADD_ITEM_INGREDIENT = "Add Item Ingredient";
    public static final String STOCK_ADD_OPTION_INGREDIENT = "Add Option Ingredient";
    public static final String STOCK_COUNT_CHANGED = "Stock Count Changed";
    public static final String STOCK_DELETE_ADJUSTMENT = "Delete Stock Adjustment";
    public static final String STOCK_DELETE_INVOICE = "Delete Stock Invoice";
    public static final String STOCK_DELETE_INVOICE_ENTRY = "Delete Stock Invoice Entry";
    public static final String STOCK_DELETE_AREA = "Delete Stock Area";
    public static final String STOCK_DELETE_ITEM = "Delete Stock Item";
    public static final String STOCK_DELETE_STOCKTAKE = "Delete Stocktake";
    public static final String STOCK_DELETE_SUPPLIER = "Delete Stock Supplier";
    public static final String STOCK_DELETE_TRANSFER = "Delete Stock Transfer";
    public static final String STOCK_DELETE_WASTAGE = "Delete Stock Wastage";
    public static final String STOCK_REMOVE_ITEM_INGREDIENT = "Remove Item Ingredient";
    public static final String STOCK_REMOVE_OPTION_INGREDIENT = "Remove Option Ingredient";
    public static final String STOCK_EDIT_ADJUSTMENT = "Edit Stock Adjustment";
    public static final String STOCK_EDIT_INVOICE = "Edit Stock Invoice";
    public static final String STOCK_EDIT_INVOICE_ENTRY = "Edit Stock Invoice Entry";
    public static final String STOCK_EDIT_ITEM = "Edit Stock Item";
    public static final String STOCK_EDIT_TRANSFER = "Edit Stock Transfer";
    public static final String STOCK_EDIT_WASTAGE = "Edit Stock Wastage";
    public static final String STOCK_SET_ITEM_MANUAL_COST = "Set Manual Cost";
    public static final String STOCK_EDIT_ITEM_INGREDIENT = "Edit Item Ingredient";
    public static final String STOCK_EDIT_OPTION_INGREDIENT = "Edit Option Ingredient";
    public static final String STOCK_EXPORT_INVOICES = "Export Invoices";
    public static final String STOCK_SAVEUPDATE_STOCKTAKE = "Save & Update Stocktake";
    public static final String STOCK_ITEM_PRICECHANGE = "Change StockItem Average Cost";
    public static final String STOCK_TAKE_ENTRY_UPDATED = "Stock Take Entry Updated";
    public static final String STOCK_TAKE_UPDATED = "Stock Take Updated";
    public static final String STOCK_REPLACED = "Stock Item Replaced";
    private static StockControlEventLog instance;

    private StockControlEventLog() {
        super(new AsynchronousEventLogWriter(), "Stock Control Events");
        if (TerminalEventLog.getInst() != null) {
            TerminalEventLog.initInstance(this.getWriter());
        }
        allEvents.add(STOCK_LOGIN);
        allEvents.add(STOCK_FAILED_LOGIN);
        allEvents.add(STOCK_LOGOUT);
        allEvents.add(STOCK_CREATE_ADJUSTMENT);
        allEvents.add(STOCK_CREATE_INVOICE);
        allEvents.add(STOCK_CREATE_INVOICE_ENTRY);
        allEvents.add(STOCK_CREATE_AREA);
        allEvents.add(STOCK_CREATE_ITEM);
        allEvents.add(STOCK_CREATE_STOCKTAKE);
        allEvents.add(STOCK_CREATE_SUPPLIER);
        allEvents.add(STOCK_CREATE_TRANSFER);
        allEvents.add(STOCK_CREATE_WASTAGE);
        allEvents.add(STOCK_ADD_ITEM_INGREDIENT);
        allEvents.add(STOCK_ADD_OPTION_INGREDIENT);
        allEvents.add(STOCK_DELETE_ADJUSTMENT);
        allEvents.add(STOCK_DELETE_INVOICE);
        allEvents.add(STOCK_DELETE_INVOICE_ENTRY);
        allEvents.add(STOCK_DELETE_AREA);
        allEvents.add(STOCK_DELETE_ITEM);
        allEvents.add(STOCK_DELETE_STOCKTAKE);
        allEvents.add(STOCK_DELETE_SUPPLIER);
        allEvents.add(STOCK_DELETE_TRANSFER);
        allEvents.add(STOCK_DELETE_WASTAGE);
        allEvents.add(STOCK_REMOVE_ITEM_INGREDIENT);
        allEvents.add(STOCK_REMOVE_OPTION_INGREDIENT);
        allEvents.add(STOCK_COUNT_CHANGED);
        allEvents.add(STOCK_EDIT_ADJUSTMENT);
        allEvents.add(STOCK_EDIT_INVOICE);
        allEvents.add(STOCK_EDIT_INVOICE_ENTRY);
        allEvents.add(STOCK_EDIT_ITEM);
        allEvents.add(STOCK_EDIT_TRANSFER);
        allEvents.add(STOCK_EDIT_WASTAGE);
        allEvents.add(STOCK_SET_ITEM_MANUAL_COST);
        allEvents.add(STOCK_EDIT_ITEM_INGREDIENT);
        allEvents.add(STOCK_EDIT_OPTION_INGREDIENT);
        allEvents.add(STOCK_EXPORT_INVOICES);
        allEvents.add(STOCK_SAVEUPDATE_STOCKTAKE);
        allEvents.add(STOCK_ITEM_PRICECHANGE);
        allEvents.add(STOCK_TAKE_ENTRY_UPDATED);
        allEvents.add(STOCK_TAKE_UPDATED);
        allEvents.add(STOCK_REPLACED);
    }

    public static AbstractEventLog getInst() {
        if (instance == null) {
            instance = new StockControlEventLog();
        }
        return instance;
    }

    private static String getEditChangeString(List<ObjectChange> objectChanges) {
        if (!objectChanges.isEmpty()) {
            StringBuffer buffer = new StringBuffer("\n");
            for (int i = 0; i < objectChanges.size(); ++i) {
                ObjectChange change = objectChanges.get(i);
                buffer.append(change.toString() + "\n");
            }
            return buffer.toString();
        }
        return " No change.";
    }

    public static void logLogin(User user, String appName) {
        String localAddress = null;
        try {
            InetAddress address = InetAddress.getLocalHost();
            localAddress = address.getHostAddress();
        }
        catch (UnknownHostException ex) {
            OrderMateLog.LOG.info("Couldn't get local host", (Throwable)ex);
        }
        StockControlEventLog.getInst().logActivity(user, STOCK_LOGIN, "User " + (user != null ? user.getName() : "none") + " logged in to " + appName + " IP:" + localAddress);
    }

    public static void logStockAdminFailedLogin(User user) {
        StockControlEventLog.getInst().logActivity(user, STOCK_FAILED_LOGIN, "User " + (user != null ? user.getName() : "none") + " failed to log in to Stock Control.");
    }

    public static void logStockAdminLogout(User user) {
        if (user != null) {
            StockControlEventLog.getInst().logActivity(user, STOCK_LOGOUT, "User " + user.getName() + " logged out from Stock Control.");
        } else {
            StockControlEventLog.getInst().logActivity(user, STOCK_LOGOUT, "Unknown user logged out from Stock Control.");
        }
    }

    public static void logCreateStockAdjustment(User user, StockAdjustment adj) {
        StockItem item = adj.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_ADJUSTMENT, "User " + user.getName() + " created a stock adjustment (#" + adj.getID() + ") for " + adj.getAdjustQty() + " of " + item + " in " + adj.getStockArea());
    }

    public static void logCreateStockInvoice(User user, StockInvoice inv) {
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_INVOICE, "User " + user.getName() + " created Invoice #" + inv.getID() + " (Invoice Number \"" + inv.getInvoiceNumber() + "\"), value (inc Tax) " + inv.getTotalCost());
    }

    public static void logCreateStockInvoiceEntry(User user, StockInvoiceEntry entry) {
        StockInvoice invoice = entry.getInvoice();
        StockItem item = entry.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_INVOICE_ENTRY, "User " + user.getName() + " added " + entry.getNumReceived() + " x " + item.getPurchaseQty() + " of " + item.getLabel() + " to invoice #" + invoice.getID() + " (Invoice Number \"" + invoice.getInvoiceNumber() + "\", value (inc Tax) " + entry.getPricePaid());
    }

    public static void logCancelChangesToStockInvoiceEntry(User user, StockInvoiceEntry entry) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_INVOICE_ENTRY, "User " + user.getName() + " cancelled changes to invoice entry #" + entry.getID());
    }

    public static void logRestoreStockInvoiceEntry(User user, StockInvoiceEntry entry) {
        StockInvoice invoice = entry.getInvoice();
        StockItem item = entry.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_INVOICE_ENTRY, "User " + user.getName() + " cancelled the deletion of " + entry.getNumReceived() + " x " + item.getPurchaseQty() + " of " + item.getLabel() + " to invoice #" + invoice.getID() + " (Invoice Number \"" + invoice.getInvoiceNumber() + "\", value (inc Tax) " + entry.getPricePaid());
    }

    public static void logCreateStockArea(User user, StockArea area) {
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_AREA, "User " + user.getName() + " created stock area \"" + area.getLabel() + "\"");
    }

    public static void logCreateStockItem(User user, StockItem item, boolean auto) {
        String createdString = auto ? " auto-created" : " created";
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_ITEM, "User " + user.getName() + createdString + " stock item \"" + item.getLabel() + "\" (" + item.getCurrentReplacementCost() + " for " + item.getPurchaseQty() + ")");
    }

    public static void logCreateStockTake(User user, StockTake stockTake) {
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_STOCKTAKE, "User " + user.getName() + " created a new stocktake " + stockTake + ".");
    }

    public static void logCreateStockSupplier(User user, StockSupplier supplier) {
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_SUPPLIER, "User " + user.getName() + " created supplier \"" + supplier.getLabel() + "\"");
    }

    public static void logCreateStockTransfer(User user, StockTransfer trans) {
        StockItem item = trans.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_TRANSFER, "User " + user.getName() + " created a stock transfer (#" + trans.getID() + ") for " + trans.getQuantityUsed() + " of " + item + " from " + trans.getStockArea() + " to " + trans.getStockAreaTransferTo());
    }

    public static void logCreateStockWastage(User user, StockWastage wastage) {
        StockItem item = wastage.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_CREATE_WASTAGE, "User " + user.getName() + " created a stock wastage (#" + wastage.getID() + ") for " + wastage.getQuantityUsed() + " of " + item + " in " + wastage.getStockArea());
    }

    public static void logAddMenuItemIngredient(User user, InventoryItemUnit itemUnit, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_ADD_ITEM_INGREDIENT, "User " + user.getName() + " linked an ingredient to " + itemUnit.getLabel() + ": " + qty + " of " + ingred);
    }

    public static void logEditMenuItemIngredient(User user, InventoryItemUnit itemUnit, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_ITEM_INGREDIENT, "User " + user.getName() + " changed an ingredient for " + itemUnit.getLabel() + " to " + qty + " of " + ingred);
    }

    public static void logRemoveMenuItemIngredient(User user, InventoryItemUnit itemUnit, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_REMOVE_ITEM_INGREDIENT, "User " + user.getName() + " removed an ingredient linked to " + itemUnit.getLabel() + ": " + qty + " of " + ingred);
    }

    public static void logRemoveAllMenuItemIngredients(User user, InventoryItemUnit itemUnit) {
        StockControlEventLog.getInst().logActivity(user, STOCK_REMOVE_ITEM_INGREDIENT, "User " + user.getName() + " removed all ingredients linked to " + itemUnit.getLabel());
    }

    public static void logAddMenuOptionIngredient(User user, InventoryOption option, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_ADD_OPTION_INGREDIENT, "User " + user.getName() + " linked an ingredient to " + option.getLabel() + ": " + qty + " of " + ingred);
    }

    public static void logEditMenuOptionIngredient(User user, InventoryOption option, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_OPTION_INGREDIENT, "User " + user.getName() + " changed an ingredient for " + option.getLabel() + " to " + qty + " of " + ingred);
    }

    public static void logRemoveMenuOptionIngredient(User user, InventoryOption option, StockItem ingred, Quantity qty) {
        StockControlEventLog.getInst().logActivity(user, STOCK_REMOVE_OPTION_INGREDIENT, "User " + user.getName() + " removed an ingredient linked to " + option.getLabel() + ": " + qty + " of " + ingred);
    }

    public static void logRemoveAllMenuOptionIngredients(User user, InventoryOption option) {
        StockControlEventLog.getInst().logActivity(user, STOCK_REMOVE_OPTION_INGREDIENT, "User " + user.getName() + " removed all ingredients linked to " + option.getLabel());
    }

    public static void logSetMenuItemCustomCost(User user, InventoryItemUnit itemUnit, Price customCost) {
        String itemName;
        String userName = user == null ? "unknow user" : user.getName();
        String string = itemName = itemUnit == null ? "unknow menu item" : itemUnit.toString();
        if (customCost != null) {
            StockControlEventLog.getInst().logActivity(user, STOCK_SET_ITEM_MANUAL_COST, "User " + userName + " set the custom cost of " + itemName + " to " + customCost);
        } else {
            StockControlEventLog.getInst().logActivity(user, STOCK_SET_ITEM_MANUAL_COST, "User " + userName + " removed the custom cost of " + itemName);
        }
    }

    public static void logStocktakeSaveUpdate(User user, StockTake stocktake) {
        StockControlEventLog.getInst().logActivity(user, STOCK_SAVEUPDATE_STOCKTAKE, "User " + user.getName() + " saved the live stocktake created on " + stocktake.getDate());
    }

    public static void logDeleteStockAdjustment(User user, StockAdjustment adj) {
        StockItem item = adj.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_ADJUSTMENT, "User " + user.getName() + " deleted a stock adjustment (#" + adj.getID() + ") for " + adj.getAdjustQty() + " of " + item + " in " + adj.getStockArea());
    }

    public static void logDeleteStockInvoice(User user, StockInvoice inv) {
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_INVOICE, "User " + user.getName() + " deleted Invoice #" + inv.getID() + " (Invoice Number \"" + inv.getInvoiceNumber() + "\"), value (inc Tax) " + inv.getTotalCost());
    }

    public static void logDeleteStockInvoiceEntry(User user, StockInvoiceEntry entry) {
        StockInvoice invoice = entry.getInvoice();
        StockItem item = entry.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_INVOICE_ENTRY, "User " + user.getName() + " removed " + entry.getNumReceived() + " x " + item.getPurchaseQty() + " of " + item.getLabel() + " from invoice #" + invoice.getID() + " (Invoice Number \"" + invoice.getInvoiceNumber() + "\", value (inc Tax) " + entry.getPricePaid());
    }

    public static void logCancelStockInvoiceEntry(User user, StockInvoiceEntry entry) {
        StockInvoice invoice = entry.getInvoice();
        StockItem item = entry.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_INVOICE_ENTRY, "User " + user.getName() + " cancelled the addition of " + entry.getNumReceived() + " x " + item.getPurchaseQty() + " of " + item.getLabel() + " from invoice #" + invoice.getID() + " (Invoice Number \"" + invoice.getInvoiceNumber() + "\", value (inc Tax) " + entry.getPricePaid());
    }

    public static void logDeleteStockArea(User user, StockArea area) {
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_AREA, "User " + user.getName() + " deleted stock area \"" + area.getLabel() + "\"");
    }

    public static void logDeleteStockItem(User user, StockItem item) {
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_ITEM, "User " + user.getName() + " deleted stock item \"" + item.getLabel() + "\" ");
    }

    public static void logDeleteStockTake(User user, StockTake stockTake) {
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_STOCKTAKE, "User " + user.getName() + " deleted the live stocktake " + stockTake + ".");
    }

    public static void logDeleteStockSupplier(User user, StockSupplier supplier) {
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_SUPPLIER, "User " + user.getName() + " deleted supplier \"" + supplier.getLabel() + "\"");
    }

    public static void logDeleteStockTransfer(User user, StockTransfer trans) {
        StockItem item = trans.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_TRANSFER, "User " + user.getName() + " deleted a stock transfer (#" + trans.getID() + ") for " + trans.getQuantityUsed() + " of " + item + " from " + trans.getStockArea() + " to " + trans.getStockAreaTransferTo());
    }

    public static void logDeleteStockWastage(User user, StockWastage wastage) {
        StockItem item = wastage.getStockItem();
        StockControlEventLog.getInst().logActivity(user, STOCK_DELETE_WASTAGE, "User " + user.getName() + " deleted a stock wastage (#" + wastage.getID() + ") for " + wastage.getQuantityUsed() + " of " + item + " in " + wastage.getStockArea());
    }

    public static void logEditStockAdjustment(User user, StockAdjustment adj, List<ObjectChange> changes) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_ADJUSTMENT, "User " + user.getName() + " edited stock adjustment #" + adj.getID() + ": " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logEditStockInvoice(User user, StockInvoice inv, List<ObjectChange> changes) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_INVOICE, "User " + user.getName() + " edited Invoice #" + inv.getID() + " (Invoice Number \"" + inv.getInvoiceNumber() + "\"): " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logEditStockInvoiceEntry(User user, StockInvoiceEntry entry, List<ObjectChange> changes) {
        StockInvoice invoice = entry.getInvoice();
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_INVOICE_ENTRY, "User " + user.getName() + " edited an invoice entry from invoice #" + invoice.getID() + " (Invoice Number \"" + invoice.getInvoiceNumber() + "\": " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logEditStockItem(User user, StockItem item, List<ObjectChange> changes) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_ITEM, "User " + user.getName() + " edited stock item \"" + item.getLabel() + "\": " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logEditStockTransfer(User user, StockTransfer trans, List<ObjectChange> changes) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_TRANSFER, "User " + user.getName() + " edit stock transfer #" + trans.getID() + ": " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logEditStockWastage(User user, StockWastage wastage, List<ObjectChange> changes) {
        StockControlEventLog.getInst().logActivity(user, STOCK_EDIT_WASTAGE, "User " + user.getName() + " edited stock wastage #" + wastage.getID() + ": " + StockControlEventLog.getEditChangeString(changes));
    }

    public static void logSetStockItemAveragePrice(User user, StockItem item, Price newPrice) {
        StockControlEventLog.getInst().logActivity(user, STOCK_ITEM_PRICECHANGE, "User " + user.getName() + " set the average price of " + item + " to " + newPrice + ".");
    }

    public static void logStockTakeEntryUpdated(EventContext context, StockTakeEntry entry) {
        StringBuilder SB = new StringBuilder("StockTake Entry value modified - ");
        SB.append("Area:").append(entry.getStockArea().getLabel()).append(" Item:").append(entry.getStockItem().getLabel()).append(", Outer:").append(entry.getOuterQty() == null ? " - " : entry.getOuterQtyAsQty()).append(", Unit:").append(entry.getUnitQty() == null ? " - " : entry.getUnitQtyAsQty()).append(", Total:").append(entry.getActualQuantity());
        StockControlEventLog.getInst().logActivity(context, STOCK_TAKE_ENTRY_UPDATED, SB.toString());
    }

    public static void logStockTakeModification(EventContext context, String mod) {
        StringBuilder SB = new StringBuilder("StockTake modified : ");
        SB.append(mod);
        StockControlEventLog.getInst().logActivity(context, STOCK_TAKE_UPDATED, SB.toString());
    }

    public static void logStockItemReplaced(EventContext context, String description, StockItem existingItem, StockItem replacementItem) {
        StringBuilder SB = new StringBuilder("Stock Item was replaced - ");
        SB.append("Item: ").append(description).append(", Existing: ").append(existingItem).append(", Replacement").append(replacementItem);
        StockControlEventLog.getInst().logActivity(context, STOCK_REPLACED, SB.toString());
    }

    @Override
    public List<String> getAllEvents() {
        return allEvents;
    }
}

