/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.persistence.DBMapping;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.reference.SingletonReference;
import java.io.File;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="config_storegroup_property")
@AccessType(value="property")
@DBMapping(value=DBMapping.Mapping.Row)
public class StoreGroup
extends PersistentObject
implements Saveable {
    public static final Long HO_STARTING_ID = (long)Math.pow(10.0, 15.0) * 2L;
    public static final Props Properties = new Props();
    private static Reference<StoreGroup> instance = new SingletonReference<StoreGroup>(StoreGroup.class);
    private String appServer;
    private String storeNumber;
    private String storeName;
    private String emailAddress;
    private String outputDir;
    private String monthToTransmit;
    private String monthLastExport;
    private String monthReportStatus;
    private int syncCounter;

    @Column(name="app_server")
    public String getAppServer() {
        return this.appServer;
    }

    public void setAppServer(String appSrv) {
        this.appServer = appSrv;
    }

    @Column(name="email_address")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String email) {
        this.emailAddress = email;
    }

    @Column(name="output_dir")
    public String getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(String outDir) {
        this.outputDir = outDir;
    }

    @Column(name="store_name")
    public String getStoreName() {
        return this.storeName;
    }

    public void setStoreName(String name) {
        this.storeName = name;
    }

    @Column(name="store_number")
    public String getStoreNumber() {
        return this.storeNumber;
    }

    public void setStoreNumber(String number) {
        this.storeNumber = number;
    }

    public void setMonthToTransmit(Date month) {
        if (month == null) {
            this.monthToTransmit = null;
        } else {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            this.monthToTransmit = df.format(month);
        }
    }

    @Column(name="month_to_transmit")
    @Temporal(value=TemporalType.DATE)
    public Date getMonthToTransmit() {
        if (this.monthToTransmit == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return df.parse(this.monthToTransmit);
        }
        catch (ParseException ex) {
            OrderMate.LOG.warn((Object)ex);
            return null;
        }
    }

    public void setMonthLastExport(Date month) {
        if (month == null) {
            this.monthLastExport = null;
        } else {
            SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
            this.monthLastExport = df.format(month);
        }
    }

    @Column(name="month_last_export")
    @Temporal(value=TemporalType.DATE)
    public Date getMonthLastExport() {
        if (this.monthLastExport == null) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        try {
            return df.parse(this.monthLastExport);
        }
        catch (ParseException ex) {
            OrderMate.LOG.warn((Object)ex);
            return null;
        }
    }

    @Column(name="month_report_status")
    public String getMonthReportStatus() {
        return this.monthReportStatus;
    }

    public void setMonthReportStatus(String reportStatus) {
        this.monthReportStatus = reportStatus;
    }

    @Column(name="sync_counter")
    public int getSyncCounter() {
        return this.syncCounter;
    }

    public void setSyncCounter(int counter) {
        this.syncCounter = counter;
    }

    @Transient
    public boolean isSet() {
        return this.appServer != null && !this.appServer.trim().isEmpty() && this.storeNumber != null && !this.storeNumber.trim().isEmpty() && (Config.isDebuging() || !this.isTestingData());
    }

    @Transient
    private boolean isTestingData() {
        return this.storeNumber != null && this.storeNumber.equals("200207") && this.storeName != null && this.storeName.equals("Bunnings Box Hill");
    }

    public static StoreGroup getInstance() {
        return instance.get();
    }

    @Override
    public void save() {
        if (!this.isPersistent()) {
            throw new IllegalStateException("StoreGroup is a Singleton so a new instance must not be created.");
        }
        PersistenceManager.save(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Not supported for a singleton.");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static String getExistingOutputDir() {
        File dir;
        String outputDir = StoreGroup.getInstance().getOutputDir();
        if (outputDir == null || outputDir.trim().isEmpty()) {
            outputDir = "Out";
        }
        if (outputDir.endsWith("\\") || outputDir.endsWith("/")) {
            outputDir = outputDir.substring(0, outputDir.length() - 1);
        }
        if (!(dir = new File(outputDir)).exists() && !dir.mkdirs()) {
            OrderMate.LOG.info("Cannot create the directory " + outputDir + ".");
            outputDir = "Out";
            dir = new File(outputDir);
            if (!dir.exists() && !dir.mkdirs()) {
                OrderMate.LOG.warn("Unable to create the directory " + outputDir + ".");
                outputDir = "";
            }
        }
        return outputDir;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property APP_SERVER;
        public PropertiedObject.Property STORE_NUMBER;
        public PropertiedObject.Property STORE_NAME;
        public PropertiedObject.Property EMAIL_ADDRESS;
        public PropertiedObject.Property OUTPUT_DIR;
        public PropertiedObject.Property MONTH_TO_TRANSMIT;
        public PropertiedObject.Property MONTH_LAST_EXPORT;
        public PropertiedObject.Property MONTH_REPORT_STATUS;
        public PropertiedObject.Property SYNC_COUNTER;
    }
}

