/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="system_synchronisation_status")
@AccessType(value="property")
public class SynchronisationStatus
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String softwareVersion;
    private int syncQueueLength;
    private Date messageTime;
    private String lastMenuImportFileName;
    private Date lastMenuImportDateTime;
    private Date timeReceived;

    @Column(name="software_version")
    public String getSoftwareVersion() {
        return this.softwareVersion;
    }

    public void setSoftwareVersion(String version) {
        this.softwareVersion = version;
    }

    @Column(name="sync_queue_length")
    public int getSyncQueueLength() {
        return this.syncQueueLength;
    }

    public void setSyncQueueLength(int length) {
        this.syncQueueLength = length;
    }

    @Column(name="message_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getMessageTime() {
        return this.messageTime;
    }

    public void setMessageTime(Date time) {
        this.messageTime = time;
    }

    @Column(name="last_menu_import_file_name")
    public String getLastMenuImportFileName() {
        return this.lastMenuImportFileName;
    }

    public void setLastMenuImportFileName(String lastMenuImportFileName) {
        this.lastMenuImportFileName = lastMenuImportFileName;
    }

    @Column(name="last_menu_import_date_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getLastMenuImportDateTime() {
        return this.lastMenuImportDateTime;
    }

    public void setLastMenuImportDateTime(Date lastMenuImportDateTime) {
        this.lastMenuImportDateTime = lastMenuImportDateTime;
    }

    protected void setTimeReceived(Date timeReceived) {
        this.timeReceived = timeReceived;
    }

    @Column(name="timeReceived")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getTimeReceived() {
        return this.timeReceived;
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot delete sync status, is a singleton");
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void save() {
        if (!this.isPersistent() && SynchronisationStatus.getSynchronisationStatus() != null) {
            throw new IllegalStateException("Cannot save new synchronisation status object, should be singleton");
        }
        PersistenceManager.save(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Transient
    public Status getStatus() {
        int GOOD_TIME_THRESHOLD = 3600000;
        int OK_TIME_THRESHOLD = 86400000;
        int GOOD_LENGTH_THRESHOLD = 5000;
        long timeDiff = Math.abs(new Date().getTime() - this.getMessageTime().getTime());
        if (timeDiff < 3600000L && this.getSyncQueueLength() < 5000) {
            return Status.GOOD;
        }
        if (timeDiff < 86400000L) {
            return Status.OK;
        }
        return Status.BAD;
    }

    @Transient
    public static SynchronisationStatus getSynchronisationStatus() {
        return PersistenceManager.getObject(SynchronisationStatus.class, Query.select(SynchronisationStatus.class).limit(1).toString(), null);
    }

    public static enum Status {
        GOOD,
        OK,
        BAD;

    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property SOFTWARE_VERSION;
        public PropertiedObject.Property SYNC_QUEUE_LENGTH;
        public PropertiedObject.Property MESSAGE_TIME;
        public PropertiedObject.Property LAST_MENU_IMPORT_FILENAME;
        public PropertiedObject.Property LAST_MENU_IMPORT_DATE_TIME;
        public PersistentObject.DerivedProperty STATUS = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SynchronisationStatus.class), "status");
    }
}

