/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.OrderMateLog;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import ordermate.database.misc.TradingDay;
import ordermate.database.queries.misc.SystemCurrentInfoQueries;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="system_current_info")
@AccessType(value="property")
@SqlResultSetMappings(value={@SqlResultSetMapping(name="RowResult", columns={@ColumnResult(name="name"), @ColumnResult(name="value")})})
public class SystemCurrentInfo
extends PersistentObject
implements Saveable {
    private static final int REVISION_WRAP_LIMIT = 1000000;
    public static final Props Properties = new Props();
    private static Reference<SystemCurrentInfo> instance = new LocalCachedReference<SystemCurrentInfo>(new QueryReference<SystemCurrentInfo>(SystemCurrentInfo.class, Query.select(SystemCurrentInfo.class)));
    private int databaseRevision;
    private int modificationCount;
    private Reference<TradingDay> currentTradingDay;
    private String currentVersion;
    private Date updated;
    private int menuRevision;
    private int tablesRevision;
    private long updatemateId;
    private long redbackId;
    private boolean nagForEmail;

    public SystemCurrentInfo() {
        this.currentTradingDay = this.createReference(SystemCurrentInfo.Properties.CURRENT_TRADING_DAY);
    }

    public static SystemCurrentInfo getInstance() {
        return instance.get();
    }

    public static void refreshReference() {
        instance.set((SystemCurrentInfo)PersistenceManager.reacquire(instance.get()));
    }

    @Column(name="Database_Revision")
    public int getDatabaseRevision() {
        return this.databaseRevision;
    }

    @ManyToOne
    @JoinColumn(name="FK_finance_trading_day")
    public TradingDay getCurrentTradingDay() {
        return this.currentTradingDay.get();
    }

    @Column(name="current_version")
    public String getCurrentVersion() {
        return this.currentVersion;
    }

    public void setCurrentVersion(String currentVersion) {
        this.currentVersion = currentVersion;
    }

    @Column(name="updated")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public boolean needsUpdate() {
        return this.modificationCount != SystemCurrentInfo.getDatabaseModCount();
    }

    public static int getDatabaseModCount() {
        return SystemCurrentInfo.getIntProperty(SystemCurrentInfo.Properties.MODIFICATION_COUNT);
    }

    public static int getMenuRevisionCount() {
        return SystemCurrentInfo.getIntProperty(SystemCurrentInfo.Properties.MENU_REVISION);
    }

    public static int getTablesRevisionCount() {
        return SystemCurrentInfo.getIntProperty(SystemCurrentInfo.Properties.TABLES_REVISION);
    }

    private static int getIntProperty(PropertiedObject.Property property) {
        String sql = Query.select(property).toString();
        Object[][] rs = PersistenceManager.getPersistenceDelegate().executeQuery(sql, null);
        Integer count = (Integer)rs[0][0];
        return count;
    }

    public static void setUpdate(String reason) {
        SystemCurrentInfo.updateRevisionProperty(SystemCurrentInfo.Properties.MODIFICATION_COUNT);
        OrderMateLog.LOG.info("Caching update was caused by " + reason);
    }

    public static void setMenuUpdate(String reason) {
        SystemCurrentInfo.updateRevisionProperty(SystemCurrentInfo.Properties.MENU_REVISION);
        OrderMateLog.LOG.info("Menu update was caused by " + reason);
        SystemCurrentInfo.setUpdate("Menu Update");
    }

    public static void setTablesUpdate(String reason) {
        SystemCurrentInfo.updateRevisionProperty(SystemCurrentInfo.Properties.TABLES_REVISION);
        OrderMateLog.LOG.info("Tables update was caused by " + reason);
        SystemCurrentInfo.setUpdate("Menu Update");
    }

    private static void updateRevisionProperty(PropertiedObject.Property property) {
        String columnName = PersistenceManager.getPersistenceMetaData().getPropertyColumn(property);
        String sql = SystemCurrentInfo.getIntProperty(property) >= 1000000 ? SystemCurrentInfoQueries.getResetModCount(columnName) : SystemCurrentInfoQueries.getIncrementModCount(columnName);
        PersistenceManager.getPersistenceDelegate().executeUpdate(sql, new Object[0]);
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    protected void setDatabaseRevision(int revisionNum) {
        this.databaseRevision = revisionNum;
    }

    protected void setCurrentTradingDay(TradingDay tradingDay) {
        this.currentTradingDay.set(tradingDay);
    }

    @Column(name="last_modification")
    protected int getModificationCount() {
        return this.modificationCount;
    }

    protected void setModificationCount(int modCount) {
        this.modificationCount = modCount;
    }

    @Column(name="menu_revision")
    protected int getMenuRevision() {
        return this.menuRevision;
    }

    protected void setMenuRevision(int menuRevision) {
        this.menuRevision = menuRevision;
    }

    @Column(name="tables_revision")
    protected int getTablesRevision() {
        return this.tablesRevision;
    }

    protected void setTablesRevision(int tablesRevision) {
        this.tablesRevision = tablesRevision;
    }

    @Column(name="updatemate_id")
    public long getUpdatemateId() {
        return this.updatemateId;
    }

    public void setUpdatemateId(long updatemateId) {
        this.updatemateId = updatemateId;
    }

    @Column(name="redback_id")
    public long getRedbackId() {
        return this.redbackId;
    }

    public void setRedbackId(long redbackId) {
        this.redbackId = redbackId;
    }

    @Column(name="nag_for_email")
    public boolean isNagForEmail() {
        return this.nagForEmail;
    }

    public void setNagForEmail(boolean nagForEmail) {
        this.nagForEmail = nagForEmail;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property DATABASE_REVISION;
        public PropertiedObject.Property MODIFICATION_COUNT;
        public PropertiedObject.Property<TradingDay> CURRENT_TRADING_DAY;
        public PropertiedObject.Property<String> CURRENT_VERSION;
        public PropertiedObject.Property<Date> UPDATED;
        public PropertiedObject.Property MENU_REVISION;
        public PropertiedObject.Property TABLES_REVISION;
        public PropertiedObject.Property<Long> UPDATEMATE_ID;
        public PropertiedObject.Property<Long> REDBACK_ID;
        public PropertiedObject.Property NAG_FOR_EMAIL;
    }
}

