/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import ordermate.database.misc.ApplicationType;
import ordermate.security.impl.HashWithFixedSalt;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_system_password")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SystemPassword
extends PersistentObject
implements Saveable {
    public static final String ORDERMATE_SALT = "ordermate";
    public static final Props Properties = new Props();
    private String application;
    private String password;

    @Column(name="application")
    public String getApplication() {
        return this.application;
    }

    protected void setApplication(String value) {
        this.application = value;
    }

    @Column(name="password")
    public String getPassword() {
        return this.password;
    }

    protected void setPassword(String value) {
        this.password = value;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return false;
    }

    public static boolean validate(String givenPassword, ApplicationType applicationType) {
        ObjectQuery query = Query.select(SystemPassword.class).equals(SystemPassword.Properties.APPLICATION, applicationType.toString());
        List<SystemPassword> systemPasswordList = PersistenceManager.getObjectList(SystemPassword.class, query.toString(), null);
        boolean isSuperPassword = false;
        for (SystemPassword systemPassword : systemPasswordList) {
            try {
                if (!HashWithFixedSalt.verifyHash(givenPassword, systemPassword.getPassword(), ORDERMATE_SALT)) continue;
                isSuperPassword = true;
                break;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            }
        }
        return isSuperPassword;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property APPLICATION;
        public PropertiedObject.Property PASSWORD;
    }
}

