/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import au.com.ordermate.util.Price;
import au.com.ordermate.util.StringUtils;
import au.com.ordermate.util.image.IconLoader;
import java.io.File;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.swing.ImageIcon;
import ordermate.OrderMate;
import ordermate.database.finance.debtors.matchingstrategy.CustomerToDebtorMatchingStrategy;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.finance.priceadjustment.inventory.DeliveryPriceAdjustment;
import ordermate.database.finance.tax.TaxCode;
import ordermate.database.hardware.Terminal;
import ordermate.database.integration.online.OnlineIntegrationMode;
import ordermate.database.misc.SeatsMode;
import ordermate.database.misc.enums.DeterminePatrons;
import ordermate.database.misc.enums.DocketSortingType;
import ordermate.database.misc.enums.DriverAssignmentSettlementType;
import ordermate.database.misc.enums.FormAutoComboType;
import ordermate.database.misc.enums.ItemBarcodeType;
import ordermate.database.misc.enums.LanguageSupportType;
import ordermate.database.misc.enums.LoyaltyType;
import ordermate.database.misc.enums.MessageServerType;
import ordermate.database.misc.enums.OnlineIntegrationIDStrategy;
import ordermate.database.misc.enums.OpenAccountInReconciliationStrategy;
import ordermate.database.misc.enums.OversellModeType;
import ordermate.database.misc.enums.PhoneOrderForceContactStrategy;
import ordermate.database.misc.enums.PropertyIntegrationType;
import ordermate.database.misc.enums.ReservationIntegrationType;
import ordermate.database.misc.enums.ReservationWarnType;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.database.sales.AccountType;
import ordermate.database.sales.printSummary.collecting.CollectionStrategy;
import ordermate.database.stock.StockInvoicePricePreference;
import ordermate.integration.finance.myob.mapping.FinanceExportStyle;
import ordermate.misc.logging.ErrorTrackingProvider;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_system_property")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.NONSTRICT_READ_WRITE)
public class SystemProperty
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    public static final int POINTS = 0;
    public static final int DOLLARS = 1;
    private static Reference<SystemProperty> instance = new LocalCachedReference<SystemProperty>(new QueryReference<SystemProperty>(SystemProperty.class, Query.select(SystemProperty.class)));
    private boolean tablePositionsRevert;
    private Date changeDayTime;
    private boolean showPaymentStatus;
    private boolean showSectionOnDockets;
    private boolean loyaltyEnabled;
    private LoyaltyType loyaltyPointsType = LoyaltyType.POINTS;
    private int defaultPatronsPerTable;
    private boolean confirmationsEnabled;
    private boolean reservationsEnabled;
    private boolean splitBillEnabled;
    private boolean cctvEnabled;
    private boolean barStockEnabled;
    private PropertyIntegrationType propertyIntegration = PropertyIntegrationType.NONE;
    private ReservationWarnType reservationWarn = ReservationWarnType.ASK_IF_INTEGRATED;
    private ReservationIntegrationType reservationIntegration = ReservationIntegrationType.NONE;
    private String prepDocketLocation;
    private String receiptDocketLocation;
    private String takingsDocketLocation;
    private String reservationsDocketLocation;
    private String skimsDocketLocation;
    private MessageServerType messageServerType;
    private int messageServerPollTime;
    private int messageUpdaterPollTime;
    private boolean trainingModeEnabled;
    private boolean advancedAddRemoveEnabled;
    private boolean portionedModsEnabled;
    private boolean replicationEnabled;
    private boolean manualChangeOfDay;
    private String salesDocketLocation;
    private boolean blindSkimEnabled;
    private int limitOfOrderNumber;
    private boolean autoFillLastComment;
    private boolean autoFillLastItemsPhone;
    private boolean autoFillLastItemsTakeaway;
    private boolean autoFillLastItemsQuicksale;
    private boolean printerRedirection;
    private boolean priceByDearest;
    private boolean priceOverrideMods;
    private Price accountCreditLimit;
    private Price tabCreditLimit;
    private Price roomCreditLimit;
    private boolean timeSync;
    private boolean singlePaymentMode;
    private boolean autoTabSelection;
    private boolean retroCustPriceUpdates;
    private int printerTimeout;
    private double loyaltyRedeemRatio;
    private double loyaltyAddRatio;
    private boolean autoClockOn;
    private boolean fadeBackground;
    private FormAutoComboType formAutoCombo = FormAutoComboType.FORM_AUTO_COMBOS_ALL;
    private int maxNumbFigures;
    private String supportMessage1;
    private String supportMessage2;
    private String messageOfTheDay;
    private String remoteMonitorUrl;
    private boolean takingsExDiscounts;
    private DocketSortingType defaultDocketSorting = DocketSortingType.COMBO_GROUP_ITEM_NAME;
    private String debtorDocketLocation;
    private boolean showSOHInFrontEnd;
    private boolean showStockCountInFrontEnd;
    private OversellModeType oversellMode = OversellModeType.IGNORE;
    private OversellModeType stockCountdownOversellMode = OversellModeType.IGNORE;
    private boolean stockCountDownEnabled;
    private String orderNumberPrefix;
    private int nextOrderNumber;
    private boolean stockControlEnabled;
    private int autoGeneratePLU;
    private boolean lockStocklessItems;
    private boolean closeAccAfterDelivered;
    private String tableImagesPath;
    private boolean liquorfileEnabled;
    private boolean showTransferSummary;
    private boolean fractionalQtys;
    private String twitterUserName;
    private String twitterAccessToken;
    private String twitterAccessSecretToken;
    private boolean happyCustomerEnabled;
    private String supportPhone;
    private String trainingPhone;
    private boolean neverPrintTransferred;
    private boolean neverPrintDeleted;
    private boolean warnOnRemoveDiscountWhenTransfer;
    private boolean deliveryFeeCountsToMinOrderAmount;
    private FinanceExportStyle financeIntegration;
    private Reference<DeliveryPriceAdjustment> deliveryFee;
    private boolean showAccId;
    private String invoicePaymentDetail;
    private boolean comboByCost;
    private boolean dontPrintSeatAllWhenItIsOnlySeatForAnItem;
    private boolean enforceBiometricClockon;
    private OnlineIntegrationMode onlineIntegrationMode;
    private boolean useDeliveryZones;
    private String poleDefaultLine1;
    private String poleDefaultLine2;
    private boolean singleCoursePrinting;
    private DeterminePatrons determinePatrons;
    private CollectionStrategy receiptGrouping;
    private OnlineIntegrationIDStrategy onlineIntegrationIdStrategy;
    private Long rmsCashAccountId;
    private double profitMarginPerc;
    private boolean suggestedOrderIncPurchases;
    private String cusPortalPasswordMsg;
    private AccountType defaultQuickSaleAccType;
    private boolean promptNameBartab;
    private boolean coursePrinted;
    private String cameraViewIp;
    private String cameraViewPort;
    private boolean printWastageDockets;
    private boolean printCustPwdOnQuickAdd;
    private String updateMateScriptDir;
    private StockInvoicePricePreference stockInvoicePricePreference;
    private boolean showSizesOnComboItems;
    private SeatsMode seatsMode;
    private boolean twitterActive;
    private int futureOrderDocketTime;
    private boolean onlineIntegrationPrintDocketOnly;
    private boolean onlineIntegrationFull;
    private boolean lockDebtorWithoutCustomerSet;
    private CustomerToDebtorMatchingStrategy customerToDebtorMatchingStrategy;
    private int deviceFailureNumRetryAttempts;
    private int deviceFailureSecsBetweenAttempts;
    private ItemBarcodeType itemBarcodeType;
    private boolean reconciliationSystemTotalIncludesTips;
    private boolean previousSalesLocalTerminalOnly;
    private boolean enforceBasePricesEnabled;
    private boolean printBarTabTransfers;
    private boolean hideNoItemsInSummary;
    private Long workflowFrequency;
    private PhoneOrderForceContactStrategy phoneOrderForceStrategy;
    private boolean reassignCustomerComment;
    private boolean blockDuplicateOnlineOrders;
    private boolean combosAsDiscount;
    private boolean showChange;
    private boolean onlinePhoneSetTimeDue;
    private boolean labourFiguresClockedOffOnly;
    private boolean coversAndSeatsSeparated;
    private boolean customerAssignmentPerSeat;
    private boolean exTax;
    private boolean printZeroDollarItems;
    private boolean ktsUnholdToEndOfQueue;
    private ErrorTrackingProvider errorTrackingProvider;
    private double stockPriceWarn;
    private boolean autoPrintStockReq;
    private OpenAccountInReconciliationStrategy openAccountInReconciliationStrategy;
    private Reference<TaxCode> baseTaxCode;
    private boolean printBigChinese;
    private boolean printQueueCrawler;
    private int multiProcessorPrinting;
    private boolean printPortOptimisation;
    private boolean splitChinese;
    private String ignoreSplitChinese;
    private boolean onThreadIntegration;
    private boolean includeMiddleChecksum;
    private LanguageSupportType languageSupport;
    private String emailSender;
    private DriverAssignmentSettlementType driverAssignmentSettlement;
    private String dbCheckSchedule;
    private int webserviceConnTimeout;
    private int webserviceReadTimeout;

    public SystemProperty() {
        this.deliveryFee = this.createReference(SystemProperty.Properties.DELIVERY_FEE);
        this.comboByCost = false;
        this.enforceBiometricClockon = false;
        this.useDeliveryZones = false;
        this.determinePatrons = DeterminePatrons.Gui;
        this.receiptGrouping = CollectionStrategy.None;
        this.onlineIntegrationIdStrategy = OnlineIntegrationIDStrategy.POS_DB;
        this.cusPortalPasswordMsg = "";
        this.itemBarcodeType = ItemBarcodeType.Weight;
        this.phoneOrderForceStrategy = PhoneOrderForceContactStrategy.PHONE_ORDER_FORCE_NONE;
        this.combosAsDiscount = false;
        this.showChange = false;
        this.labourFiguresClockedOffOnly = true;
        this.exTax = false;
        this.printZeroDollarItems = false;
        this.ktsUnholdToEndOfQueue = false;
        this.stockPriceWarn = 0.1;
        this.autoPrintStockReq = false;
        this.openAccountInReconciliationStrategy = OpenAccountInReconciliationStrategy.WARN;
        this.baseTaxCode = this.createReference(SystemProperty.Properties.BASE_TAX_CODE);
        this.includeMiddleChecksum = true;
        this.languageSupport = LanguageSupportType.Default;
        this.driverAssignmentSettlement = DriverAssignmentSettlementType.BOTH;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.deliveryFee.saveChild();
        PersistenceManager.save(this);
        PersistenceManager.getInstance().clearLocalCaches();
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static SystemProperty getInstance() {
        return instance.get();
    }

    public static void clearCache() {
        instance.collapse();
    }

    @Column(name="TablePositionsRevert")
    public boolean isTablePositionsRevert() {
        return this.tablePositionsRevert;
    }

    public void setTablePositionsRevert(boolean revert) {
        this.tablePositionsRevert = revert;
    }

    @Column(name="Change_Day_Time")
    @Temporal(value=TemporalType.TIME)
    public Date getChangeDayTime() {
        return this.changeDayTime;
    }

    public void setChangeDayTime(Date newTime) {
        this.changeDayTime = newTime;
    }

    @Column(name="show_payment")
    public boolean isShowPaymentStatus() {
        return this.showPaymentStatus;
    }

    public void setShowPaymentStatus(boolean newValue) {
        this.showPaymentStatus = newValue;
    }

    @Column(name="ShowSectionOnDockets")
    public boolean isShowSectionOnDockets() {
        return this.showSectionOnDockets;
    }

    public void setShowSectionOnDockets(boolean newValue) {
        this.showSectionOnDockets = newValue;
    }

    @Column(name="loyalty")
    public boolean isLoyaltyEnabled() {
        return this.loyaltyEnabled;
    }

    public void setLoyaltyEnabled(boolean newValue) {
        this.loyaltyEnabled = newValue;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.LoyaltyType")})
    @Column(name="loyalty_points_type")
    public LoyaltyType getLoyaltyPointsType() {
        return this.loyaltyPointsType;
    }

    public void setLoyaltyPointsType(LoyaltyType newValue) {
        this.loyaltyPointsType = newValue;
    }

    @Column(name="block_duplicate_online_orders")
    public boolean isBlockDuplicateOnlineOrders() {
        return this.blockDuplicateOnlineOrders;
    }

    public void setBlockDuplicateOnlineOrders(boolean blockOODuplicates) {
        this.blockDuplicateOnlineOrders = blockOODuplicates;
    }

    @Column(name="online_phone_set_time_due")
    public boolean isOnlinePhoneSetTimeDue() {
        return this.onlinePhoneSetTimeDue;
    }

    public void setOnlinePhoneSetTimeDue(boolean setTimeDue) {
        this.onlinePhoneSetTimeDue = setTimeDue;
    }

    @Column(name="labour_figures_clocked_off_only")
    public boolean isLabourFiguresClockedOffOnly() {
        return this.labourFiguresClockedOffOnly;
    }

    public void setLabourFiguresClockedOffOnly(boolean clockedOffOnly) {
        this.labourFiguresClockedOffOnly = clockedOffOnly;
    }

    @Transient
    public boolean isDollarsTypeEnabled() {
        return this.getLoyaltyPointsType().equals(LoyaltyType.DOLLARS);
    }

    @Transient
    public boolean isPointsTypeEnabled() {
        return this.getLoyaltyPointsType().equals(LoyaltyType.POINTS);
    }

    @Column(name="default_patrons_per_table")
    public int getDefaultPatronsPerTable() {
        return this.defaultPatronsPerTable;
    }

    public void setDefaultPatronsPerTable(int newValue) {
        this.defaultPatronsPerTable = newValue;
    }

    @Column(name="confirmations")
    public boolean isConfirmationsEnabled() {
        return this.confirmationsEnabled;
    }

    public void setConfirmationsEnabled(boolean newValue) {
        this.confirmationsEnabled = newValue;
    }

    @Column(name="reservations")
    public boolean isReservationsEnabled() {
        return this.reservationsEnabled;
    }

    public void setReservationsEnabled(boolean value) {
        this.reservationsEnabled = value;
    }

    @Column(name="split_bill")
    public boolean isSplitBillEnabled() {
        return this.splitBillEnabled;
    }

    public void setSplitBillEnabled(boolean value) {
        this.splitBillEnabled = value;
    }

    @Column(name="cctv_integration")
    public boolean isCctvEnabled() {
        return this.cctvEnabled;
    }

    public void setCctvEnabled(boolean value) {
        this.cctvEnabled = value;
    }

    @Column(name="barstock_integration")
    public boolean isBarStockEnabled() {
        return this.barStockEnabled;
    }

    public void setBarStockEnabled(boolean value) {
        this.barStockEnabled = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.PropertyIntegrationType")})
    @Column(name="property_integration")
    public PropertyIntegrationType getPropertyIntegration() {
        return this.propertyIntegration;
    }

    public void setPropertyIntegration(PropertyIntegrationType newValue) {
        this.propertyIntegration = newValue;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.PhoneOrderForceContactStrategy")})
    @Column(name="phone_order_force_strategy")
    public PhoneOrderForceContactStrategy getPhoneOrderForceStrategy() {
        return this.phoneOrderForceStrategy;
    }

    public void setPhoneOrderForceStrategy(PhoneOrderForceContactStrategy newValue) {
        this.phoneOrderForceStrategy = newValue;
    }

    @Transient
    public boolean isPropertyManagementIntegrationEnabled() {
        boolean result;
        boolean enabled = !this.getPropertyIntegration().equals(PropertyIntegrationType.NONE);
        PersistentLicenseManager license = PersistentLicenseManager.getInstance();
        boolean bl = result = enabled && (license.getBoolean(LicenseType.ReservationIntegrationEnabled) || license.getBoolean(LicenseType.RMSIntegrationEnabled));
        if (!result && enabled) {
            OrderMate.LOG.warn("Property integration is enabled in system property but is not licensed.  Integration will not work.");
        }
        return result;
    }

    @Column(name="prep_docket_location")
    public String getPrepDocketLocation() {
        return this.prepDocketLocation;
    }

    public void setPrepDocketLocation(String newLocation) {
        this.prepDocketLocation = newLocation;
    }

    @Column(name="receipt_docket_location")
    public String getReceiptDocketLocation() {
        return this.receiptDocketLocation;
    }

    public void setReceiptDocketLocation(String newValue) {
        this.receiptDocketLocation = newValue;
    }

    @Column(name="sales_docket_location")
    public String getSalesDocketLocation() {
        return this.salesDocketLocation;
    }

    public void setSalesDocketLocation(String value) {
        this.salesDocketLocation = value;
    }

    @Column(name="takings_docket_location")
    public String getTakingsDocketLocation() {
        return this.takingsDocketLocation;
    }

    public void setTakingsDocketLocation(String value) {
        this.takingsDocketLocation = value;
    }

    @Column(name="reservations_docket_location")
    public String getReservationsDocketLocation() {
        return this.reservationsDocketLocation;
    }

    public void setReservationsDocketLocation(String newValue) {
        this.reservationsDocketLocation = newValue;
    }

    @Column(name="skims_docket_location")
    public String getSkimsDocketLocation() {
        return this.skimsDocketLocation;
    }

    public void setSkimsDocketLocation(String newValue) {
        this.skimsDocketLocation = newValue;
    }

    @Column(name="message_commands")
    @Enumerated
    public MessageServerType getMessageServerType() {
        return this.messageServerType;
    }

    public void setMessageServerType(MessageServerType messageServerType) {
        this.messageServerType = messageServerType;
    }

    @Column(name="message_check_time")
    public int getMessageServerPollTime() {
        return this.messageServerPollTime;
    }

    public void setMessageServerPollTime(int value) {
        this.messageServerPollTime = value;
    }

    @Column(name="message_server_db_sync_time")
    public int getMessageUpdaterPollTime() {
        return this.messageUpdaterPollTime;
    }

    public void setMessageUpdaterPollTime(int newValue) {
        this.messageUpdaterPollTime = newValue;
    }

    @Column(name="training_mode")
    public boolean isTrainingModeEnabled() {
        return this.trainingModeEnabled;
    }

    public void setTrainingModeEnabled(boolean value) {
        this.trainingModeEnabled = value;
    }

    @Column(name="advanced_add_remove")
    public boolean isAdvancedAddRemoveEnabled() {
        return this.advancedAddRemoveEnabled;
    }

    public void setAdvancedAddRemoveEnabled(boolean value) {
        this.advancedAddRemoveEnabled = value;
    }

    @Column(name="portioned_mods")
    public boolean isPortionedModsEnabled() {
        return this.portionedModsEnabled;
    }

    public void setPortionedModsEnabled(boolean enabled) {
        this.portionedModsEnabled = enabled;
    }

    @Column(name="remote_replication")
    public boolean isReplicationEnabled() {
        return this.replicationEnabled;
    }

    public void setReplicationEnabled(boolean value) {
        this.replicationEnabled = value;
    }

    @Column(name="blind_skim")
    public boolean isBlindSkimEnabled() {
        return this.blindSkimEnabled;
    }

    public void setBlindSkimEnabled(boolean value) {
        this.blindSkimEnabled = value;
    }

    @Column(name="manual_change_of_day")
    public boolean isManualChangeOfDay() {
        return this.manualChangeOfDay;
    }

    public void setManualChangeOfDay(boolean value) {
        this.manualChangeOfDay = value;
    }

    @Column(name="auto_fill_last_comment")
    public boolean isAutoFillLastComment() {
        return this.autoFillLastComment;
    }

    public void setAutoFillLastComment(boolean value) {
        this.autoFillLastComment = value;
    }

    @Column(name="auto_fill_last_items_phone")
    public boolean isAutoFillLastItemsPhone() {
        return this.autoFillLastItemsPhone;
    }

    public void setAutoFillLastItemsPhone(boolean value) {
        this.autoFillLastItemsPhone = value;
    }

    @Column(name="auto_fill_last_items_takeaway")
    public boolean isAutoFillLastItemsTakeaway() {
        return this.autoFillLastItemsTakeaway;
    }

    public void setAutoFillLastItemsTakeaway(boolean value) {
        this.autoFillLastItemsTakeaway = value;
    }

    @Column(name="auto_fill_last_items_quicksale")
    public boolean isAutoFillLastItemsQuicksale() {
        return this.autoFillLastItemsQuicksale;
    }

    public void setAutoFillLastItemsQuicksale(boolean value) {
        this.autoFillLastItemsQuicksale = value;
    }

    @Column(name="limit_of_order_number")
    public int getLimitOfOrderNumber() {
        return this.limitOfOrderNumber;
    }

    public void setLimitOfOrderNumber(int value) {
        this.limitOfOrderNumber = value;
    }

    @Column(name="printer_redirection")
    public boolean isPrinterRedirection() {
        return this.printerRedirection;
    }

    public void setPrinterRedirection(boolean value) {
        this.printerRedirection = value;
    }

    @Column(name="price_by_dearest")
    public boolean isPriceByDearest() {
        return this.priceByDearest;
    }

    public void setPriceByDearest(boolean set) {
        this.priceByDearest = set;
    }

    @Column(name="price_override_mods")
    public boolean isPriceOverrideMods() {
        return this.priceOverrideMods;
    }

    public void setPriceOverrideMods(boolean set) {
        this.priceOverrideMods = set;
    }

    @Column(name="room_credit_limit")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getRoomCreditLimit() {
        return this.roomCreditLimit;
    }

    public void setRoomCreditLimit(Price value) {
        this.roomCreditLimit = value;
    }

    @Column(name="tab_credit_limit")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getTabCreditLimit() {
        return this.tabCreditLimit;
    }

    public void setTabCreditLimit(Price value) {
        this.tabCreditLimit = new Price(value, 0.01);
    }

    @Column(name="account_credit_limit")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.PriceMapping", parameters={@Parameter(name="rounding", value="0.01")})
    public Price getAccountCreditLimit() {
        return this.accountCreditLimit;
    }

    public void setAccountCreditLimit(Price value) {
        this.accountCreditLimit = new Price(value, 0.01);
    }

    @Column(name="time_sync")
    public boolean isTimeSync() {
        return this.timeSync;
    }

    public void setTimeSync(boolean value) {
        this.timeSync = value;
    }

    @Column(name="single_payment_mode")
    public boolean isSinglePaymentMode() {
        return this.singlePaymentMode;
    }

    public void setSinglePaymentMode(boolean value) {
        this.singlePaymentMode = value;
    }

    @Column(name="auto_tab_selection")
    public boolean isAutoTabSelection() {
        return this.autoTabSelection;
    }

    public void setAutoTabSelection(boolean value) {
        this.autoTabSelection = value;
    }

    public void setRetroCustPriceUpdates(boolean newRetroCustomerPriceUpdate) {
        this.retroCustPriceUpdates = newRetroCustomerPriceUpdate;
    }

    @Column(name="retro_cust_price_update")
    public boolean isRetroCustPriceUpdates() {
        return this.retroCustPriceUpdates;
    }

    @Column(name="printer_timeout")
    public int getPrinterTimeout() {
        return this.printerTimeout;
    }

    public void setPrinterTimeout(int value) {
        this.printerTimeout = value;
    }

    @Column(name="loyalty_redeem_ratio")
    public double getLoyaltyRedeemRatio() {
        return this.loyaltyRedeemRatio;
    }

    public void setLoyaltyRedeemRatio(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Cannot set a value that is not a number");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Cannot set a value that is infinite");
        }
        this.loyaltyRedeemRatio = value;
    }

    @Column(name="loyalty_add_ratio")
    public double getLoyaltyAddRatio() {
        return this.loyaltyAddRatio;
    }

    public void setLoyaltyAddRatio(double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Cannot set a value that is not a number");
        }
        if (Double.isInfinite(value)) {
            throw new IllegalArgumentException("Cannot set a value that is infinite");
        }
        this.loyaltyAddRatio = value;
    }

    @Column(name="auto_clock_on")
    public boolean isAutoClockOn() {
        return this.autoClockOn;
    }

    public void setAutoClockOn(boolean value) {
        this.autoClockOn = value;
    }

    @Column(name="fade_background")
    public boolean isFadeBackground() {
        return this.fadeBackground;
    }

    public void setFadeBackground(boolean value) {
        this.fadeBackground = value;
    }

    public boolean formAutoCombosFromAdmin() {
        return this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ALL) || this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ALL_BUT_ORDERING);
    }

    public boolean formAutoCombosOnPayment() {
        return this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ALL) || this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ALL_BUT_ORDERING) || this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ON_PAYMENT);
    }

    public boolean formAutoCombosOnOrder() {
        return this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ALL) || this.formAutoCombo.equals(FormAutoComboType.FORM_AUTO_COMBOS_ON_ORDERING);
    }

    public void setFormAutoCombo(FormAutoComboType value) {
        this.formAutoCombo = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.FormAutoComboType")})
    @Column(name="form_auto_combo")
    public FormAutoComboType getFormAutoCombo() {
        return this.formAutoCombo;
    }

    @Column(name="max_numb_figures")
    public int getMaxNumbFigures() {
        return this.maxNumbFigures;
    }

    public void setMaxNumbFigures(int value) {
        this.maxNumbFigures = value;
    }

    @Column(name="support_message1")
    public String getSupportMessage1() {
        return this.supportMessage1;
    }

    public void setSupportMessage1(String value) {
        this.supportMessage1 = value;
    }

    @Column(name="support_message2")
    public String getSupportMessage2() {
        return this.supportMessage2;
    }

    public void setSupportMessage2(String value) {
        this.supportMessage2 = value;
    }

    public void setMessageOfTheDay(String newMessageOfTheDay) {
        this.messageOfTheDay = newMessageOfTheDay;
    }

    @Column(name="message_of_the_day")
    public String getMessageOfTheDay() {
        return this.messageOfTheDay;
    }

    @Column(name="remote_monitor_url")
    public String getRemoteMonitorUrl() {
        return this.remoteMonitorUrl;
    }

    public void setRemoteMonitorUrl(String url) {
        this.remoteMonitorUrl = url;
    }

    @Column(name="takings_ex_discounts")
    public boolean isTakingsExDiscounts() {
        return this.takingsExDiscounts;
    }

    public void setTakingsExDiscounts(boolean value) {
        this.takingsExDiscounts = value;
    }

    public void setDefaultDocketSorting(DocketSortingType theDefaultDocketSorting) {
        this.defaultDocketSorting = theDefaultDocketSorting;
    }

    @Column(name="default_docket_sorting")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.DocketSortingType")})
    public DocketSortingType getDefaultDocketSorting() {
        return this.defaultDocketSorting;
    }

    @Column(name="online_integration_mode")
    @Enumerated(value=EnumType.STRING)
    @Deprecated
    public OnlineIntegrationMode getOnlineIntegrationMode() {
        return this.onlineIntegrationMode;
    }

    @Deprecated
    public void setOnlineIntegrationMode(OnlineIntegrationMode newMode) {
        this.onlineIntegrationMode = newMode;
    }

    @Column(name="debtor_stmt_docket_location")
    public String getDebtorDocketLocation() {
        return this.debtorDocketLocation;
    }

    public void setDebtorDocketLocation(String docketLocation) {
        this.debtorDocketLocation = docketLocation;
    }

    public void setShowSOHInFrontEnd(boolean newShowSOHInFrontEndValue) {
        this.showSOHInFrontEnd = newShowSOHInFrontEndValue;
    }

    @Column(name="ShowSOHInFrontEnd")
    public boolean isShowSOHInFrontEnd() {
        return this.showSOHInFrontEnd;
    }

    @Column(name="ShowStockCountInFrontEnd")
    public boolean isShowStockCountInFrontEnd() {
        return this.showStockCountInFrontEnd;
    }

    public void setShowStockCountInFrontEnd(boolean value) {
        this.showStockCountInFrontEnd = value;
    }

    public void setOversellMode(OversellModeType newOversellModeValue) {
        this.oversellMode = newOversellModeValue;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.OversellModeType")})
    @Column(name="OversellMode")
    public OversellModeType getOversellMode() {
        return this.oversellMode;
    }

    public void setStockCountdownOversellMode(OversellModeType newOversellModeValue) {
        this.stockCountdownOversellMode = newOversellModeValue;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.OversellModeType")})
    @Column(name="StockCountdownOversellMode")
    public OversellModeType getStockCountdownOversellMode() {
        return this.stockCountdownOversellMode;
    }

    public void setStockCountDownEnabled(boolean newStockCountDownEnabledValue) {
        this.stockCountDownEnabled = newStockCountDownEnabledValue;
    }

    @Column(name="StockCountDownEnabled")
    public boolean isStockCountDownEnabled() {
        return this.stockCountDownEnabled;
    }

    public void setOrderNumberPrefix(String newOrderNumberPrefixValue) {
        this.orderNumberPrefix = newOrderNumberPrefixValue;
    }

    @Column(name="OrderNumberPrefix")
    public String getOrderNumberPrefix() {
        return this.orderNumberPrefix;
    }

    public void setNextOrderNumber(int newNextOrderNumber) {
        this.nextOrderNumber = newNextOrderNumber;
    }

    @Column(name="NextOrderNumber")
    public int getNextOrderNumber() {
        return this.nextOrderNumber;
    }

    public void setStockControlEnabled(boolean newStockControlValue) {
        this.stockControlEnabled = newStockControlValue;
    }

    @Column(name="StockControlEnabled")
    public boolean isStockControlEnabled() {
        return this.stockControlEnabled;
    }

    public void setAutoGeneratePLU(int newAutoGeneratePLU) {
        this.autoGeneratePLU = newAutoGeneratePLU;
    }

    @Column(name="auto_generate_plu")
    public int getAutoGeneratePLU() {
        return this.autoGeneratePLU;
    }

    public void setLockStocklessItems(boolean newLockStocklessItemsValue) {
        this.lockStocklessItems = newLockStocklessItemsValue;
    }

    @Column(name="lock_stockless_items")
    public boolean isLockStocklessItems() {
        return this.lockStocklessItems;
    }

    public void setTableImagesPath(String path) {
        this.tableImagesPath = path;
    }

    @Column(name="table_images_path")
    public String getTableImagesPath() {
        return this.tableImagesPath;
    }

    @Column(name="liquorfile_enabled")
    public boolean isLiquorfileEnabled() {
        return this.liquorfileEnabled;
    }

    public void setLiquorfileEnabled(boolean value) {
        this.liquorfileEnabled = value;
    }

    @Column(name="show_transfer_summary")
    public boolean isShowTransferSummary() {
        return this.showTransferSummary;
    }

    public void setShowTransferSummary(boolean value) {
        this.showTransferSummary = value;
    }

    @Column(name="fractional_qtys")
    public boolean isFractionalQtys() {
        return this.fractionalQtys;
    }

    public void setFractionalQtys(boolean enabled) {
        this.fractionalQtys = enabled;
    }

    @Transient
    public Map<String, ImageIcon> getTableImages() {
        LinkedHashMap<String, ImageIcon> retVal = new LinkedHashMap<String, ImageIcon>();
        String path = this.getTableImagesPath();
        int NUM_DEFAULT_IMAGES = 3;
        SystemProperty.loadInCustomTableImages(retVal, path, 3);
        try {
            retVal.put("/ordermate/images/tableLarge.png", IconLoader.get("/ordermate/images/tableLarge.png"));
            retVal.put("/ordermate/images/tableMedium.png", IconLoader.get("/ordermate/images/tableMedium.png"));
            retVal.put("/ordermate/images/tableSmall.png", IconLoader.get("/ordermate/images/tableSmall.png"));
            retVal.put("/ordermate/images/tables/squareTableLarge.png", IconLoader.get("/ordermate/images/tables/squareTableLarge.png"));
            retVal.put("/ordermate/images/tables/squareTable.png", IconLoader.get("/ordermate/images/tables/squareTable.png"));
            retVal.put("/ordermate/images/tables/squareTableSmall.png", IconLoader.get("/ordermate/images/tables/squareTableSmall.png"));
            retVal.put("/ordermate/images/tableRoundLarge.png", IconLoader.get("/ordermate/images/tableRoundLarge.png"));
            retVal.put("/ordermate/images/tables/tableRound.png", IconLoader.get("/ordermate/images/tables/tableRound.png"));
            retVal.put("/ordermate/images/tables/ovalTable.png", IconLoader.get("/ordermate/images/tables/ovalTable.png"));
            retVal.put("/ordermate/images/tables/roundTableLarge.png", IconLoader.get("/ordermate/images/tables/roundTableLarge.png"));
            retVal.put("/ordermate/images/tables/roundTable.png", IconLoader.get("/ordermate/images/tables/roundTable.png"));
            retVal.put("/ordermate/images/tables/roundTableSmall.png", IconLoader.get("/ordermate/images/tables/roundTableSmall.png"));
            retVal.put("/ordermate/images/tables/FiveSeater.png", IconLoader.get("/ordermate/images/tables/FiveSeater.png"));
            retVal.put("/ordermate/images/tables/ThreeSeater.png", IconLoader.get("/ordermate/images/tables/ThreeSeater.png"));
            retVal.put("/ordermate/images/tables/curvedCouch.png", IconLoader.get("/ordermate/images/tables/curvedCouch.png"));
            retVal.put("/ordermate/images/tables/poolTable.png", IconLoader.get("/ordermate/images/tables/poolTable.png"));
            retVal.put("/ordermate/images/tables/potPlant.png", IconLoader.get("/ordermate/images/tables/potPlant.png"));
            retVal.put("/ordermate/images/tables/potPlantSmall.png", IconLoader.get("/ordermate/images/tables/potPlantSmall.png"));
            retVal.put("/ordermate/images/tables/barstoolRed.png", IconLoader.get("/ordermate/images/tables/barstoolRed.png"));
            retVal.put("/ordermate/images/tables/cornercouchLRPink.png", IconLoader.get("/ordermate/images/tables/cornercouchLRPink.png"));
            retVal.put("/ordermate/images/tables/cornercouchLLPink.png", IconLoader.get("/ordermate/images/tables/cornercouchLLPink.png"));
            retVal.put("/ordermate/images/tables/cornercouchURPink.png", IconLoader.get("/ordermate/images/tables/cornercouchURPink.png"));
            retVal.put("/ordermate/images/tables/cornercouchULPink.png", IconLoader.get("/ordermate/images/tables/cornercouchULPink.png"));
            retVal.put("/ordermate/images/tables/couchhorizontalUPink.png", IconLoader.get("/ordermate/images/tables/couchhorizontalUPink.png"));
            retVal.put("/ordermate/images/tables/couchhorizontalLPink.png", IconLoader.get("/ordermate/images/tables/couchhorizontalLPink.png"));
            retVal.put("/ordermate/images/tables/couchvertLPink.png", IconLoader.get("/ordermate/images/tables/couchvertLPink.png"));
            retVal.put("/ordermate/images/tables/couchvertRPink.png", IconLoader.get("/ordermate/images/tables/couchvertRPink.png"));
            retVal.put("/ordermate/images/tables/darkskinnycornerLR.png", IconLoader.get("/ordermate/images/tables/darkskinnycornerLR.png"));
            retVal.put("/ordermate/images/tables/darkskinnycornerUR.png", IconLoader.get("/ordermate/images/tables/darkskinnycornerUR.png"));
            retVal.put("/ordermate/images/tables/darkskinnycornerLL.png", IconLoader.get("/ordermate/images/tables/darkskinnycornerLL.png"));
            retVal.put("/ordermate/images/tables/darkskinnycornerUL.png", IconLoader.get("/ordermate/images/tables/darkskinnycornerUL.png"));
            retVal.put("/ordermate/images/tables/darkTableSkinnyHorizontal.png", IconLoader.get("/ordermate/images/tables/darkTableSkinnyHorizontal.png"));
            retVal.put("/ordermate/images/tables/darkTableSkinnyVert.png", IconLoader.get("/ordermate/images/tables/darkTableSkinnyVert.png"));
            retVal.put("/ordermate/images/tables/endcouchLL.png", IconLoader.get("/ordermate/images/tables/endcouchLL.png"));
            retVal.put("/ordermate/images/tables/endcouchLR.png", IconLoader.get("/ordermate/images/tables/endcouchLR.png"));
            retVal.put("/ordermate/images/tables/endcouchUL.png", IconLoader.get("/ordermate/images/tables/endcouchUL.png"));
            retVal.put("/ordermate/images/tables/endcouchUR.png", IconLoader.get("/ordermate/images/tables/endcouchUR.png"));
            retVal.put("/ordermate/images/tables/singlecouchLower.png", IconLoader.get("/ordermate/images/tables/singlecouchLower.png"));
            retVal.put("/ordermate/images/tables/singlecouchUpper.png", IconLoader.get("/ordermate/images/tables/singlecouchUpper.png"));
            retVal.put("/ordermate/images/tables/singlecouchLeft.png", IconLoader.get("/ordermate/images/tables/singlecouchLeft.png"));
            retVal.put("/ordermate/images/tables/singlecouchRight.png", IconLoader.get("/ordermate/images/tables/singlecouchRight.png"));
            retVal.put("/ordermate/images/tables/skinnycornerLL.png", IconLoader.get("/ordermate/images/tables/skinnycornerLL.png"));
            retVal.put("/ordermate/images/tables/skinnycornerLR.png", IconLoader.get("/ordermate/images/tables/skinnycornerLR.png"));
            retVal.put("/ordermate/images/tables/skinnycornerUL.png", IconLoader.get("/ordermate/images/tables/skinnycornerUL.png"));
            retVal.put("/ordermate/images/tables/skinnycornerUR.png", IconLoader.get("/ordermate/images/tables/skinnycornerUR.png"));
            retVal.put("/ordermate/images/tables/TableDouble.png", IconLoader.get("/ordermate/images/tables/TableDouble.png"));
            retVal.put("/ordermate/images/tables/TableDoubleVert.png", IconLoader.get("/ordermate/images/tables/TableDoubleVert.png"));
            retVal.put("/ordermate/images/tables/TableLong.png", IconLoader.get("/ordermate/images/tables/TableLong.png"));
            retVal.put("/ordermate/images/tables/TableLongVert.png", IconLoader.get("/ordermate/images/tables/TableLongVert.png"));
            retVal.put("/ordermate/images/tables/TableSkinnyHorizontal.png", IconLoader.get("/ordermate/images/tables/TableSkinnyHorizontal.png"));
            retVal.put("/ordermate/images/tables/TableSkinnyVert.png", IconLoader.get("/ordermate/images/tables/TableSkinnyVert.png"));
            retVal.put("/ordermate/images/tables/ThreeSeaterHorizUpperPink.png", IconLoader.get("/ordermate/images/tables/ThreeSeaterHorizUpperPink.png"));
        }
        catch (IconLoader.IconNotFoundException ex) {
            OrderMate.LOG.error("Icon not found when getting table images.", (Throwable)ex);
        }
        return retVal;
    }

    private static void loadInCustomTableImages(Map<String, ImageIcon> retVal, String path, int numDefaultImages) {
        File file;
        if (path != null && path.length() <= 1) {
            return;
        }
        if (!path.startsWith("/") || !path.startsWith("\\")) {
            path = "/" + path;
        }
        if ((file = new File(path = "//" + Terminal.getServerMateTerminal().getIPAddress() + path)).exists()) {
            if (file.isDirectory()) {
                File[] files;
                for (File imageFile : files = file.listFiles()) {
                    String fullName = path + imageFile.getName();
                    try {
                        if (!SystemProperty.isImageFile(imageFile.getName())) continue;
                        try {
                            ImageIcon icon = IconLoader.get(fullName);
                            if (icon == null) continue;
                            retVal.put(fullName, icon);
                        }
                        catch (IconLoader.IconNotFoundException ex) {
                            OrderMate.LOG.warn(imageFile.getName() + " in images/tableimages directory is not a valid image file.", (Throwable)ex);
                        }
                    }
                    catch (IconLoader.IconNotFoundException ex2) {
                        OrderMate.LOG.warn("Problem loading icon for table :" + fullName, (Throwable)ex2);
                    }
                }
            } else {
                OrderMate.LOG.warn("System property table path should be a directory not a file.  Path: " + path);
            }
        } else {
            OrderMate.LOG.warn("System property table path does not exist :" + path);
        }
        if (retVal.size() == numDefaultImages) {
            OrderMate.LOG.info("Could not find any table images in : " + path);
        }
    }

    private static boolean isImageFile(String filename) {
        String filenameLowercase = filename.toLowerCase();
        return filenameLowercase.endsWith(".png") || filenameLowercase.endsWith(".jpg") || filenameLowercase.endsWith(".jpeg") || filenameLowercase.endsWith(".gif");
    }

    public void setTwitterUserName(String userName) {
        this.twitterUserName = userName;
    }

    @Column(name="twitter_username")
    public String getTwitterUserName() {
        return this.twitterUserName;
    }

    @Column(name="twitter_access_token")
    public String getTwitterAccessToken() {
        return this.twitterAccessToken;
    }

    public void setTwitterAccessToken(String token) {
        this.twitterAccessToken = token;
    }

    @Column(name="twitter_access_secret_token")
    public String getTwitterAccessSecretToken() {
        return this.twitterAccessSecretToken;
    }

    public void setTwitterAccessSecretToken(String twitterAccessSecretToken) {
        this.twitterAccessSecretToken = twitterAccessSecretToken;
    }

    @Column(name="happy_customer")
    public boolean isHappyCustomerEnabled() {
        return this.happyCustomerEnabled;
    }

    public void setHappyCustomerEnabled(boolean enabled) {
        this.happyCustomerEnabled = enabled;
    }

    @Column(name="support_phone")
    public String getSupportPhone() {
        return this.supportPhone;
    }

    public void setSupportPhone(String phone) {
        this.supportPhone = phone;
    }

    @Column(name="training_phone")
    public String getTrainingPhone() {
        return this.trainingPhone;
    }

    public void setTrainingPhone(String phone) {
        this.trainingPhone = phone;
    }

    public void setNeverPrintTransferred(boolean neverPrint) {
        this.neverPrintTransferred = neverPrint;
    }

    @Column(name="never_print_transferred")
    public boolean isNeverPrintTransferred() {
        return this.neverPrintTransferred;
    }

    public void setNeverPrintDeleted(boolean neverPrint) {
        this.neverPrintDeleted = neverPrint;
    }

    @Column(name="never_print_deleted")
    public boolean isNeverPrintDeleted() {
        return this.neverPrintDeleted;
    }

    public void setWarnOnRemoveDiscountWhenTransfer(boolean warn) {
        this.warnOnRemoveDiscountWhenTransfer = warn;
    }

    @Column(name="warn_on_discount_removal_for_transfer")
    public boolean isWarnOnRemoveDiscountWhenTransfer() {
        return this.warnOnRemoveDiscountWhenTransfer;
    }

    public void setDeliveryFeeCountsToMinOrderAmount(boolean addDeliveryFeeToTotal) {
        this.deliveryFeeCountsToMinOrderAmount = addDeliveryFeeToTotal;
    }

    @Column(name="delivery_fee_counts_to_min_order_amount")
    public boolean isDeliveryFeeCountsToMinOrderAmount() {
        return this.deliveryFeeCountsToMinOrderAmount;
    }

    @JoinColumn(name="FK_inventory_price_adjustment")
    @ManyToOne
    public DeliveryPriceAdjustment getDeliveryFee() {
        return this.deliveryFee.get();
    }

    protected void setDeliveryFee(DeliveryPriceAdjustment adj) {
        this.deliveryFee.set(adj);
    }

    public void createMissingDeliveryFee() {
        if (this.deliveryFee.get() != null) {
            throw new IllegalStateException("Delivery fee already exists");
        }
        this.deliveryFee.set(PriceAdjustmentManager.getInstance().getDeliveryFee());
    }

    @Column(name="show_acc_id")
    public boolean isShowAccId() {
        return this.showAccId;
    }

    public void setShowAccId(boolean showIt) {
        this.showAccId = showIt;
    }

    @Deprecated
    public void setFinanceIntegration(FinanceExportStyle newFinanceIntegration) {
        this.financeIntegration = newFinanceIntegration;
    }

    @Column(name="finance_integration")
    @Enumerated(value=EnumType.STRING)
    @Deprecated
    public FinanceExportStyle getFinanceIntegration() {
        return this.financeIntegration;
    }

    public void setInvoicePaymentDetail(String invoicePaymentDetails) {
        this.invoicePaymentDetail = invoicePaymentDetails;
    }

    @Column(name="invoice_payment_detail")
    public String getInvoicePaymentDetail() {
        return this.invoicePaymentDetail;
    }

    @Column(name="dont_print_seat_all")
    public boolean isDontPrintSeatAllWhenItIsOnlySeatForAnItem() {
        return this.dontPrintSeatAllWhenItIsOnlySeatForAnItem;
    }

    public void setDontPrintSeatAllWhenItIsOnlySeatForAnItem(boolean dontPrint) {
        this.dontPrintSeatAllWhenItIsOnlySeatForAnItem = dontPrint;
    }

    @Column(name="combo_by_cost")
    public boolean isComboByCost() {
        return this.comboByCost;
    }

    public void setComboByCost(boolean value) {
        this.comboByCost = value;
    }

    @Transient
    public boolean isEnforceBiometricClockon() {
        return this.enforceBiometricClockon;
    }

    public void setEnforceBiometricClockon(boolean value) {
        this.enforceBiometricClockon = value;
    }

    @Transient
    public boolean isTwitterEnabled() {
        return !StringUtils.isEmpty(this.twitterUserName) && !StringUtils.isEmpty(this.twitterAccessToken) && !StringUtils.isEmpty(this.twitterAccessSecretToken);
    }

    public void setUseDeliveryZones(boolean useDeliveryZones) {
        this.useDeliveryZones = useDeliveryZones;
    }

    @Column(name="use_delivery_zones")
    public boolean isUseDeliveryZones() {
        return this.useDeliveryZones;
    }

    @Column(name="Pole1")
    public String getPoleDefaultLine1() {
        return this.poleDefaultLine1;
    }

    @Column(name="Pole2")
    public String getPoleDefaultLine2() {
        return this.poleDefaultLine2;
    }

    public void setPoleDefaultLine1(String poleDefaultLine1) {
        this.poleDefaultLine1 = poleDefaultLine1;
    }

    public void setPoleDefaultLine2(String poleDefaultLine2) {
        this.poleDefaultLine2 = poleDefaultLine2;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.DeterminePatrons")})
    @Column(name="determine_patrons")
    public DeterminePatrons getDeterminePatrons() {
        return this.determinePatrons;
    }

    public void setDeterminePatrons(DeterminePatrons value) {
        this.determinePatrons = value;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.printSummary.collecting.CollectionStrategy")})
    @Column(name="receipt_grouping")
    public CollectionStrategy getReceiptGrouping() {
        return this.receiptGrouping;
    }

    public void setReceiptGrouping(CollectionStrategy value) {
        this.receiptGrouping = value;
    }

    @Column(name="online_integration_id_strategy")
    @Enumerated(value=EnumType.STRING)
    public OnlineIntegrationIDStrategy getOnlineIntegrationIdStrategy() {
        return this.onlineIntegrationIdStrategy;
    }

    public void setOnlineIntegrationIdStrategy(OnlineIntegrationIDStrategy strategy) {
        this.onlineIntegrationIdStrategy = strategy;
    }

    @Column(name="profit_margin_perc")
    @Basic(optional=false)
    public double getProfitMarginPerc() {
        return this.profitMarginPerc;
    }

    public void setProfitMarginPerc(double percent) {
        this.profitMarginPerc = percent;
    }

    @Transient
    public Price getDeliveryFeePrice() {
        if (this.deliveryFee.get() == null) {
            this.deliveryFee.set(PriceAdjustmentManager.getInstance().getDeliveryFee());
        }
        return this.deliveryFee.get().getDollarAmount();
    }

    @Transient
    public void setDeliveryFeePrice(Price value) {
        if (this.deliveryFee.get() == null) {
            this.deliveryFee.set(PriceAdjustmentManager.getInstance().getDeliveryFee());
        }
        this.deliveryFee.get().setDollarAmount(value);
    }

    @Column(name="suggested_order_inc_purchases")
    public boolean isSuggestedOrderIncPurchases() {
        return this.suggestedOrderIncPurchases;
    }

    public void setSuggestedOrderIncPurchases(boolean value) {
        this.suggestedOrderIncPurchases = value;
    }

    @Column(name="cus_portal_pwd_text")
    public String getCusPortalPasswordMsg() {
        return this.cusPortalPasswordMsg;
    }

    public void setCusPortalPasswordMsg(String cusLoyPasswordMsg) {
        this.cusPortalPasswordMsg = cusLoyPasswordMsg;
    }

    @Column(name="default_quicksale_acc_type")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.sales.AccountType")})
    public AccountType getDefaultQuickSaleAccType() {
        return this.defaultQuickSaleAccType;
    }

    public void setDefaultQuickSaleAccType(AccountType defaultQuickSaleAccType) {
        if (!AccountType.quickSaleDineInType.equals(defaultQuickSaleAccType) && !AccountType.takeawayType.equals(defaultQuickSaleAccType)) {
            throw new IllegalArgumentException("Account Type can only be quickSaleDineInType or takeawayType.");
        }
        this.defaultQuickSaleAccType = defaultQuickSaleAccType;
    }

    @Column(name="prompt_name_bartab")
    @Basic(optional=false)
    public boolean isPromptNameBartab() {
        return this.promptNameBartab;
    }

    public void setPromptNameBartab(boolean value) {
        this.promptNameBartab = value;
    }

    @Column(name="course_printed")
    public boolean isCoursePrinted() {
        return this.coursePrinted;
    }

    public void setCoursePrinted(boolean value) {
        this.coursePrinted = value;
    }

    @Column(name="camera_view_ip")
    @Basic(optional=true)
    public String getCameraViewIp() {
        return this.cameraViewIp;
    }

    public void setCameraViewIp(String value) {
        this.cameraViewIp = value;
    }

    @Column(name="camera_view_port")
    @Basic(optional=true)
    public String getCameraViewPort() {
        return this.cameraViewPort;
    }

    public void setCameraViewPort(String value) {
        this.cameraViewPort = value;
    }

    @Column(name="print_wastage_dockets")
    public boolean isPrintWastageDockets() {
        return this.printWastageDockets;
    }

    public void setPrintWastageDockets(boolean value) {
        this.printWastageDockets = value;
    }

    @Column(name="print_cust_pwd_on_quick_add")
    public boolean isPrintCustPwdOnQuickAdd() {
        return this.printCustPwdOnQuickAdd;
    }

    public void setPrintCustPwdOnQuickAdd(boolean printCustPwdOnQuickAdd) {
        this.printCustPwdOnQuickAdd = printCustPwdOnQuickAdd;
    }

    @Column(name="show_sizes_on_combo_items")
    public boolean isShowSizesOnComboItems() {
        return this.showSizesOnComboItems;
    }

    public void setShowSizesOnComboItems(boolean showSizesOnComboItems) {
        this.showSizesOnComboItems = showSizesOnComboItems;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="seats_mode")
    public SeatsMode getSeatsMode() {
        return this.seatsMode;
    }

    public void setSeatsMode(SeatsMode seatsMode) {
        this.seatsMode = seatsMode;
    }

    @Column(name="updatemate_script_dir")
    public String getUpdateMateScriptDir() {
        return this.updateMateScriptDir;
    }

    public void setUpdateMateScriptDir(String updateMateScriptDir) {
        this.updateMateScriptDir = updateMateScriptDir;
    }

    @Column(name="stock_invoice_price_preference")
    @Enumerated(value=EnumType.STRING)
    public StockInvoicePricePreference getStockInvoicePricePreference() {
        return this.stockInvoicePricePreference;
    }

    public void setStockInvoicePricePreference(StockInvoicePricePreference stockInvoicePricePreference) {
        this.stockInvoicePricePreference = stockInvoicePricePreference;
    }

    @Column(name="twitter_active")
    public boolean isTwitterActive() {
        return this.twitterActive;
    }

    public void setTwitterActive(boolean twitterActive) {
        this.twitterActive = twitterActive;
    }

    @Column(name="future_order_docket_time")
    public int getFutureOrderDocketTime() {
        return this.futureOrderDocketTime;
    }

    public void setFutureOrderDocketTime(int newTime) {
        this.futureOrderDocketTime = newTime;
    }

    @Column(name="online_integration_print_docket_only")
    public boolean isOnlineIntegrationPrintDocketOnly() {
        return this.onlineIntegrationPrintDocketOnly;
    }

    public void setOnlineIntegrationPrintDocketOnly(boolean onlineIntegrationPrintDocketOnly) {
        this.onlineIntegrationPrintDocketOnly = onlineIntegrationPrintDocketOnly;
    }

    @Column(name="online_integration_full")
    public boolean isOnlineIntegrationFull() {
        return this.onlineIntegrationFull;
    }

    public void setOnlineIntegrationFull(boolean onlineIntegrationFull) {
        this.onlineIntegrationFull = onlineIntegrationFull;
    }

    @Column(name="lock_debtor_without_customer_set")
    public boolean isLockDebtorWithoutCustomerSet() {
        return this.lockDebtorWithoutCustomerSet;
    }

    public void setLockDebtorWithoutCustomerSet(boolean lockDebtorWithoutCustomerSet) {
        this.lockDebtorWithoutCustomerSet = lockDebtorWithoutCustomerSet;
    }

    @Column(name="customer_to_debtor_matching_strategy")
    @Enumerated(value=EnumType.STRING)
    public CustomerToDebtorMatchingStrategy getCustomerToDebtorMatchingStrategy() {
        return this.customerToDebtorMatchingStrategy;
    }

    public void setCustomerToDebtorMatchingStrategy(CustomerToDebtorMatchingStrategy customerToDebtorMatchingStrategy) {
        this.customerToDebtorMatchingStrategy = customerToDebtorMatchingStrategy;
    }

    @Column(name="device_failure_num_retry_attempts")
    public int getDeviceFailureNumRetryAttempts() {
        return this.deviceFailureNumRetryAttempts;
    }

    public void setDeviceFailureNumRetryAttempts(int deviceFailureNumRetryAttempts) {
        this.deviceFailureNumRetryAttempts = deviceFailureNumRetryAttempts;
    }

    @Column(name="device_failure_secs_between_attempts")
    public int getDeviceFailureSecsBetweenAttempts() {
        return this.deviceFailureSecsBetweenAttempts;
    }

    public void setDeviceFailureSecsBetweenAttempts(int deviceFailureSecsBetweenAttempts) {
        this.deviceFailureSecsBetweenAttempts = deviceFailureSecsBetweenAttempts;
    }

    @Column(name="single_course_printing")
    public boolean isSingleCoursePrinting() {
        return this.singleCoursePrinting;
    }

    public void setSingleCoursePrinting(boolean value) {
        this.singleCoursePrinting = value;
    }

    @Column(name="item_barcode_type")
    @Enumerated(value=EnumType.STRING)
    public ItemBarcodeType getItemBarcodeType() {
        return this.itemBarcodeType;
    }

    public void setItemBarcodeType(ItemBarcodeType value) {
        if (value != null) {
            this.itemBarcodeType = value;
        }
    }

    @Column(name="rec_system_total_includes_tips")
    public boolean isReconciliationSystemTotalIncludesTips() {
        return this.reconciliationSystemTotalIncludesTips;
    }

    public void setReconciliationSystemTotalIncludesTips(boolean includeTips) {
        this.reconciliationSystemTotalIncludesTips = includeTips;
    }

    @Column(name="previous_sales_local_terminal_only")
    public boolean isPreviousSalesLocalTerminalOnly() {
        return this.previousSalesLocalTerminalOnly;
    }

    public void setPreviousSalesLocalTerminalOnly(boolean localTerminalOnly) {
        this.previousSalesLocalTerminalOnly = localTerminalOnly;
    }

    @Column(name="enforce_base_prices_enabled")
    public boolean isEnforceBasePricesEnabled() {
        return this.enforceBasePricesEnabled;
    }

    public void setEnforceBasePricesEnabled(boolean enabled) {
        this.enforceBasePricesEnabled = enabled;
    }

    @Column(name="print_bar_tab_transfers")
    public boolean isPrintBarTabTransfers() {
        return this.printBarTabTransfers;
    }

    public void setPrintBarTabTransfers(boolean printBarTabTransfers) {
        this.printBarTabTransfers = printBarTabTransfers;
    }

    @Column(name="workflow_frequency")
    public Long getWorkflowFrequency() {
        return this.workflowFrequency;
    }

    public void setWorkflowFrequency(Long workflowFrequency) {
        this.workflowFrequency = workflowFrequency;
    }

    @Column(name="hide_no_items_summary")
    public boolean isHideNoItemsInSummary() {
        return this.hideNoItemsInSummary;
    }

    public void setHideNoItemsInSummary(boolean value) {
        this.hideNoItemsInSummary = value;
    }

    @Column(name="reassign_customer_comment")
    public boolean isReassignCustomerComment() {
        return this.reassignCustomerComment;
    }

    public void setReassignCustomerComment(boolean value) {
        this.reassignCustomerComment = value;
    }

    @Column(name="combos_as_discount")
    public boolean isCombosAsDiscount() {
        return this.combosAsDiscount;
    }

    public void setCombosAsDiscount(boolean value) {
        this.combosAsDiscount = value;
    }

    @Column(name="show_change")
    public boolean isShowChange() {
        return this.showChange;
    }

    public void setShowChange(boolean value) {
        this.showChange = value;
    }

    @Column(name="covers_and_seats_separated")
    public boolean isCoversAndSeatsSeparated() {
        return this.coversAndSeatsSeparated;
    }

    public void setCoversAndSeatsSeparated(boolean coversAndSeatsSeparated) {
        this.coversAndSeatsSeparated = coversAndSeatsSeparated;
    }

    @Column(name="customer_assignment_per_seat")
    public boolean isCustomerAssignmentPerSeat() {
        return this.customerAssignmentPerSeat;
    }

    public void setCustomerAssignmentPerSeat(boolean customerAssignmentPerSeat) {
        this.customerAssignmentPerSeat = customerAssignmentPerSeat;
    }

    @Column(name="ex_tax")
    public boolean isExTax() {
        return this.exTax;
    }

    public void setExTax(boolean exTax) {
        this.exTax = exTax;
    }

    @Column(name="stock_req_auto_print")
    public boolean isAutoPrintStockReq() {
        return this.autoPrintStockReq;
    }

    public void setAutoPrintStockReq(boolean value) {
        this.autoPrintStockReq = value;
    }

    @Column(name="print_zero_dollar_items")
    public boolean isPrintZeroDollarItems() {
        return this.printZeroDollarItems;
    }

    public void setPrintZeroDollarItems(boolean printZeroDollarItems) {
        this.printZeroDollarItems = printZeroDollarItems;
    }

    @Column(name="kts_unhold_to_end_of_queue")
    public boolean isKtsUnholdToEndOfQueue() {
        return this.ktsUnholdToEndOfQueue;
    }

    public void setKtsUnholdToEndOfQueue(boolean ktsUnholdToEndOfQueue) {
        this.ktsUnholdToEndOfQueue = ktsUnholdToEndOfQueue;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="error_tracking")
    public ErrorTrackingProvider getErrorTrackingProvider() {
        return this.errorTrackingProvider;
    }

    public void setErrorTrackingProvider(ErrorTrackingProvider provider) {
        if (provider != null) {
            this.errorTrackingProvider = provider;
        }
    }

    public void setOpenAccountInReconciliationStrategy(OpenAccountInReconciliationStrategy strategy) {
        this.openAccountInReconciliationStrategy = strategy;
    }

    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.misc.enums.OpenAccountInReconciliationStrategy")})
    @Column(name="open_account_in_reconciliation_strategy")
    public OpenAccountInReconciliationStrategy getOpenAccountInReconciliationStrategy() {
        return this.openAccountInReconciliationStrategy;
    }

    @Transient
    public TaxCode getBaseTaxCode() {
        return this.baseTaxCode.get();
    }

    public void setBaseTaxCode(TaxCode value) {
        if (value != null) {
            this.baseTaxCode.set(value);
        }
    }

    @Transient
    public String getBaseTaxLabel() {
        return this.baseTaxCode.get().getCode();
    }

    @Transient
    public double getBaseTaxRate() {
        return this.baseTaxCode.get().getRate();
    }

    @Transient
    public double getBaseTaxFactor() {
        return 1.0 / (1.0 + this.baseTaxCode.get().getRate());
    }

    @Column(name="stock_price_warn")
    public double getStockPriceWarn() {
        return this.stockPriceWarn;
    }

    public void setStockPriceWarn(double value) {
        this.stockPriceWarn = value;
    }

    @Column(name="print_big_chinese")
    public boolean getPrintBigChinese() {
        return this.printBigChinese;
    }

    public void setPrintBigChinese(boolean value) {
        this.printBigChinese = value;
    }

    @Column(name="print_queue_crawler")
    public boolean getPrintQueueCrawler() {
        return this.printQueueCrawler;
    }

    public void setPrintQueueCrawler(boolean printQueueCrawler) {
        this.printQueueCrawler = printQueueCrawler;
    }

    @Column(name="multi_processor_printing")
    public int getMultiProcessorPrinting() {
        return this.multiProcessorPrinting;
    }

    public void setMultiProcessorPrinting(int processors) {
        this.multiProcessorPrinting = processors;
    }

    @Column(name="print_port_optimisation")
    public boolean getPrintPortOptimisation() {
        return this.printPortOptimisation;
    }

    public void setPrintPortOptimisation(boolean printPortOptimisation) {
        this.printPortOptimisation = printPortOptimisation;
    }

    @Column(name="split_chinese")
    public boolean getSplitChinese() {
        return this.splitChinese;
    }

    public void setSplitChinese(boolean split) {
        this.splitChinese = split;
    }

    @Column(name="ignore_split_chinese")
    public String getIgnoreSplitChinese() {
        return this.ignoreSplitChinese;
    }

    public void setIgnoreSplitChinese(String ignoreSplit) {
        this.ignoreSplitChinese = ignoreSplit;
    }

    @Column(name="on_thread_integration")
    public boolean getOnThreadIntegration() {
        return this.onThreadIntegration;
    }

    public void setOnThreadIntegration(boolean onThreadIntegration) {
        this.onThreadIntegration = onThreadIntegration;
    }

    @Column(name="includes_middle_checksum")
    public boolean isIncludeMiddleChecksum() {
        return this.includeMiddleChecksum;
    }

    public void setIncludeMiddleChecksum(boolean includesMiddleChecksum) {
        this.includeMiddleChecksum = includesMiddleChecksum;
    }

    @Transient
    public boolean isMessageServerEnabled() {
        return this.getMessageServerType() != MessageServerType.NONE;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="language_support")
    public LanguageSupportType getLanguageSupport() {
        return this.languageSupport;
    }

    public void setLanguageSupport(LanguageSupportType languageSupport) {
        this.languageSupport = languageSupport;
    }

    @Column(name="email_sender")
    public String getEmailSender() {
        return this.emailSender;
    }

    public void setEmailSender(String sender) {
        this.emailSender = sender;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="driver_assignment_settlement")
    public DriverAssignmentSettlementType getDriverAssignmentSettlement() {
        return this.driverAssignmentSettlement;
    }

    public void setDriverAssignmentSettlement(DriverAssignmentSettlementType driverAssignmentSettlement) {
        this.driverAssignmentSettlement = driverAssignmentSettlement;
    }

    public boolean canAssignDriver(DriverAssignmentSettlementType t) {
        return this.driverAssignmentSettlement.equals((Object)t) || this.driverAssignmentSettlement.equals((Object)DriverAssignmentSettlementType.BOTH) && !t.equals((Object)DriverAssignmentSettlementType.NONE);
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="reservation_integration")
    public ReservationIntegrationType getReservationIntegration() {
        return this.reservationIntegration;
    }

    public void setReservationIntegration(ReservationIntegrationType type) {
        this.reservationIntegration = type;
    }

    @Column(name="db_check_schedule")
    public String getDbCheckSchedule() {
        return this.dbCheckSchedule;
    }

    public void setDbCheckSchedule(String value) {
        this.dbCheckSchedule = value;
    }

    @Column(name="webservice_conn_timeout")
    public int getWebserviceConnTimeout() {
        return this.webserviceConnTimeout;
    }

    public void setWebserviceConnTimeout(int value) {
        this.webserviceConnTimeout = value;
    }

    @Column(name="webservice_read_timeout")
    public int getWebserviceReadTimeout() {
        return this.webserviceReadTimeout;
    }

    public void setWebserviceReadTimeout(int value) {
        this.webserviceReadTimeout = value;
    }

    @Enumerated(value=EnumType.STRING)
    @Column(name="reservation_warn")
    public ReservationWarnType getReservationWarn() {
        return this.reservationWarn;
    }

    public void setReservationWarn(ReservationWarnType reservationWarn) {
        this.reservationWarn = reservationWarn;
    }

    @Column(name="rms_cash_account_id")
    public Long getRmsCashAccountId() {
        return this.rmsCashAccountId;
    }

    public void setRmsCashAccountId(Long rmsCashAccountId) {
        this.rmsCashAccountId = rmsCashAccountId;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property TABLE_POSITIONS_REVERT;
        public PropertiedObject.Property CHANGE_DAY_TIME;
        public PropertiedObject.Property SHOW_PAYMENT_STATUS;
        public PropertiedObject.Property SHOW_SECTION_ON_DOCKETS;
        public PropertiedObject.Property LOYALTY_ENABLED;
        public PropertiedObject.Property LOYALTY_POINTS_TYPE;
        public PropertiedObject.Property DEFAULT_PATRONS_PER_TABLE;
        public PropertiedObject.Property CONFIRMATIONS_ENABLED;
        public PropertiedObject.Property RESERVATIONS_ENABLED;
        public PropertiedObject.Property SPLIT_BILL_ENABLED;
        public PropertiedObject.Property CCTV_ENABLED;
        public PropertiedObject.Property BAR_STOCK_ENABLED;
        public PropertiedObject.Property PROPERTY_INTEGRATION;
        public PropertiedObject.Property RESERVATION_INTEGRATION;
        public PropertiedObject.Property RESERVATION_WARN;
        public PropertiedObject.Property PREP_DOCKET_LOCATION;
        public PropertiedObject.Property RECEIPT_DOCKET_LOCATION;
        public PropertiedObject.Property TAKINGS_DOCKET_LOCATION;
        public PropertiedObject.Property SALES_DOCKET_LOCATION;
        public PropertiedObject.Property RESERVATIONS_DOCKET_LOCATION;
        public PropertiedObject.Property SKIMS_DOCKET_LOCATION;
        public PropertiedObject.Property DEBTOR_DOCKET_LOCATION;
        public PropertiedObject.Property<MessageServerType> MESSAGE_SERVER_TYPE;
        public PropertiedObject.Property MESSAGE_SERVER_POLL_TIME;
        public PropertiedObject.Property MESSAGE_UPDATER_POLL_TIME;
        public PropertiedObject.Property TRAINING_MODE_ENABLED;
        public PropertiedObject.Property ADVANCED_ADD_REMOVE_ENABLED;
        public PropertiedObject.Property PORTIONED_MODS_ENABLED;
        public PropertiedObject.Property REPLICATION_ENABLED;
        public PropertiedObject.Property MANUAL_CHANGE_OF_DAY;
        public PropertiedObject.Property BLIND_SKIM_ENABLED;
        public PropertiedObject.Property LIMIT_OF_ORDER_NUMBER;
        public PropertiedObject.Property AUTO_FILL_LAST_COMMENT;
        public PropertiedObject.Property AUTO_FILL_LAST_ITEMS_PHONE;
        public PropertiedObject.Property AUTO_FILL_LAST_ITEMS_TAKEAWAY;
        public PropertiedObject.Property AUTO_FILL_LAST_ITEMS_QUICKSALE;
        public PropertiedObject.Property PRINTER_REDIRECTION;
        public PropertiedObject.Property PRINTER_TIMEOUT;
        public PropertiedObject.Property PRICE_BY_DEAREST;
        public PropertiedObject.Property PRICE_OVERRIDE_MODS;
        public PropertiedObject.Property<Price> ACCOUNT_CREDIT_LIMIT;
        public PropertiedObject.Property<Price> TAB_CREDIT_LIMIT;
        public PropertiedObject.Property<Price> ROOM_CREDIT_LIMIT;
        public PropertiedObject.Property TIME_SYNC;
        public PropertiedObject.Property SINGLE_PAYMENT_MODE;
        public PropertiedObject.Property AUTO_TAB_SELECTION;
        public PropertiedObject.Property RETRO_CUST_PRICE_UPDATES;
        public PropertiedObject.Property LOYALTY_REDEEM_RATIO;
        public PropertiedObject.Property LOYALTY_ADD_RATIO;
        public PropertiedObject.Property AUTO_CLOCK_ON;
        public PropertiedObject.Property FADE_BACKGROUND;
        public PropertiedObject.Property FORM_AUTO_COMBO;
        public PropertiedObject.Property MAX_NUMB_FIGURES;
        public PropertiedObject.Property SUPPORT_MESSAGE1;
        public PropertiedObject.Property SUPPORT_MESSAGE2;
        public PropertiedObject.Property MESSAGE_OF_THE_DAY;
        public PropertiedObject.Property REMOTE_MONITOR_URL;
        public PropertiedObject.Property TAKINGS_EX_DISCOUNTS;
        public PropertiedObject.Property DEFAULT_DOCKET_SORTING;
        public PropertiedObject.Property SHOW_SOH_IN_FRONT_END;
        public PropertiedObject.Property SHOW_STOCK_COUNT_IN_FRONT_END;
        public PropertiedObject.Property OVERSELL_MODE;
        public PropertiedObject.Property STOCK_COUNTDOWN_OVERSELL_MODE;
        public PropertiedObject.Property STOCK_COUNTDOWN_ENABLED;
        public PropertiedObject.Property ORDER_NUMBER_PREFIX;
        public PropertiedObject.Property NEXT_ORDER_NUMBER;
        public PropertiedObject.Property STOCK_CONTROL_ENABLED;
        public PropertiedObject.Property AUTO_GENERATE_PLU;
        public PropertiedObject.Property LOCK_STOCKLESS_ITEMS;
        public PropertiedObject.Property TABLE_IMAGES_PATH;
        public PropertiedObject.Property LIQUORFILE_ENABLED;
        public PropertiedObject.Property SHOW_TRANSFER_SUMMARY;
        public PropertiedObject.Property FRACTIONAL_QTYS;
        public PropertiedObject.Property TWITTER_USERNAME;
        public PropertiedObject.Property TWITTER_ACCESS_TOKEN;
        public PropertiedObject.Property TWITTER_ACCESS_SECRET_TOKEN;
        public PropertiedObject.Property HAPPY_CUSTOMER_ENABLED;
        public PropertiedObject.Property SUPPORT_PHONE;
        public PropertiedObject.Property TRAINING_PHONE;
        public PropertiedObject.Property NEVER_PRINT_TRANSFERRED;
        public PropertiedObject.Property NEVER_PRINT_DELETED;
        public PropertiedObject.Property WARN_ON_REMOVE_DISCOUNT_WHEN_TRANSFER;
        public PropertiedObject.Property SHOW_ACC_ID;
        public PropertiedObject.Property<DeliveryPriceAdjustment> DELIVERY_FEE;
        public PropertiedObject.Property DELIVERY_FEE_COUNTS_TO_MIN_ORDER_AMOUNT;
        public PropertiedObject.Property<FinanceExportStyle> FINANCE_INTEGRATION;
        public PropertiedObject.Property<String> INVOICE_PAYMENT_DETAIL;
        public PropertiedObject.Property COMBO_BY_COST;
        public PropertiedObject.Property ENFORCE_BIOMETRIC_CLOCKON;
        public PropertiedObject.Property DONT_PRINT_SEAT_ALL_WHEN_IT_IS_ONLY_SEAT_FOR_AN_ITEM;
        public PropertiedObject.Property<OnlineIntegrationMode> ONLINE_INTEGRATION_MODE;
        public PropertiedObject.Property USE_DELIVERY_ZONES;
        public PropertiedObject.Property POLE_DEFAULT_LINE1;
        public PropertiedObject.Property POLE_DEFAULT_LINE2;
        public PropertiedObject.Property DETERMINE_PATRONS;
        public PropertiedObject.Property RECEIPT_GROUPING;
        public PropertiedObject.Property<OnlineIntegrationIDStrategy> ONLINE_INTEGRATION_ID_STRATEGY;
        public PropertiedObject.Property PROFIT_MARGIN_PERC;
        public PersistentObject.DerivedProperty<Price> DELIVERY_FEE_PRICE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)SystemProperty.class), "deliveryFeePrice");
        public PropertiedObject.Property SUGGESTED_ORDER_INC_PURCHASES;
        public PropertiedObject.Property<String> CUS_PORTAL_PASSWORD_MSG;
        public PropertiedObject.Property<AccountType> DEFAULT_QUICKSALE_ACC_TYPE;
        public PropertiedObject.Property PROMPT_NAME_BARTAB;
        public PropertiedObject.Property COURSE_PRINTED;
        public PropertiedObject.Property<String> CAMERA_VIEW_IP;
        public PropertiedObject.Property<String> CAMERA_VIEW_PORT;
        public PropertiedObject.Property PRINT_WASTAGE_DOCKETS;
        public PropertiedObject.Property PRINT_CUST_PWD_ON_QUICK_ADD;
        public PropertiedObject.Property<String> UPDATEMATE_SCRIPT_DIR;
        public PropertiedObject.Property<StockInvoicePricePreference> STOCK_INVOICE_PRICE_PREFERENCE;
        public PropertiedObject.Property SHOW_SIZES_ON_COMBO_ITEMS;
        public PropertiedObject.Property<SeatsMode> SEATS_MODE;
        public PropertiedObject.Property TWITTER_ACTIVE;
        public PropertiedObject.Property FUTURE_ORDER_DOCKET_TIME;
        public PropertiedObject.Property<Boolean> ONLINE_INTEGRATION_PRINT_DOCKET_ONLY;
        public PropertiedObject.Property<Boolean> ONLINE_INTEGRATION_FULL;
        public PropertiedObject.Property<Boolean> LOCK_DEBTOR_WITHOUT_CUSTOMER_SET;
        public PropertiedObject.Property<CustomerToDebtorMatchingStrategy> CUSTOMER_TO_DEBTOR_MATCHING_STRATEGY;
        public PropertiedObject.Property<Integer> DEVICE_FAILURE_NUM_RETRY_ATTEMPTS;
        public PropertiedObject.Property<Integer> DEVICE_FAILURE_SECS_BETWEEN_ATTEMPTS;
        public PropertiedObject.Property SINGLE_COURSE_PRINTING;
        public PropertiedObject.Property<ItemBarcodeType> ITEM_BARCODE_TYPE;
        public PropertiedObject.Property<Boolean> RECONCILIATION_SYSTEM_TOTAL_INCLUDES_TIPS;
        public PropertiedObject.Property<Boolean> PREVIOUS_SALES_LOCAL_TERMINAL_ONLY;
        public PropertiedObject.Property<Boolean> ENFORCE_BASE_PRICES_ENABLED;
        public PropertiedObject.Property<Boolean> PRINT_BAR_TAB_TRANSFERS;
        public PropertiedObject.Property<Long> WORKFLOW_FREQUENCY;
        public PropertiedObject.Property HIDE_NO_ITEMS_IN_SUMMARY;
        public PropertiedObject.Property<PhoneOrderForceContactStrategy> PHONE_ORDER_FORCE_STRATEGY;
        public PropertiedObject.Property REASSIGN_CUSTOMER_COMMENT;
        public PropertiedObject.Property<Boolean> BLOCK_DUPLICATE_ONLINE_ORDERS;
        public PropertiedObject.Property<Boolean> COMBOS_AS_DISCOUNT;
        public PropertiedObject.Property<Boolean> SHOW_CHANGE;
        public PropertiedObject.Property<Boolean> ONLINE_PHONE_SET_TIME_DUE;
        public PropertiedObject.Property<Boolean> LABOUR_FIGURES_CLOCKED_OFF_ONLY;
        public PropertiedObject.Property<Boolean> COVERS_AND_SEATS_SEPARATED;
        public PropertiedObject.Property<Boolean> CUSTOMER_ASSIGNMENT_PER_SEAT;
        public PropertiedObject.Property<OpenAccountInReconciliationStrategy> OPEN_ACCOUNT_IN_RECONCILIATION_STRATEGY;
        public PropertiedObject.Property<Boolean> EX_TAX;
        public PropertiedObject.Property<Boolean> PRINT_ZERO_DOLLAR_ITEMS;
        public PropertiedObject.Property<Boolean> KTS_UNHOLD_TO_END_OF_QUEUE;
        public PropertiedObject.Property<ErrorTrackingProvider> ERROR_TRACKING_PROVIDER;
        public PropertiedObject.Property<TaxCode> BASE_TAX_CODE;
        public PropertiedObject.Property<Double> STOCK_PRICE_WARN;
        public PropertiedObject.Property<Boolean> PRINT_BIG_CHINESE;
        public PropertiedObject.Property<Boolean> PRINT_QUEUE_CRAWLER;
        public PropertiedObject.Property<Integer> MULTI_PROCESSOR_PRINTING;
        public PropertiedObject.Property<Boolean> PRINT_PORT_OPTIMISATION;
        public PropertiedObject.Property<Boolean> SPLIT_CHINESE;
        public PropertiedObject.Property<String> IGNORE_SPLIT_CHINESE;
        public PropertiedObject.Property<Boolean> ON_THREAD_INTEGRATION;
        public PropertiedObject.Property INCLUDE_MIDDLE_CHECKSUM;
        public PropertiedObject.Property AUTO_PRINT_STOCK_REQ;
        public PropertiedObject.Property<LanguageSupportType> LANGUAGE_SUPPORT;
        public PropertiedObject.Property<String> EMAIL_SENDER;
        public PropertiedObject.Property<DriverAssignmentSettlementType> DRIVER_ASSIGNMENT_SETTLEMENT;
        public PropertiedObject.Property<String> DB_CHECK_SCHEDULE;
        public PropertiedObject.Property WEBSERVICE_CONN_TIMEOUT;
        public PropertiedObject.Property WEBSERVICE_READ_TIMEOUT;
        public PropertiedObject.Property<Long> RMS_CASH_ACCOUNT_ID;
    }
}

