/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.units.SalesQuantity;
import au.com.ordermate.util.DateTimeUtils;
import au.com.ordermate.util.Price;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.EventContext;
import ordermate.database.Lockable;
import ordermate.database.Payable;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.finance.CreditLimited;
import ordermate.database.finance.Skim;
import ordermate.database.finance.SkimTransaction;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.giftvoucher.GiftVoucherTransaction;
import ordermate.database.finance.priceadjustment.PriceAdjustmentDirection;
import ordermate.database.finance.priceadjustment.SalesPriceAdjustment;
import ordermate.database.finance.priceadjustment.inventory.TradingDayAdjustment;
import ordermate.database.finance.transactions.DebtorAdjustmentTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.finance.transactions.FinanceTransactionContext;
import ordermate.database.hardware.Terminal;
import ordermate.database.hardware.physical.CashDrawer;
import ordermate.database.inventory.InventoryItem;
import ordermate.database.inventory.PriceLevel;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.AbstractEventLog;
import ordermate.database.misc.AsynchronousEventLogWriter;
import ordermate.database.misc.EventLogWriterI;
import ordermate.database.misc.OrderItemLogType;
import ordermate.database.sales.Account;
import ordermate.database.sales.Customer;
import ordermate.database.sales.Delivery;
import ordermate.database.sales.ItemGroup;
import ordermate.database.sales.PhoneAccount;
import ordermate.database.sales.SalesItem;
import ordermate.database.sales.SalesLineItem;
import ordermate.database.sales.TableAccount;
import ordermate.database.sales.TakeawayAccount;
import ordermate.database.sales.WastageAccount;
import ordermate.database.sales.coupon.SalesCoupon;
import ordermate.database.sales.reservation.Reservation;
import ordermate.database.tables.LogicalTable;
import ordermate.database.tables.LogicalTableState;
import ordermate.database.tables.TableGroup;
import ordermate.database.users.User;
import ordermate.integration.jaxb.xero.Invoice;

public final class TerminalEventLog
extends AbstractEventLog {
    private static final String EDIT_PRICE = "Edit Price";
    private static final String DISCOUNT = "Discount";
    private static final String ADJUSTMENT = "Adjustment";
    private static final String CUSTOM_DISCOUNT_REASON = "Discount Reason";
    private static final String DEBTOR_TRANSFER = "Debtor transfer";
    private static final String DEBTOR_REFUND = "Debtor refund";
    private static final String DEBTOR_SALE = "Debtor sale";
    private static final String DEBTOR_PAYMENT = "Debtor payment";
    private static final String DEBTOR_ADJUSTMENT = "Debtor adjustment";
    private static final String NO_SALE = "No Sale";
    private static final String PAY_OFF = "Pay Off";
    private static final String PAYMENT_DELETED = "Payment Deleted";
    private static final String PAYMENT_CANCELED = "Payment Canceled";
    private static final String PAYMENT_REFUNDED = "Payment Refunded";
    private static final String SETTLE_DELIVERY = "Settle Delivery";
    private static final String TABLE_SETUP = "Table Setup";
    private static final String SURCHARGE = "Surcharge";
    private static final String OPEN_PRICE = "Open Price";
    private static final String ITEMS_ORDERED = "Order";
    private static final String ITEMS_DELETED = "Deletion";
    private static final String ITEMS_CANCELED = "Cancelation";
    private static final String ITEMS_REFUNDED = "Refund";
    private static final String ITEMS_MOVED = "Item Move";
    private static final String TAKINGS_VIEW = "View Takings";
    private static final String TAKINGS_PRINT = "Print Takings";
    private static final String PRINT_BILL = "Print Bill";
    private static final String PRINT_STATEMENT = "Print Statement";
    private static final String USER_LOGIN = "User Login";
    private static final String USER_LOGOUT = "User Logout";
    private static final String BAR_TAB = "Bar Tab";
    private static final String CREDIT_LIMIT = "Credit Limit";
    private static final String CLOSED_ACCOUNT = "Closed Account";
    private static final String LOYALTY_POINTS = "Loyalty Points";
    private static final String TERMINAL_STARTUP = "Terminal Startup";
    private static final String CASHDRAWER_SKIM = "CashDrawer Skim";
    private static final String LOCK_TABLE = "Locked Table";
    private static final String UNLOCK_TABLE = "Unlock Table";
    private static final String UNLOCK_ACCOUNT = "Unlock Account";
    private static final String UNLOCK_TABLE_GROUP = "Unlock Table Group";
    private static final String UNLOCK_DEBTOR = "Unlock debtor account";
    private static final String UNLOCK_DELIVERY = "Unlock delivery";
    public static final String TRADING_DAY_DISCREPANCY = "Trading day discrepancy";
    private static final String DEVICE_FAILURE = "Device failure";
    private static final String SAFE_REBOOT = "Safe Restart";
    private static final String EFTPOS_EVENT = "EFTPOS event";
    private static final String SHIFT_CHANGE = "Shift Change";
    private static final String ACCOUNTS_CUSTOMER_SET = "Account's Customer Set";
    private static final String PIN_DUPLICATION = "Duplicate Pin Rejected";
    private static final String INVALID_LOGIN = "Invalid Login";
    private static final String MINIMUM_DELIVERY_OVERRIDE = "Order below minimum delivery allowed";
    private static final String OFFLINE_EFTPOS = "Offline Eftpos";
    private static final String OUT_OF_AREA_WARNING = "Out of area delivery allowed";
    private static final String CLOCK_ON_OFF = "Clock On/Off";
    private static final String ASSIGN_DELIVERY = "Assign Delivery";
    public static final String SWIPE_OVER = "Swipe Over";
    private static final String TABLE_STATE = "Table State";
    private static final String COUPONS = "Coupons";
    private static final String TXN_TRANSFER = "Transaction Transfer";
    private static final String STOCK_COUNT_CHANGED = "Stock Count Changed";
    private static final String VOUCHER_TXN_REQUEST = "Voucher Request";
    private static final String VOUCHER_TXN_RESPONSE = "Voucher Response";
    private static final String WASTAGE_LOG = "Wastage";
    private static final String RESERVATION_BOOKED = "Reservation Booked";
    private static final String RESERVATION_EDITED = "Reservation Edited";
    private static final String RESERVATION_ARRIVED = "Reservation Arrived";
    private static final String RESERVATION_DELETED = "Reservation Deleted";
    private static final String RESERVATION_CONFIRMED = "Reservation Confirmed";
    private static final String RESERVATION_UNSEATED = "Reservation Unseated";
    private static final List<String> allEvents = new LinkedList<String>();
    private static TerminalEventLog instance;
    private static volatile boolean instanceInitialized;

    private TerminalEventLog(EventLogWriterI writer) {
        super(writer, "WaiterMate Events");
        allEvents.add(BAR_TAB);
        allEvents.add(CASHDRAWER_SKIM);
        allEvents.add(CLOSED_ACCOUNT);
        allEvents.add(CREDIT_LIMIT);
        allEvents.add(DEVICE_FAILURE);
        allEvents.add(DISCOUNT);
        allEvents.add(ADJUSTMENT);
        allEvents.add(CUSTOM_DISCOUNT_REASON);
        allEvents.add(EDIT_PRICE);
        allEvents.add(ITEMS_CANCELED);
        allEvents.add(ITEMS_DELETED);
        allEvents.add(ITEMS_MOVED);
        allEvents.add(ITEMS_ORDERED);
        allEvents.add(LOCK_TABLE);
        allEvents.add(LOYALTY_POINTS);
        allEvents.add(NO_SALE);
        allEvents.add(OPEN_PRICE);
        allEvents.add(PAY_OFF);
        allEvents.add(PAYMENT_CANCELED);
        allEvents.add(PAYMENT_DELETED);
        allEvents.add(PRINT_BILL);
        allEvents.add(PRINT_STATEMENT);
        allEvents.add(SETTLE_DELIVERY);
        allEvents.add(SURCHARGE);
        allEvents.add(TABLE_SETUP);
        allEvents.add(TAKINGS_PRINT);
        allEvents.add(TAKINGS_VIEW);
        allEvents.add(TERMINAL_STARTUP);
        allEvents.add(TRADING_DAY_DISCREPANCY);
        allEvents.add(UNLOCK_ACCOUNT);
        allEvents.add(UNLOCK_DEBTOR);
        allEvents.add(UNLOCK_TABLE);
        allEvents.add(UNLOCK_TABLE_GROUP);
        allEvents.add(USER_LOGIN);
        allEvents.add(USER_LOGOUT);
        allEvents.add(SAFE_REBOOT);
        allEvents.add(EFTPOS_EVENT);
        allEvents.add(ACCOUNTS_CUSTOMER_SET);
        allEvents.add(SHIFT_CHANGE);
        allEvents.add(PIN_DUPLICATION);
        allEvents.add(INVALID_LOGIN);
        allEvents.add(MINIMUM_DELIVERY_OVERRIDE);
        allEvents.add(CLOCK_ON_OFF);
        allEvents.add(ASSIGN_DELIVERY);
        allEvents.add(DEBTOR_TRANSFER);
        allEvents.add(DEBTOR_REFUND);
        allEvents.add(DEBTOR_SALE);
        allEvents.add(DEBTOR_PAYMENT);
        allEvents.add(ITEMS_REFUNDED);
        allEvents.add(UNLOCK_DELIVERY);
        allEvents.add(OFFLINE_EFTPOS);
        allEvents.add(OUT_OF_AREA_WARNING);
        allEvents.add(TABLE_STATE);
        allEvents.add(RESERVATION_BOOKED);
        allEvents.add(COUPONS);
        allEvents.add(TXN_TRANSFER);
        allEvents.add(RESERVATION_EDITED);
        allEvents.add(RESERVATION_ARRIVED);
        allEvents.add(RESERVATION_DELETED);
        allEvents.add(RESERVATION_CONFIRMED);
        allEvents.add(WASTAGE_LOG);
    }

    private static String returnAccountIdString(ItemGroup account) {
        return account.getID() != null ? account.getID().toString() + " @ " : "";
    }

    public static synchronized void initInstance(EventLogWriterI writer) {
        if (!instanceInitialized) {
            TerminalEventLog log;
            instance = log = new TerminalEventLog(writer);
            instanceInitialized = true;
        }
    }

    public static TerminalEventLog getInst() {
        if (instance == null) {
            TerminalEventLog.initInstance(new AsynchronousEventLogWriter());
        }
        return instance;
    }

    @Override
    public List<String> getAllEvents() {
        return Collections.unmodifiableList(allEvents);
    }

    private static String getAccountDesc(ItemGroup account) {
        String accId = "";
        String label = "";
        if (account != null) {
            if (account.getID() != null) {
                accId = String.valueOf(account.getID());
            }
            if (account.getLabel() != null) {
                label = account.getLabel();
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Account:").append(accId).append(" ").append(label).append(" - ");
        return sb.toString();
    }

    public static void logAddAdjustment(EventContext context, SalesPriceAdjustment adjustment, ItemGroup account) {
        TerminalEventLog.logAddAdjustment(context, adjustment, "account : " + TerminalEventLog.returnAccountIdString(account) + account.getLabel(), TerminalEventLog.getAccountDesc(account));
    }

    public static void logAddAdjustment(EventContext context, SalesPriceAdjustment discount, SalesLineItem item) {
        TerminalEventLog.logAddAdjustment(context, discount, "item " + item.getLabel() + ", now " + item.getPrice(), TerminalEventLog.getAccountDesc(item.getAccount()));
    }

    public static void logRemoveAdjustment(EventContext context, SalesPriceAdjustment adjustment, SalesLineItem item) {
        TerminalEventLog.logRemoveAdjustment(context, adjustment, "item " + item.getLabel() + ", now " + item.getPrice().add(adjustment.getSavedValue()), TerminalEventLog.getAccountDesc(item.getAccount()));
    }

    public static void logRemoveAdjustment(EventContext context, SalesPriceAdjustment adjustment, ItemGroup account) {
        TerminalEventLog.logRemoveAdjustment(context, adjustment, "account : " + TerminalEventLog.returnAccountIdString(account) + account.getLabel(), TerminalEventLog.getAccountDesc(account));
    }

    private static void logAddAdjustment(EventContext context, SalesPriceAdjustment adjustment, String target, String accId) {
        PriceAdjustmentDirection direction = adjustment.getInventoryPriceAdjustment().getDirection();
        StringBuilder buffer = new StringBuilder(accId + " Adding ");
        buffer.append(direction).append(" of ").append(adjustment.getLabel()).append(" " + adjustment.getDirection() + " value " + adjustment.getSavedValue()).append(" to ").append(target).append(".");
        TerminalEventLog.getInst().logActivity(context, ADJUSTMENT, buffer.toString());
    }

    private static void logRemoveAdjustment(EventContext context, SalesPriceAdjustment adjustment, String target, String accId) {
        PriceAdjustmentDirection direction = adjustment.getInventoryPriceAdjustment().getDirection();
        String msg = accId + " Removing " + direction.toString() + " :" + adjustment + " from " + target + ".";
        TerminalEventLog.getInst().logActivity(context, ADJUSTMENT, msg);
    }

    public static void logCustomDiscountReason(EventContext context, String valueRepresentation, String reason) {
        if (reason != null) {
            StringBuilder SB = new StringBuilder("Reason for custom discount of ");
            SB.append(valueRepresentation);
            SB.append(":");
            SB.append(reason);
            TerminalEventLog.getInst().logActivity(context, CUSTOM_DISCOUNT_REASON, SB.toString());
        }
    }

    public static void logPriceChange(EventContext context, SalesItem item, Price newPrice, boolean permanent) {
        String permPrefix = "E";
        if (permanent) {
            permPrefix = "Permanently e";
        }
        String msg = TerminalEventLog.getAccountDesc(item.getAccount()) + " " + permPrefix + "dited price of " + item.getLabel() + " from " + item.getPricePerItem() + " to " + newPrice + ".";
        TerminalEventLog.getInst().logActivity(context, EDIT_PRICE, msg);
    }

    public static void logAutoFillPrice(User user, PriceLevel priceLevel) {
        String unit;
        double value;
        if (priceLevel.getDollarToApply() == null || priceLevel.getDollarToApply().isZero()) {
            value = priceLevel.getPercentageToApply();
            unit = "%";
        } else {
            value = priceLevel.getDollarToApply().doubleValue();
            unit = " dollars";
        }
        String msg = "Auto fill out price with " + value + " " + unit + " from " + priceLevel.getReferencePriceLevel().getLabel() + " to " + priceLevel.getLabel() + "\nusing the rule " + (Object)((Object)priceLevel.getRuleToApply());
        TerminalEventLog.getInst().logActivity(user, EDIT_PRICE, msg);
    }

    public static void logForcePriceLevel(EventContext context, int numItems, String priceLevel, boolean isActive, Price priceChange, String accountName, ItemGroup itemGroup) {
        if (numItems == 0) {
            return;
        }
        String msg = TerminalEventLog.getAccountDesc(itemGroup) + "Forced " + numItems + " items from account '" + accountName + "' onto ";
        if (!isActive) {
            msg = msg + " INACTIVE ";
        }
        msg = msg + " price level '" + priceLevel + "'.  Price change: " + priceChange;
        TerminalEventLog.getInst().logActivity(context, EDIT_PRICE, msg);
    }

    public static void logForceCheapestPriceLevel(EventContext context, int numItems, Price priceChange, String accountName, ItemGroup itemGroup) {
        if (numItems == 0) {
            return;
        }
        String msg = TerminalEventLog.getAccountDesc(itemGroup) + "Forced " + numItems + " items from account '" + accountName + "' onto cheapest price level.  Price change: " + priceChange;
        TerminalEventLog.getInst().logActivity(context, EDIT_PRICE, msg);
    }

    public static void logUseHighestActivePriceLevel(EventContext context, int numItems, Price priceChange, String reason, String accountName, ItemGroup itemGroup) {
        if (numItems == 0) {
            return;
        }
        String msg = TerminalEventLog.getAccountDesc(itemGroup) + " Forced " + numItems + " items from account '" + accountName + "' onto highest active price level.  Price change: " + priceChange + ". Reason: '" + reason + "'";
        TerminalEventLog.getInst().logActivity(context, EDIT_PRICE, msg);
    }

    public static void logOpenPrice(EventContext context, SalesLineItem item, Price openPrice) {
        String msg = TerminalEventLog.getAccountDesc(item.getAccount()) + "Set open price for " + item.getLabel() + " to " + openPrice + ".";
        TerminalEventLog.getInst().logActivity(context, OPEN_PRICE, msg);
    }

    public static void logTableSetup(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), TABLE_SETUP, "Table setup called from WaiterMate Admin.");
    }

    public static void logNoSale(User user, Terminal terminal, CashDrawer cashdrawer, String furtherInfo) {
        StringBuilder SB = new StringBuilder("Cashdrawer ").append(cashdrawer.getLabel()).append(" opened for no sale");
        if (furtherInfo != null) {
            SB.append(furtherInfo);
        }
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), NO_SALE, SB.toString());
    }

    public static void logMotoTransactionInitiated(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), PAY_OFF, "MOTO Transaction Initiated From Terminal " + terminal.getName());
    }

    public static void logPayment(FinanceTransaction transaction, List items) {
        try {
            if (transaction == null) {
                return;
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(TerminalEventLog.getAccountDesc(transaction.getPayoffGroup()));
            buffer.append("Transaction: ");
            buffer.append(transaction.getSubType() == null ? "" : transaction.getSubType().getLabel());
            buffer.append(transaction.getSubType() == null ? "" : ", ");
            buffer.append(transaction);
            buffer.append("; Cashdrawer ");
            buffer.append(transaction.getCashDrawer().getLabel());
            buffer.append(" opened. ");
            buffer.append("Items paid for from ");
            buffer.append(TerminalEventLog.getPrefix(transaction.getPayoffGroup()));
            buffer.append(transaction.getPayoffGroup().getLabel());
            buffer.append(" Account Id (");
            buffer.append(transaction.getPayoffGroup().getID());
            buffer.append("): ");
            for (SalesLineItem item : items) {
                buffer.append("\n");
                buffer.append(item.getQuantity());
                buffer.append(" ");
                buffer.append(item.getLabel());
                buffer.append(" ");
                buffer.append(item.getPrice());
            }
            TerminalEventLog.getInst().logActivity(new FinanceTransactionContext(transaction), PAY_OFF, buffer.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.error("Could not save payment to event log", (Throwable)ex);
        }
    }

    public static void logPaymentDeleted(EventContext context, FinanceTransaction transaction) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TerminalEventLog.getAccountDesc(transaction.getPayoffGroup()));
        buffer.append(" Deleted payment: ").append(transaction.getSubType().getLabel()).append(", ");
        buffer.append(transaction.getPaid().toString()).append(".").append("From: ").append(TerminalEventLog.getPrefix(transaction.getPayoffGroup())).append(transaction.getPayoffGroup().getLabel());
        TerminalEventLog.getInst().logActivity(context, PAYMENT_DELETED, buffer.toString());
    }

    public static void logPaymentCanceled(EventContext context, FinanceTransaction transaction, Payable payable) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TerminalEventLog.getAccountDesc(transaction.getPayoffGroup()));
        buffer.append("Canceled payment: ").append(transaction.getSubType().getLabel()).append(", ");
        buffer.append(transaction.getPaid().toString()).append(".").append("From: ").append(TerminalEventLog.getPrefix(transaction.getPayoffGroup())).append(payable.getLabel());
        TerminalEventLog.getInst().logActivity(context, PAYMENT_CANCELED, buffer.toString());
    }

    public static void logPaymentRefuned(EventContext context, FinanceTransaction transaction, Payable payable, Price refunedAmount) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(TerminalEventLog.getAccountDesc(transaction.getPayoffGroup()));
        buffer.append("Refunded payment: ").append(transaction.getSubType().getLabel()).append(" - ").append(transaction.getNote()).append(", ");
        buffer.append(refunedAmount).append(".").append("From: ").append(TerminalEventLog.getPrefix(transaction.getPayoffGroup())).append(payable.getLabel());
        TerminalEventLog.getInst().logActivity(context, PAYMENT_REFUNDED, buffer.toString());
    }

    public void logDebtorSaleFailed(EventContext context, String debtor, ItemGroup account) {
        String message = TerminalEventLog.getAccountDesc(account) + "Sale Account " + TerminalEventLog.returnAccountIdString(account) + account.getLabel() + " applied to debtor : " + debtor + " failed ";
        TerminalEventLog.getInst().logActivity(context, DEBTOR_SALE, message);
    }

    public void logDebtorSale(EventContext context, AbstractDebtor debtor, ItemGroup account) {
        String message = TerminalEventLog.getAccountDesc(account) + "Sale Account " + TerminalEventLog.returnAccountIdString(account) + account.getLabel() + " applied to debtor: " + debtor.getLabel();
        TerminalEventLog.getInst().logActivity(context, DEBTOR_SALE, message);
    }

    public void logDebtorPayment(EventContext context, AbstractDebtor debtor, FinanceTransaction transaction) {
        String message = "Payment: " + transaction.getType() + ", " + transaction.getLabel() + " applied to debtor: " + debtor.getLabel();
        TerminalEventLog.getInst().logActivity(context, DEBTOR_PAYMENT, message);
    }

    public void logDebtorAdjustment(EventContext context, AbstractDebtor debtor, FinanceTransaction transaction) {
        String message = "Adjustment: " + transaction.getLabel() + " applied to debtor: " + debtor.getLabel();
        TerminalEventLog.getInst().logActivity(context, DEBTOR_ADJUSTMENT, message);
    }

    public void logDebtorTransaction(EventContext context, AbstractDebtor debtor, FinanceTransaction tran) {
        if (tran instanceof DebtorAdjustmentTransaction) {
            this.logDebtorAdjustment(context, debtor, tran);
        } else {
            this.logDebtorPayment(context, debtor, tran);
        }
    }

    public void logDebtorTransactionRefund(EventContext context, AbstractDebtor debtor, FinanceTransaction transaction) {
        String message = "Refund: " + transaction.getLabel() + " applied to debtor: " + debtor.getLabel();
        TerminalEventLog.getInst().logActivity(context, DEBTOR_REFUND, message);
    }

    public void logDebtorSaleRefund(EventContext context, AbstractDebtor debtor, DebtorSale sale) {
        Account someAcc = sale.getSaleAccount();
        List<SalesItem> salesItems = someAcc.getItemHelper().getSalesItems();
        StringBuilder salesItemSummary = new StringBuilder(TerminalEventLog.getAccountDesc(someAcc) + "Refund: SalesAccountID - ");
        salesItemSummary.append(someAcc.getID()).append(" ");
        for (int index = 0; index < salesItems.size(); ++index) {
            salesItemSummary.append(salesItems.get(index).getLabel()).append(":").append(salesItems.get(index).getPrice());
            if (index == salesItems.size()) continue;
            salesItemSummary.append(", ");
        }
        salesItemSummary.append(" Debtor: ").append(debtor.getLabel());
        TerminalEventLog.getInst().logActivity(context, DEBTOR_REFUND, salesItemSummary.toString());
    }

    public void logDebtorSalesAccountTransfer(EventContext context, AbstractDebtor sourceDebtor, AbstractDebtor destDebtor, List salesAccountsTransferred) {
        StringBuilder message = new StringBuilder("Sales: ");
        Iterator it = salesAccountsTransferred.iterator();
        while (it.hasNext()) {
            ItemGroup currentAccount = (ItemGroup)it.next();
            message.append(currentAccount.getLabel());
            if (!it.hasNext()) continue;
            message.append(" , ");
        }
        message.append(" transfered from: ").append(sourceDebtor.getLabel()).append("  to: ").append(destDebtor.getLabel());
        TerminalEventLog.getInst().logActivity(context, DEBTOR_TRANSFER, message.toString());
    }

    public void logDebtorFinanceTransactionTransfer(EventContext context, AbstractDebtor sourceDebtor, AbstractDebtor destDebtor, List<FinanceTransaction> financeTransactionsTransferred) {
        StringBuilder message = new StringBuilder("Payments: ");
        Iterator<FinanceTransaction> it = financeTransactionsTransferred.iterator();
        while (it.hasNext()) {
            FinanceTransaction currentTran = it.next();
            message.append(currentTran.getLabel());
            if (!it.hasNext()) continue;
            message.append(" , ");
        }
        message.append(" transfered from: ").append(sourceDebtor.getLabel()).append("  to: ").append(destDebtor.getLabel());
        TerminalEventLog.getInst().logActivity(context, DEBTOR_TRANSFER, message.toString());
    }

    private static String getPrefix(ItemGroup group) {
        if (group instanceof PhoneAccount) {
            return "Phone Order ";
        }
        if (group instanceof TakeawayAccount) {
            return "Takeaway/Quick Sale ";
        }
        if (group instanceof PhoneAccount) {
            return "Delivery ";
        }
        return "";
    }

    public static void logDeliverySettle(User user, Terminal terminal, CashDrawer cashdrawer) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), SETTLE_DELIVERY, "Settling delivery accounts. Cashdrawer " + cashdrawer.getLabel() + " opened.");
    }

    public static void logWastageItem(EventContext eContext, String waste, String reason) {
        TerminalEventLog.getInst().logActivity(eContext, WASTAGE_LOG, "Wasted Item: " + waste + ", Reason: " + reason);
    }

    public static void logWastageAccount(EventContext eContext, String accountName, String reason, Account account) {
        TerminalEventLog.getInst().logActivity(eContext, WASTAGE_LOG, TerminalEventLog.getAccountDesc(account) + " Wasted Account: " + accountName + ", Reason: " + reason);
    }

    public static void logOrderedItems(User user, Terminal terminal, ItemGroup account, Collection items) {
        String logType = ITEMS_ORDERED;
        String accStr = "Ordering items to account ";
        if (account instanceof WastageAccount) {
            accStr = "Wasting items in account ";
            logType = WASTAGE_LOG;
        }
        StringBuffer buffer = new StringBuffer();
        for (SalesLineItem item : items) {
            SalesQuantity quantity = item.getUnsavedQuantity();
            if (!quantity.greaterThan(0L)) continue;
            if (buffer.length() == 0) {
                buffer.append(accStr).append(TerminalEventLog.returnAccountIdString(account)).append(account.getLabel()).append(":\n");
            }
            buffer.append(quantity).append(" ").append(item.getLabel()).append(" ");
            buffer.append(item.getBasePrice().multiply(quantity)).append(" (Course ").append(item.getCourse() + 1).append(")\n");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), logType, buffer.toString());
        }
    }

    public static void logRefundedItems(EventContext context, ItemGroup account, Collection<? extends SalesLineItem> items) {
        StringBuffer buffer = new StringBuffer();
        for (SalesLineItem salesLineItem : items) {
            if (!salesLineItem.hasUnsavedRefundedQuantity()) continue;
            if (buffer.length() == 0) {
                buffer.append("Refunded items from account ");
                buffer.append(TerminalEventLog.returnAccountIdString(account));
                buffer.append(account.getLabel());
                buffer.append(":\n");
            }
            buffer.append(TerminalEventLog.getItemDescription(salesLineItem));
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(context, ITEMS_REFUNDED, buffer.toString());
        }
    }

    public static void logDeletedItems(User user, Terminal terminal, ItemGroup account, Collection<? extends SalesLineItem> items) {
        StringBuffer buffer = new StringBuffer();
        for (SalesLineItem salesLineItem : items) {
            if (!salesLineItem.hasUnsavedDeletedQuantity()) continue;
            if (buffer.length() == 0) {
                buffer.append("Deleted items from account ");
                buffer.append(TerminalEventLog.returnAccountIdString(account));
                buffer.append(account.getLabel());
                buffer.append(":\n");
            }
            buffer.append(TerminalEventLog.getItemDescription(salesLineItem));
            buffer.append("\n");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), ITEMS_DELETED, buffer.toString());
        }
    }

    private static String getItemDescription(SalesLineItem item) {
        SalesQuantity quantity = item.getUnsavedQuantity();
        StringBuffer buffer = new StringBuffer();
        buffer.append(quantity.negate()).append(" ").append(item.getLabel()).append(" ");
        buffer.append(item.getPricePerItem().multiply(quantity.negate())).append(" (Course ");
        buffer.append(item.getCourse() + 1).append(")");
        return buffer.toString();
    }

    public static void logCanceledItems(User user, Terminal terminal, ItemGroup account, SalesLineItem item) {
        StringBuffer buffer = new StringBuffer();
        SalesQuantity quantity = item.getUnsavedQuantity();
        if (buffer.length() == 0) {
            buffer.append("Canceled items from account ");
            buffer.append(TerminalEventLog.returnAccountIdString(account));
            buffer.append(account.getLabel());
            buffer.append(":\n");
        }
        buffer.append(quantity.negate());
        buffer.append(" ");
        buffer.append(item.getLabel());
        buffer.append(" ");
        buffer.append(item.getPricePerItem().multiply(quantity.negate()));
        buffer.append(" (Course ");
        buffer.append(item.getCourse() + 1);
        buffer.append(")\n");
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), ITEMS_CANCELED, buffer.toString());
        }
    }

    public static void logMovedItems(User user, Terminal terminal, ItemGroup account, Collection items) {
        StringBuffer buffer = new StringBuffer();
        for (SalesLineItem item : items) {
            if (!item.hasUnsavedMovedQuantity()) continue;
            SalesQuantity quantity = item.getUnsavedQuantity();
            if (buffer.length() == 0) {
                buffer.append("Moved items from account ").append(TerminalEventLog.returnAccountIdString(account)).append(account.getLabel()).append(":\n");
            }
            buffer.append(quantity.negate()).append(" ").append(item.getLabel()).append(" ");
            buffer.append(item.getPrice()).append(" (Course ").append(item.getCourse() + 1).append(")\n");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), ITEMS_MOVED, buffer.toString());
        }
    }

    public static void logTakingsView(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), TAKINGS_VIEW, "Restaurant takings viewed.");
    }

    public static void logTakingsPrint(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), TAKINGS_PRINT, "Restaurant takings printed.");
    }

    public static void logSalesPrint(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), TAKINGS_PRINT, "Restaurant sales printed.");
    }

    public static void logPrintBill(User user, Terminal terminal, ItemGroup group) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), PRINT_BILL, TerminalEventLog.getAccountDesc(group) + " Printing bill for account " + group.getLabel() + ".");
    }

    public static void logPrintStatement(EventContext context, String debtorName) {
        TerminalEventLog.getInst().logActivity(context, PRINT_STATEMENT, "Printing bill for debtor " + debtorName + ".");
    }

    public static void logUserLogin(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), USER_LOGIN, user == null ? "Unknown" : user.getName() + " login to terminal " + terminal.getName() + ".");
    }

    public static void logUserLogout(User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), USER_LOGOUT, user == null ? "Unknown" : user.getName() + " logout from terminal " + terminal.getName() + ".");
    }

    public static void logBarTabCreation(User user, Terminal terminal, String tabName) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), BAR_TAB, "Bar Tab created: " + tabName + ".");
    }

    public static void logCreditLimitChange(EventContext context, CreditLimited creditLimitedObject, Price theNewAmount, Price theOldAmount) {
        TerminalEventLog.getInst().logActivity(context, CREDIT_LIMIT, "Account " + creditLimitedObject.getLabel() + " credit limit changed from " + theOldAmount.toString(true) + " to " + theNewAmount.toString(true) + ".");
    }

    public static void logClosedAccount(User user, Terminal terminal, ItemGroup account) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), CLOSED_ACCOUNT, TerminalEventLog.getAccountDesc(account) + " Closed account " + TerminalEventLog.returnAccountIdString(account) + account.getLabel() + " entered.");
    }

    public static void logCustomerPointsSet(User user, Terminal terminal, Customer customer, int points) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), LOYALTY_POINTS, "Customer " + customer.getID() + " " + customer.getFirstName() + " " + customer.getLastName() + "'s loyalty points set to " + points + ".");
    }

    public static void logCustomerSetToAccount(EventContext context, ItemGroup theItemGroup) {
        Customer customer = theItemGroup.getCustomer();
        if (customer != null) {
            TerminalEventLog.getInst().logActivity(context, ACCOUNTS_CUSTOMER_SET, TerminalEventLog.getAccountDesc(theItemGroup) + "Customer " + customer.getID() + " " + customer.getFirstName() + " " + customer.getLastName() + " set for account" + theItemGroup.toString());
        }
    }

    public static void logCustomerSetToSeat(EventContext context, TableAccount account, int seat) {
        Customer customer = account.getCustomerForSeat(seat);
        TerminalEventLog.getInst().logActivity(context, ACCOUNTS_CUSTOMER_SET, TerminalEventLog.getAccountDesc(account) + " Customer [" + customer.getID() + "] " + customer.getFirstName() + " " + customer.getLastName() + " set for seat " + seat + " on account " + account.toString());
    }

    public static void logTerminalStartup(Terminal terminal) {
        User omUser = User.getSystemUser();
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, omUser), TERMINAL_STARTUP, "Terminal '" + terminal.getTerminalType() + " - " + terminal.getName() + "'  started");
    }

    public static void logCashDrawerSkim(User user, Terminal terminal, Skim skim) {
        StringBuilder message = new StringBuilder(skim.getTotal().toString());
        message.append(" skimmed from cashdrawer ");
        message.append(skim.getCashDrawer().getLabel());
        message.append(".\n");
        for (SkimTransaction tran : skim.getAllTransactions()) {
            Price amt = skim.getTotalForSubType(tran.getFinanceUnit());
            message.append(tran.getFinanceUnit());
            message.append(": ");
            message.append(amt);
            if (SystemState.ACTIVE_STATE.equals(tran.getSystemState())) {
                message.append(" ** DELETED **");
            }
            message.append('\n');
        }
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), CASHDRAWER_SKIM, message.toString());
    }

    public static void logUnlockTable(LogicalTable table, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, UNLOCK_TABLE, "Table " + table.getTableGroup().getLabel() + " " + table.getLabel() + " unlocked.");
    }

    public static void logLockTable(LogicalTable table, User user, Terminal terminal) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), LOCK_TABLE, "Table " + table.getTableGroup().getLabel() + " " + table.getLabel() + " locked.");
    }

    public static void logUnlockAccount(ItemGroup account, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, UNLOCK_ACCOUNT, TerminalEventLog.getAccountDesc(account) + "Account " + TerminalEventLog.returnAccountIdString(account) + account.getLabel() + " unlocked.");
    }

    public static void logUnlockLockable(Lockable lockable, User user, Terminal terminal) {
        TerminalEventLog.logUnlockLockable(lockable, new EventContext(terminal, user));
    }

    public static void logUnlockLockable(Lockable lockable, EventContext context) {
        if (lockable instanceof ItemGroup) {
            TerminalEventLog.logUnlockAccount((ItemGroup)lockable, context);
        } else if (lockable instanceof LogicalTable) {
            TerminalEventLog.logUnlockTable((LogicalTable)lockable, context);
        } else if (lockable instanceof TableGroup) {
            TerminalEventLog.logUnlockTableGroup((TableGroup)lockable, context);
        } else if (lockable instanceof AbstractDebtor) {
            TerminalEventLog.logUnlockDebtorAccount((AbstractDebtor)lockable, context);
        } else if (lockable instanceof Delivery) {
            TerminalEventLog.logUnlockDelivery((Delivery)lockable, context);
        } else {
            throw new IllegalArgumentException("Cannot log lockable: " + lockable.getClass().toString());
        }
    }

    public static void logUnlockTableGroup(TableGroup tableGroup, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, UNLOCK_TABLE_GROUP, "TableGroup " + tableGroup.getLabel() + " unlocked.");
    }

    public static void logUnlockDebtorAccount(AbstractDebtor debtor, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, UNLOCK_DEBTOR, "Debtor " + debtor.getLabel() + " unlocked.");
    }

    public static void logUnlockDelivery(Delivery delivery, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, UNLOCK_DELIVERY, "Delivery : " + delivery.getLabel() + " unlocked");
    }

    public static void logTradingDayDiscrepancy(User user, Terminal terminal, String description) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), TRADING_DAY_DISCREPANCY, description);
    }

    public static void logDeviceFailure(Terminal terminal, String description) {
        User omUser = User.getSystemUser();
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, omUser), DEVICE_FAILURE, description);
    }

    public static void logSafeRestart(User user) {
        TerminalEventLog.getInst().logActivity(user, SAFE_REBOOT, "User " + user + " performed safe restarting");
    }

    public static void logEftposEvent(User user, Terminal terminal, String description) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), EFTPOS_EVENT, description);
    }

    public static void logShiftChange(User user, Terminal terminal, String description) {
        TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), SHIFT_CHANGE, description);
    }

    public static void logPinDuplicateRejected(EventContext context, String pin) {
        User compromisedUser = User.getUserByPin(pin);
        TerminalEventLog.getInst().logActivity(context, PIN_DUPLICATION, context.getUser() + " attempted to set pin to " + compromisedUser + "'s pin");
    }

    public static void logInvalidPinLoginAttempt(Terminal terminal, String pin) {
        EventContext context = new EventContext(terminal, User.getSystemUser());
        TerminalEventLog.getInst().logActivity(context, INVALID_LOGIN, "Invalid login attempt with pin : " + pin);
    }

    public static void logInvalidSwipeOverAttempt(Terminal terminal, String description) {
        EventContext context = new EventContext(terminal, User.getSystemUser());
        TerminalEventLog.getInst().logActivity(context, SWIPE_OVER, description);
    }

    public static void logAllowOrderBelowMinDelivery(EventContext context, ItemGroup account) {
        TerminalEventLog.getInst().logActivity(context, MINIMUM_DELIVERY_OVERRIDE, TerminalEventLog.getAccountDesc(account) + "Delivery for " + account.toString() + " for " + account.getTotal() + " allowed by " + context.getUser().getName());
    }

    public static void logOfflineEftpos(EventContext context, FinanceTransaction tran, ItemGroup account) {
        TerminalEventLog.getInst().logActivity(context, OFFLINE_EFTPOS, TerminalEventLog.getAccountDesc(account) + "An offline eftpos transaction has been performed for :" + tran.getPaid() + " " + tran.getType());
    }

    public static void logAllowDeliveryToWarnZone(EventContext context, Customer customer, ItemGroup account) {
        StringBuilder SB = new StringBuilder(TerminalEventLog.getAccountDesc(account) + "Delivery for ").append(account.toString()).append(" to ");
        SB.append(customer.getAddress()).append(" allowed by ").append(context.getUser().getName());
        try {
            TerminalEventLog.getInst().logActivity(context, OUT_OF_AREA_WARNING, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception generating message : " + context + " , account " + account, (Throwable)ex);
        }
    }

    public static void logClockOnOff(User user, boolean isClockOn) {
        EventContext context = new EventContext(user);
        StringBuilder SB = new StringBuilder("Clock ");
        if (isClockOn) {
            SB.append("ON ");
            OrderMate.LOG.info("Driver clocked ON:" + user.getName());
        } else {
            SB.append("OFF ");
            OrderMate.LOG.info("Driver clocked OFF:" + user.getName());
        }
        SB.append("for user ").append(user.getName());
        try {
            TerminalEventLog.getInst().logActivity(context, CLOCK_ON_OFF, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception generating clock on/off log: " + context, (Throwable)ex);
        }
    }

    public static void logAssignOrderToDelivery(EventContext context, ItemGroup account, Delivery delivery, boolean assigned) {
        StringBuilder SB = new StringBuilder(TerminalEventLog.getAccountDesc(account) + "account ").append(account.getOrderNumber());
        if (assigned) {
            SB.append(" assigned to ");
        } else {
            SB.append(" unassigned from ");
        }
        SB.append("delivery ").append(delivery.getLabel());
        try {
            TerminalEventLog.getInst().logActivity(context, ASSIGN_DELIVERY, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception assign order to delivery: " + context, (Throwable)ex);
        }
    }

    public static void logTradingDayAdjustment(EventContext context, TradingDayAdjustment priceAdjustment, boolean activated) {
        StringBuilder SB = new StringBuilder("Daily price adjustment '").append(priceAdjustment.getLabel());
        if (activated) {
            SB.append("' got activated ");
        } else {
            SB.append("' got deactivated ");
        }
        User currentUser = context.getUser();
        SB.append("by user ").append(currentUser.getName());
        try {
            TerminalEventLog.getInst().logActivity(context, DISCOUNT, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging activating/deactivating discount: " + context, (Throwable)ex);
        }
    }

    public static void logTableStateChanged(LogicalTable table, LogicalTableState oldState, LogicalTableState newState, EventContext context, Account account) {
        StringBuilder SB = new StringBuilder(TerminalEventLog.getAccountDesc(account) + " Table ");
        SB.append(table.getLabel()).append(" changed from ").append(oldState).append(" to ").append(newState);
        try {
            TerminalEventLog.getInst().logActivity(context, TABLE_STATE, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Table State activity: " + context, (Throwable)ex);
        }
    }

    public static void logReservationBooked(Reservation reservation, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" made a reservation for ").append(reservation.getCustomerName()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString()).append(" in Section ").append(reservation.getSection()).append(" for ").append(reservation.getNumPatrons()).append(" patrons");
        if (reservation.getComments() != null && !reservation.getComments().isEmpty()) {
            SB.append(" with comments of ").append(reservation.getComments());
        }
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_BOOKED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation booked: " + context, (Throwable)ex);
        }
    }

    public static void logReservationEdited(Reservation reservation, Customer newCustomer, String newComments, int newNumPatrons, TableGroup newSection, Date newDate, Date newTime, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" edited reservation ").append(reservation.getID()).append(" for ").append(newCustomer).append(" at ").append(newDate == null ? "" : DateTimeUtils.getShortDateFormat().format(newDate)).append(" ").append(newTime == null ? "" : DateTimeUtils.getSimpleTimeFormat().format(newTime)).append(" in Section ").append(newSection).append(" for ").append(newNumPatrons).append(" patrons");
        if (newComments != null && !newComments.isEmpty()) {
            SB.append(" with comments of ").append(newComments);
        }
        SB.append(".  Original reservation was at ").append(reservation.getTimeString()).append(" for ").append(reservation.getCustomer()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString()).append(" in Section ").append(reservation.getSection()).append(" for ").append(reservation.getNumPatrons()).append(" patrons");
        if (reservation.getComments() != null && !reservation.getComments().isEmpty()) {
            SB.append(" with comments of ").append(reservation.getComments());
        }
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_EDITED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation edited: " + context, (Throwable)ex);
        }
    }

    public static void logReservationArrived(Reservation reservation, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" arrived reservation ").append(reservation.getID()).append(" for ").append(reservation.getCustomerName()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString()).append(" on table ").append(reservation.getTableAccount());
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_ARRIVED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation arrived: " + context, (Throwable)ex);
        }
    }

    public static void logReservationUnseated(Reservation reservation, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" unseated reservation ").append(reservation.getID()).append(" for ").append(reservation.getCustomerName()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString()).append(" on table ").append(reservation.getTableAccount());
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_UNSEATED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation unseated: " + context, (Throwable)ex);
        }
    }

    public static void logReservationDeleted(Reservation reservation, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" deleted reservation ").append(reservation.getID()).append(" for ").append(reservation.getCustomerName()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString()).append(reservation.getTimeString());
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_DELETED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation deleted: " + context, (Throwable)ex);
        }
    }

    public static void logReservationConfirmed(Reservation reservation, EventContext context) {
        StringBuilder SB = new StringBuilder("User ").append(context.getUser()).append(" confirmed reservation ").append(reservation.getID()).append(" for ").append(reservation.getCustomerName()).append(" at ").append(reservation.getDate() == null ? "" : DateTimeUtils.getShortDateFormat().format(reservation.getDate())).append(" ").append(reservation.getTimeString());
        try {
            TerminalEventLog.getInst().logActivity(context, RESERVATION_CONFIRMED, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Reservation confirmed: " + context, (Throwable)ex);
        }
    }

    public static void logStockCountChange(InventoryItem item, SalesQuantity originalQty, SalesQuantity newQty, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, STOCK_COUNT_CHANGED, "Stock Count Change (" + item.getLabel() + "): " + originalQty.toString() + " -> " + newQty.toString());
    }

    public static void logStockCountSet(InventoryItem item, SalesQuantity newQty, EventContext context) {
        TerminalEventLog.getInst().logActivity(context, STOCK_COUNT_CHANGED, "Stock Count Set For " + item.getLabel() + ": " + (newQty == null ? "None" : newQty.toString()));
    }

    public static void logCouponUsage(SalesCoupon coupon, boolean redeem, TriggerActivationContext context) {
        StringBuilder SB = new StringBuilder("Coupon - ").append(coupon.getLabel()).append(" ").append(coupon.getUniqueId()).append(", ");
        if (!redeem) {
            SB.append("un-");
        }
        SB.append("redeemed");
        try {
            TerminalEventLog.getInst().logActivity(context, COUPONS, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Accounting Export activity: " + context, (Throwable)ex);
        }
    }

    public void logInvoiceSyncEvent(Invoice invoice, EventContext context) {
        StringBuilder sb = new StringBuilder("Invoice Number : ").append(invoice.getInvoiceNumber()).append("is not submitted since an invoice with the same number is already finalised in Xero");
        try {
            TerminalEventLog.getInst().logActivity(context, "Xero Invoice Sync Failed", sb.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Accounting Export activity: " + context, (Throwable)ex);
        }
    }

    public static void logTransactionTransferred(FinanceTransaction txn, String debtorName, String to, EventContext context) {
        StringBuilder sb = new StringBuilder();
        sb.append(TerminalEventLog.getAccountDesc(txn.getPayoffGroup()));
        sb.append("Transaction: ").append(txn.toString()).append(" transferred from ").append(debtorName).append(" to ").append(to);
        try {
            TerminalEventLog.getInst().logActivity(context, TXN_TRANSFER, sb.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Finance Transaction Transfer : " + context, (Throwable)ex);
        }
    }

    public void logVoucherTxnRequest(String attempt, GiftVoucherTransaction txn, EventContext context) {
        StringBuilder SB = new StringBuilder(TerminalEventLog.getAccountDesc(txn.getAccount()) + "Voucher Transaction Event attempt: ");
        SB.append(attempt).append(" ").append(txn.getAmount()).append(" to ").append(txn.getGiftVoucher().getUniqueId());
        try {
            this.logActivity(context, VOUCHER_TXN_REQUEST, SB.toString());
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Voucher Transaction Request: " + context, (Throwable)ex);
        }
    }

    public void logVoucherTxnResponse(String message, EventContext context) {
        try {
            this.logActivity(context, VOUCHER_TXN_RESPONSE, message);
        }
        catch (Exception ex) {
            OrderMate.LOG.warn("Exception while logging Voucher Transaction Response: " + context, (Throwable)ex);
        }
    }

    public static void logOrderedItems(User user, Terminal terminal, ItemGroup account, Collection items, OrderItemLogType orderItemLogType) {
        String logType = ITEMS_ORDERED;
        String accStr = "Ordering items to account ";
        if (account instanceof WastageAccount) {
            accStr = "Wasting items in account ";
            logType = WASTAGE_LOG;
        }
        StringBuffer buffer = new StringBuffer();
        for (SalesLineItem item : items) {
            SalesQuantity quantity = item.getUnsavedQuantity();
            if (!quantity.greaterThan(0L)) continue;
            buffer.append(orderItemLogType.name() + " :");
            if (buffer.length() == 0) {
                buffer.append(accStr).append(TerminalEventLog.returnAccountIdString(account)).append(account.getLabel()).append(":\n");
            }
            buffer.append(quantity).append(" ").append(item.getLabel()).append(" ");
            buffer.append(item.getBasePrice().multiply(quantity)).append(" (Course ").append(item.getCourse() + 1).append(")\n");
        }
        if (buffer.length() > 0) {
            buffer.insert(0, TerminalEventLog.getAccountDesc(account));
            TerminalEventLog.getInst().logActivity(new EventContext(terminal, user), logType, buffer.toString());
        }
    }

    static {
        instanceInitialized = false;
    }
}

