/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.oquery.ObjectQuery;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.oquery.SQLDateType;
import au.com.ordermate.persistence.Displayable;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCacheListManager;
import au.com.ordermate.util.DateTimeUtils;
import java.awt.Color;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.finance.Shift;
import ordermate.database.finance.priceadjustment.InventoryPriceAdjustment;
import ordermate.database.finance.priceadjustment.PriceAdjustmentManager;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.ConfigShift;
import ordermate.database.misc.SystemCurrentInfo;
import ordermate.database.misc.SystemProperty;
import ordermate.database.misc.TerminalEventLog;
import ordermate.database.misc.TradingDayComparator;
import ordermate.database.queries.misc.TradingDayQueries;
import ordermate.database.sales.Account;
import ordermate.database.sales.AccountState;
import ordermate.database.users.User;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="finance_trading_day")
@AccessType(value="property")
public class TradingDay
extends PersistentObject
implements Saveable,
Displayable,
Comparable {
    public static final Props Properties = new Props();
    private static LocalCacheListManager<TradingDay> allTradingDays = new LocalCacheListManager<TradingDay>(Query.createQueryList(TradingDay.class, Query.select(TradingDay.class).orderBy(TradingDay.Properties.DATE).orderBy(TradingDay.Properties.ID)));
    private static final DateTimeUtils.ThreadLocalDateFormat shortDateFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("E, dd MMM"));
    public static final DateTimeUtils.ThreadLocalDateFormat fullDateFormatter = new DateTimeUtils.ThreadLocalDateFormat(new SimpleDateFormat("E, dd MMM yyyy"));
    private static final int CURRENT_YEAR = Calendar.getInstance().get(1);
    private java.util.Date date;
    private java.util.Date time;
    private java.util.Date closeDate;
    private java.util.Date closeTime;

    public static List<TradingDay> getAllTradingDays() {
        if (allTradingDays.getByID(SystemCurrentInfo.getInstance().getCurrentTradingDay().getID()) == null) {
            allTradingDays.clearCache();
        }
        return allTradingDays.getList();
    }

    public TradingDay() {
        this.date = new java.util.Date();
    }

    public TradingDay(TradingDay other) {
        if (other.date != null) {
            this.date = new java.util.Date(other.date.getTime());
        }
        if (other.closeDate != null) {
            this.closeDate = new java.util.Date(other.closeDate.getTime());
        }
        if (other.time != null) {
            this.time = new java.util.Date(other.time.getTime());
        }
        if (other.closeTime != null) {
            this.closeTime = new java.util.Date(other.closeTime.getTime());
        }
    }

    @Override
    @Transient
    public String getLabel() {
        if (this.date == null) {
            OrderMate.LOG.error("Trading day " + this.getID() + " does not have valid date.");
            return "No date set";
        }
        Calendar c = Calendar.getInstance();
        c.setTime(this.date);
        c.add(10, 6);
        if (c.get(1) == CURRENT_YEAR) {
            return shortDateFormatter.getFormat().format(c.getTime());
        }
        return this.getFullLabel();
    }

    @Transient
    public String getFullLabel() {
        return fullDateFormatter.getFormat().format(this.getDate());
    }

    @Column(name="day")
    @Temporal(value=TemporalType.DATE)
    public java.util.Date getDate() {
        return new java.util.Date(this.date.getTime());
    }

    @Transient
    public java.util.Date getOpenDateTime() {
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(this.date);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(this.time);
        dateCal.set(11, timeCal.get(11));
        dateCal.set(12, timeCal.get(12));
        dateCal.set(13, timeCal.get(13));
        dateCal.set(14, timeCal.get(14));
        return dateCal.getTime();
    }

    public void setDate(java.util.Date openingDay) {
        this.date = new java.util.Date(openingDay.getTime());
    }

    @Column(name="time")
    @Temporal(value=TemporalType.TIME)
    public java.util.Date getTime() {
        return this.time;
    }

    public void setTime(java.util.Date openingTime) {
        this.time = openingTime;
    }

    @Column(name="close_day")
    @Temporal(value=TemporalType.DATE)
    public java.util.Date getCloseDate() {
        if (this.closeDate != null) {
            return new java.util.Date(this.closeDate.getTime());
        }
        return null;
    }

    public void setCloseDate(java.util.Date newCloseDate) {
        this.closeDate = newCloseDate != null ? new java.util.Date(newCloseDate.getTime()) : null;
    }

    @Column(name="close_time")
    @Temporal(value=TemporalType.TIME)
    public java.util.Date getCloseTime() {
        return this.closeTime;
    }

    @Transient
    public java.util.Date getCloseDateTime() {
        if (this.isOpen()) {
            return null;
        }
        Calendar dateCal = Calendar.getInstance();
        dateCal.setTime(this.closeDate);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(this.closeTime);
        dateCal.set(11, timeCal.get(11));
        dateCal.set(12, timeCal.get(12));
        dateCal.set(13, timeCal.get(13));
        dateCal.set(14, timeCal.get(14));
        return dateCal.getTime();
    }

    public void setCloseTime(java.util.Date newCloseTime) {
        this.closeTime = newCloseTime;
    }

    @Transient
    public boolean isOpen() {
        return this.getCloseDate() == null;
    }

    public int getNumSalesForPlu(int plu) {
        Number i;
        int sales = 0;
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(TradingDayQueries.GET_NUM_SALES, new Object[]{plu, this.getID()});
        if (results != null && results.length > 0 && results[0].length > 0 && (i = (Number)results[0][0]) != null) {
            sales = i.intValue();
        }
        return sales;
    }

    @Transient
    public InventoryPriceAdjustment getPriceAdjustment() {
        return PriceAdjustmentManager.getInstance().getTradingDayAdjustments(this);
    }

    @Transient
    public int getNumOpenAcounts() {
        String sql = Query.count(Account.class).equals(Account.Properties.ACCOUNT_STATE, (Object)AccountState.OPEN).equals(Account.Properties.TRADING_DAY, this.getID()).toString();
        Object[][] results = PersistenceManager.getPersistenceDelegate().executeQuery(sql, new Object[0]);
        Number accounts = (Number)results[0][0];
        return accounts.intValue();
    }

    public static boolean needsNewTradingDay() {
        TradingDay currentDay = TradingDay.getCurrentTradingDay();
        if (currentDay == null) {
            return true;
        }
        java.util.Date changeTime = SystemProperty.getInstance().getChangeDayTime();
        java.util.Date nextDate = TradingDay.getNextTradingDayDate(changeTime);
        Calendar currentDayCal = Calendar.getInstance();
        currentDayCal.setTime(currentDay.getDate());
        Calendar newDayCal = Calendar.getInstance();
        newDayCal.setTime(nextDate);
        boolean sameDate = currentDayCal.get(5) == newDayCal.get(5);
        sameDate &= currentDayCal.get(2) == newDayCal.get(2);
        return !(sameDate &= currentDayCal.get(1) == newDayCal.get(1));
    }

    public static synchronized TradingDay getCurrentTradingDay() {
        return SystemCurrentInfo.getInstance().getCurrentTradingDay();
    }

    @Transient
    public TradingDay getPreviousTradingDay() {
        return PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).lessThan(TradingDay.Properties.DATE, this.getDate(), SQLDateType.DATE).orderByDesc(TradingDay.Properties.DATE).orderByDesc(TradingDay.Properties.TIME).toString(), null);
    }

    @Transient
    public TradingDay getNextTradingDay() {
        return PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).greaterThan(TradingDay.Properties.DATE, this.getDate(), SQLDateType.DATE).orderBy(TradingDay.Properties.DATE).orderBy(TradingDay.Properties.TIME).toString(), null);
    }

    public static java.util.Date getNextTradingDayDate(java.util.Date changeDayTime) {
        Calendar nowCal = Calendar.getInstance();
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(changeDayTime);
        timeCal.set(nowCal.get(1), nowCal.get(2), nowCal.get(5));
        if (nowCal.after(timeCal) || nowCal.equals(timeCal)) {
            return nowCal.getTime();
        }
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return cal.getTime();
    }

    public static java.util.Date getChangeOfDayTime(java.util.Date tradingDayWhichNeedsUpdating, java.util.Date changeDayTime) {
        Calendar changeTimeCal = Calendar.getInstance();
        changeTimeCal.setTime(changeDayTime);
        Calendar toReturn = Calendar.getInstance();
        toReturn.setTime(tradingDayWhichNeedsUpdating);
        toReturn.add(5, 1);
        toReturn.set(11, changeTimeCal.get(11));
        toReturn.set(12, changeTimeCal.get(12));
        toReturn.set(13, changeTimeCal.get(13));
        toReturn.set(14, 0);
        return toReturn.getTime();
    }

    public static TradingDay createTradingDay(User changeDayUser, Terminal changeDayTerm) {
        java.util.Date changeOfDay = SystemProperty.getInstance().getChangeDayTime();
        java.util.Date newDate = TradingDay.getNextTradingDayDate(changeOfDay);
        TradingDay oldDay = TradingDay.getCurrentTradingDay();
        if (oldDay != null) {
            int numAccounts = oldDay.getNumOpenAcounts();
            if (numAccounts > 0) {
                TerminalEventLog.logTradingDayDiscrepancy(changeDayUser, changeDayTerm, "A new trading day was created, while there were still " + numAccounts + " open account(s)");
            }
            oldDay.closeDate = new Date(System.currentTimeMillis());
            oldDay.closeTime = new java.util.Date(System.currentTimeMillis());
            oldDay.save();
        }
        TradingDay newDay = new TradingDay();
        newDay.date = new Date(newDate.getTime());
        newDay.time = new java.util.Date(System.currentTimeMillis());
        newDay.save();
        PersistenceManager.getPersistenceDelegate().executeUpdate("UPDATE system_current_info SET FK_finance_trading_day = ?", new Object[]{newDay.getID()});
        PersistenceManager.getInstance().clearLocalCaches();
        String[] shifts = Shift.getShiftNames();
        Shift newShift = Shift.createShift(TradingDay.getCurrentTradingDay(), ConfigShift.getConfigShiftWithName(shifts[0]));
        List<Terminal> terminals = Terminal.getAllTerminals();
        for (Terminal toChange : terminals) {
            newShift.addTerminal(toChange);
        }
        SystemCurrentInfo.setUpdate("Trading Day Changed");
        PersistenceManager.getInstance().clearLocalCaches();
        return newDay;
    }

    public static TradingDay getLastClose() {
        String sql = Query.select(TradingDay.class).not().isNull(TradingDay.Properties.CLOSE_DATE).orderByDesc(TradingDay.Properties.DATE).limit(1).toString();
        TradingDay day = PersistenceManager.getObject(TradingDay.class, sql, new Object[0]);
        return day;
    }

    public static Integer getDayOfWeekForTradingDay(TradingDay day) {
        return DateTimeUtils.getDayOfWeek(day.getDate());
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    @Transient
    public Color getBackgroundColor() {
        return null;
    }

    @Override
    @Transient
    public Color getForegroundColor() {
        return null;
    }

    @Override
    @Transient
    public String getIcon() {
        return "";
    }

    @Override
    public String toString() {
        return this.getLabel();
    }

    public int compareTo(Object o) {
        if (o instanceof TradingDay) {
            return new TradingDayComparator().compare(this, (TradingDay)o);
        }
        return 1;
    }

    public static class ReportDates {
        public static List<java.util.Date> getLastDayOfWeekDates() {
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(ReportDates.getLastTradingDay().getDate());
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(ReportDates.getFirstTradingDay().getDate());
            return ReportDates.getLastDayOfWeekDatesBetween(currentDate, endDate);
        }

        public static List<java.util.Date> getLastDayOfWeekDatesBetween(Calendar currentDate, Calendar endDate) {
            ArrayList<java.util.Date> lastDaysOfWeeks = new ArrayList<java.util.Date>();
            ReportDates.rollToEndOfWeek(currentDate);
            lastDaysOfWeeks.add(currentDate.getTime());
            Calendar newDate = Calendar.getInstance();
            newDate.setTime(currentDate.getTime());
            while (currentDate.before(endDate)) {
                newDate.add(5, 7);
                currentDate = newDate;
                ReportDates.rollToEndOfWeek(currentDate);
                lastDaysOfWeeks.add(currentDate.getTime());
                newDate = Calendar.getInstance();
                newDate.setTime(currentDate.getTime());
            }
            Collections.reverse(lastDaysOfWeeks);
            return lastDaysOfWeeks;
        }

        public static void rollToEndOfWeek(Calendar currentDate) {
            while (currentDate.get(7) != 1) {
                currentDate.add(5, 1);
            }
            currentDate.set(11, 23);
            currentDate.set(12, 59);
            currentDate.set(13, 59);
            currentDate.set(14, 59);
        }

        public static List<java.util.Date> getStartMonthDates() {
            Calendar endDate = Calendar.getInstance();
            Calendar currentDate = Calendar.getInstance();
            endDate.setTime(ReportDates.getLastTradingDay().getDate());
            currentDate.setTime(ReportDates.getFirstTradingDay().getDate());
            return ReportDates.getStartMonthDatesBetween(currentDate, endDate);
        }

        public static List<java.util.Date> getStartMonthDatesBetween(Calendar currentDate, Calendar endDate) {
            currentDate.set(5, 1);
            ArrayList<java.util.Date> firstDayOfMonths = new ArrayList<java.util.Date>();
            while (currentDate.before(endDate)) {
                firstDayOfMonths.add(currentDate.getTime());
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(currentDate.getTime());
                newDate.add(2, 1);
                currentDate = newDate;
            }
            if (currentDate.equals(endDate)) {
                firstDayOfMonths.add(currentDate.getTime());
            }
            Collections.reverse(firstDayOfMonths);
            return firstDayOfMonths;
        }

        public static List<java.util.Date> getStartQuarterDates() {
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(ReportDates.getLastTradingDay().getDate());
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(ReportDates.getFirstTradingDay().getDate());
            return ReportDates.getStartQuarterDatesBetween(currentDate, endDate);
        }

        public static List<java.util.Date> getStartQuarterDatesBetween(Calendar currentDate, Calendar endDate) {
            int[] QUARTER_MONTHS = new int[]{0, 3, 6, 9};
            currentDate.set(5, 1);
            int calMonth = currentDate.get(2);
            currentDate.set(2, calMonth - calMonth % 3);
            ArrayList<java.util.Date> firstDayOfQuarters = new ArrayList<java.util.Date>();
            while (currentDate.before(endDate)) {
                if (Arrays.binarySearch(QUARTER_MONTHS, currentDate.get(2)) >= 0) {
                    firstDayOfQuarters.add(currentDate.getTime());
                }
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(currentDate.getTime());
                newDate.add(2, 1);
                currentDate = newDate;
            }
            if (currentDate.equals(endDate) && Arrays.binarySearch(QUARTER_MONTHS, currentDate.get(2)) >= 0) {
                firstDayOfQuarters.add(currentDate.getTime());
            }
            Collections.reverse(firstDayOfQuarters);
            return firstDayOfQuarters;
        }

        public static List<java.util.Date> getStartYearDates() {
            Calendar endDate = Calendar.getInstance();
            endDate.setTime(ReportDates.getLastTradingDay().getDate());
            Calendar currentDate = Calendar.getInstance();
            currentDate.setTime(ReportDates.getFirstTradingDay().getDate());
            return ReportDates.getStartYearDatesBetween(currentDate, endDate);
        }

        public static List<java.util.Date> getStartYearDatesBetween(Calendar currentDate, Calendar endDate) {
            currentDate.set(6, 1);
            ArrayList<java.util.Date> firstDayOfYears = new ArrayList<java.util.Date>();
            while (currentDate.before(endDate)) {
                firstDayOfYears.add(currentDate.getTime());
                Calendar newDate = Calendar.getInstance();
                newDate.setTime(currentDate.getTime());
                newDate.add(1, 1);
                currentDate = newDate;
            }
            if (currentDate.equals(endDate)) {
                firstDayOfYears.add(currentDate.getTime());
            }
            Collections.reverse(firstDayOfYears);
            return firstDayOfYears;
        }

        public static TradingDay getLastTradingDayForDate(java.util.Date date) {
            ObjectQuery select = Query.select(TradingDay.class).lessThanOrEqual(TradingDay.Properties.DATE, date, SQLDateType.DATE).orderByDesc(TradingDay.Properties.DATE).limit(1);
            return PersistenceManager.getObject(TradingDay.class, select.toString(), null);
        }

        public static TradingDay getFirstTradingDayForDate(java.util.Date date) {
            ObjectQuery select = Query.select(TradingDay.class).greaterThanOrEqual(TradingDay.Properties.DATE, date, SQLDateType.DATE).orderBy(TradingDay.Properties.DATE).orderBy(TradingDay.Properties.TIME).orderBy(TradingDay.Properties.ID, false).limit(1);
            return PersistenceManager.getObject(TradingDay.class, select.toString(), null);
        }

        public static TradingDay getLastTradingDay() {
            List<TradingDay> allDays = TradingDay.getAllTradingDays();
            if (allDays.size() == 0) {
                throw new IllegalStateException("There are no trading days in the system");
            }
            return allDays.get(allDays.size() - 1);
        }

        public static TradingDay getFirstTradingDay() {
            List<TradingDay> allDays = TradingDay.getAllTradingDays();
            if (allDays.size() == 0) {
                throw new IllegalStateException("There are no trading days in the system");
            }
            return allDays.get(0);
        }

        public static List<TradingDay> getTradingDaysOnOrAfter(java.util.Date fromDate) {
            String query = Query.select(TradingDay.class).greaterThanOrEqual(TradingDay.Properties.DATE, fromDate, SQLDateType.DATE).orderBy(TradingDay.Properties.DATE).toString();
            return PersistenceManager.getObjectList(TradingDay.class, query, null);
        }

        public static List<java.util.Date> getTradingDayDatesOnOrAfter(java.util.Date fromDate) {
            List<TradingDay> days = ReportDates.getTradingDaysOnOrAfter(fromDate);
            HashSet<java.util.Date> dates = new HashSet<java.util.Date>();
            for (TradingDay nextDay : days) {
                dates.add(nextDay.getDate());
            }
            ArrayList<java.util.Date> dateList = new ArrayList<java.util.Date>(dates);
            Collections.sort(dateList);
            Collections.reverse(dateList);
            return dateList;
        }

        public static List<java.util.Date> getTradingDaysBetween(java.util.Date from, java.util.Date to) {
            if (from == null || to == null) {
                throw new IllegalArgumentException("Cannot make a date list with an invalid range");
            }
            if (from.after(to)) {
                throw new IllegalArgumentException("From must come before to to make a date range.");
            }
            ArrayList<java.util.Date> dates = new ArrayList<java.util.Date>();
            for (TradingDay dayIterator = ReportDates.getFirstTradingDayForDate(from); dayIterator != null && dayIterator.getOpenDateTime().before(to); dayIterator = dayIterator.getNextTradingDay()) {
                dates.add(dayIterator.getDate());
            }
            return dates;
        }

        public static List<TradingDay> getAllTradingDaysForDate(java.util.Date fromDate) {
            String query = Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, fromDate, SQLDateType.DATE).toString();
            return PersistenceManager.getObjectList(TradingDay.class, query, null);
        }

        public static TradingDay getPreviousTradingDay(TradingDay day) {
            Calendar cal = Calendar.getInstance();
            cal.set(2000, 1, 1);
            return PersistenceManager.getObject(TradingDay.class, Query.select(TradingDay.class).lessThan(TradingDay.Properties.ID, day.getID()).greaterThan(TradingDay.Properties.DATE, cal.getTime(), SQLDateType.DATE).orderByDesc(TradingDay.Properties.DATE).toString(), null);
        }

        public static List<TradingDay> getClosedTradingDaysForDate(java.util.Date date) {
            String query = Query.select(TradingDay.class).equals(TradingDay.Properties.DATE, date, SQLDateType.DATE).not().isNull(TradingDay.Properties.CLOSE_DATE).toString();
            return PersistenceManager.getObjectList(TradingDay.class, query.toString());
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<java.util.Date> DATE;
        public PropertiedObject.Property<java.util.Date> TIME;
        public PropertiedObject.Property<java.util.Date> CLOSE_DATE;
        public PropertiedObject.Property<java.util.Date> CLOSE_TIME;
    }
}

