/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.DateTimeUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.AccessType;

@Entity
@Table(name="system_web_resource_log")
@AccessType(value="property")
public class WebResourceLog
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Date creationDate;
    private Date creationTime;
    private String creationDateTime;
    private String httpMethod;
    private String uri;
    private String queryString;
    private String remoteAddress;
    private String remoteHost;
    private String remoteUser;
    private int responseStatus;

    @Deprecated
    public WebResourceLog() {
    }

    public WebResourceLog(String httpMethod, String uri, String remoteAddress, String remoteHost, String remoteUser) {
        this.httpMethod = httpMethod;
        this.uri = uri;
        this.remoteAddress = remoteAddress;
        this.remoteHost = remoteHost;
        this.remoteUser = remoteUser;
    }

    @Column(name="creation_date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(Date date) {
        this.creationDate = date;
    }

    @Column(name="creation_time")
    @Temporal(value=TemporalType.TIME)
    public Date getCreationTime() {
        return this.creationTime;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = DateTimeUtils.cleanDatePart(creationTime, true);
    }

    @Column(name="http_method")
    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    @Column(name="uri")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    @Column(name="query_string")
    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryStr) {
        this.queryString = queryStr;
    }

    @Column(name="remote_address")
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setRemoteAddress(String address) {
        this.remoteAddress = address;
    }

    @Column(name="remote_host")
    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    @Column(name="remote_user")
    public String getRemoteUser() {
        return this.remoteUser;
    }

    public void setRemoteUser(String user) {
        this.remoteUser = user;
    }

    @Column(name="response_status")
    public int getResponseStatus() {
        return this.responseStatus;
    }

    public void setResponseStatus(int status) {
        this.responseStatus = status;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        if (this.creationDate == null && this.creationTime == null && this.creationDateTime == null) {
            Date today = new Date();
            String formattedDateTime = DateTimeUtils.formatWithMilliseconds(today);
            this.setCreationDate(today);
            this.setCreationTime(today);
            this.setCreationDateTime(formattedDateTime);
        }
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="creation_date_time")
    public String getCreationDateTime() {
        return this.creationDateTime;
    }

    public void setCreationDateTime(String creationDateTime) {
        this.creationDateTime = creationDateTime;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Date> CREATION_DATE;
        public PropertiedObject.Property<Date> CREATION_TIME;
        public PropertiedObject.Property<String> CREATION_DATETIME;
        public PropertiedObject.Property<String> HTTP_METHOD;
        public PropertiedObject.Property<String> URI;
        public PropertiedObject.Property<String> QUERY_STRING;
        public PropertiedObject.Property<String> REMOTE_ADDRESS;
        public PropertiedObject.Property<String> REMOTE_HOST;
        public PropertiedObject.Property<String> REMOTE_USER;
        public PropertiedObject.Property<Integer> RESPONSE_STATUS;
    }
}

