/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.action;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.misc.action.ActionOperatorFactory;

public class ActionHelper {
    public static final String SEPARATOR = "~";
    ActionOperatorFactory factory = new ActionOperatorFactory();

    public List<List<Operator>> decipherPayload(String input) {
        String[] splits;
        if (input == null || input.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<List<Operator>> operators = new ArrayList<List<Operator>>();
        for (String nextSplit : splits = input.split("\n")) {
            List<String> subSplits = this.split(nextSplit);
            ArrayList<Operator> subOps = new ArrayList<Operator>();
            for (String nextSub : subSplits) {
                Operator nextOp;
                if (nextSub.trim().length() <= 1 || (nextOp = this.factory.createOperator(nextSub)) == null) continue;
                subOps.add(nextOp);
            }
            if (subOps.isEmpty()) continue;
            operators.add(subOps);
        }
        return operators;
    }

    List<String> split(String toSplit) {
        return Arrays.asList(toSplit.split(SEPARATOR));
    }

    public String getPayloadQueryString(TriggerActivationContext context, List<List<Operator>> operators) {
        this.factory.setContext(context);
        StringBuilder SB = new StringBuilder();
        for (List<Operator> nextOps : operators) {
            for (Operator subOp : nextOps) {
                SB.append(subOp.getValue());
            }
        }
        return SB.toString();
    }

    public List<Pair<String, Object>> getPayloadPairs(TriggerActivationContext context, List<List<Operator>> operators) {
        this.factory.setContext(context);
        ArrayList<Pair<String, Object>> pairs = new ArrayList<Pair<String, Object>>();
        for (List<Operator> nextOps : operators) {
            Pair nextPair = null;
            if (nextOps.size() == 2) {
                nextPair = new Pair(String.valueOf(nextOps.get(0).getValue()), nextOps.get(1).getValue());
            } else if (nextOps.size() == 1) {
                nextPair = new Pair("entity", nextOps.get(0).getValue());
            } else if (nextOps.size() > 0) {
                StringBuilder SB = new StringBuilder(String.valueOf(nextOps.get(0).getValue()));
                for (int i = 1; i < nextOps.size() - 1; ++i) {
                    SB.append(nextOps.get(i).getValue());
                }
                nextPair = new Pair(SB.toString(), nextOps.get(nextOps.size() - 1).getValue());
            }
            if (nextPair == null) continue;
            pairs.add(nextPair);
        }
        return pairs;
    }
}

