/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.action;

import au.com.ordermate.operator.AbstractOperatorFactory;
import au.com.ordermate.operator.Operator;
import au.com.ordermate.operator.numeric.NumericOperatorFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.utils.LiteralOperator;
import ordermate.database.utils.MarshallerOperator;
import ordermate.database.utils.PropertyValueOperator;
import ordermate.database.utils.TriggerActivatedPropertyValueHelper;

public class ActionOperatorFactory
extends AbstractOperatorFactory {
    public static final String LITERAL = "\"";
    public static final String MARSHAL = "#";
    private NumericOperatorFactory numFactory = new NumericOperatorFactory();
    private AtomicReference<TriggerActivatedPropertyValueHelper> valueHelper = new AtomicReference<TriggerActivatedPropertyValueHelper>(new TriggerActivatedPropertyValueHelper());

    @Override
    public List<String> getOperators() {
        ArrayList<String> operators = new ArrayList<String>();
        operators.add(LITERAL);
        operators.add(MARSHAL);
        operators.addAll(this.numFactory.getOperators());
        return operators;
    }

    @Override
    public Operator createOperator(String opString) {
        Operator op = null;
        if (opString.startsWith(LITERAL)) {
            int offset = 0;
            if (opString.endsWith(LITERAL)) {
                offset = 1;
            }
            op = new LiteralOperator(opString.substring(1, opString.length() - offset));
        } else if (opString.startsWith(MARSHAL)) {
            int offset = 0;
            if (opString.endsWith(MARSHAL)) {
                offset = 1;
            }
            op = new MarshallerOperator(this.valueHelper, opString.substring(1, opString.length() - offset));
        } else {
            op = super.createOperator(opString);
        }
        return op;
    }

    @Override
    protected Operator makeOperatorFor(String label) {
        if (label == null || label.isEmpty()) {
            return null;
        }
        Operator op = null;
        if (label.startsWith("{")) {
            op = new PropertyValueOperator(this.valueHelper, label.substring(1, label.length() - 1));
        }
        if (op == null) {
            op = this.numFactory.createOperator(label);
        }
        return op;
    }

    public void setContext(TriggerActivationContext context) {
        this.valueHelper.get().setContext(context);
    }
}

