/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.action;

import au.com.ordermate.operator.Operator;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import ordermate.database.Sequenced;
import ordermate.database.integration.webservice.WebserviceIntegrationConfig;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.action.ActionPushType;
import ordermate.database.misc.action.ActionTriggerLink;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_action")
@DiscriminatorColumn(name="action_type")
public abstract class ConfigAction
extends PersistentObject
implements TriggerActivated,
Saveable {
    public static final Props Properties = new Props();
    private String url;
    private String label;
    private TriggerActivationStrategy triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    private PersistentWriteableList<ActionTriggerLink> triggerLinks;
    private int sequence;
    private ActionPushType pushType;
    private Reference<WebserviceIntegrationConfig> webConfig;
    private String payload;
    private transient List<AbstractTrigger> triggerList;
    private transient List<List<Operator>> payloadOps;

    @Deprecated
    public ConfigAction() {
        this.triggerLinks = this.createWriteableList(ConfigAction.Properties.TRIGGER_LINKS);
        this.pushType = ActionPushType.PostQuery;
        this.webConfig = this.createReference(ConfigAction.Properties.WEB_CONFIG);
    }

    public ConfigAction(String label) {
        this.triggerLinks = this.createWriteableList(ConfigAction.Properties.TRIGGER_LINKS);
        this.pushType = ActionPushType.PostQuery;
        this.webConfig = this.createReference(ConfigAction.Properties.WEB_CONFIG);
        this.label = label;
        this.setWebConfig(new WebserviceIntegrationConfig());
        this.addTrigger(DefaultTrigger.getDefaultTriggerIfExists());
    }

    @Override
    @Column(name="sequence")
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int value) {
        this.sequence = value;
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        if (o instanceof Sequenced) {
            return ((Sequenced)o).getSequence() - this.getSequence();
        }
        return 0;
    }

    @Override
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.EnumMapping", parameters={@Parameter(name="enumClass", value="ordermate.database.inventory.triggers.activation.TriggerActivationStrategy")})
    @Column(name="trigger_activation")
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy value) {
        if (value != null) {
            this.triggerActivationStrategy = value;
        }
    }

    @Override
    @Transient
    public boolean isActive(TriggerActivationContext context) {
        return this.getTriggerActivationStrategy().isActive(this, context);
    }

    @OneToMany(mappedBy="configAction", targetEntity=ActionTriggerLink.class)
    public List<ActionTriggerLink> getTriggerLinks() {
        return this.triggerLinks;
    }

    protected void setTriggerLinks(List<ActionTriggerLink> values) {
        this.triggerLinks.set(values);
        this.triggerList = null;
    }

    @Override
    @Transient
    public List<AbstractTrigger> getTriggers() {
        if (this.triggerList == null) {
            ArrayList<AbstractTrigger> allTriggers = new ArrayList<AbstractTrigger>();
            for (ActionTriggerLink link : this.getTriggerLinks()) {
                allTriggers.add(link.getTrigger());
            }
            this.triggerList = Collections.unmodifiableList(allTriggers);
        }
        return Collections.unmodifiableList(this.triggerList);
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        ActionTriggerLink toRemove = null;
        for (ActionTriggerLink link : this.triggerLinks) {
            if (!trigger.equals(link.getTrigger())) continue;
            toRemove = link;
        }
        this.triggerList = null;
        return this.triggerLinks.remove(toRemove);
    }

    @Override
    public ActionTriggerLink addTrigger(AbstractTrigger trigger) {
        if (trigger != null) {
            ActionTriggerLink link = new ActionTriggerLink();
            link.setConfigAction(this);
            link.setTrigger(trigger);
            this.triggerLinks.add(link);
            this.triggerList = null;
            return link;
        }
        return null;
    }

    @Override
    public void prepareForSave(SaveContext context) {
        if (this.webConfig.isNull()) {
            this.setWebConfig(new WebserviceIntegrationConfig());
        }
    }

    @Override
    public void save() {
        this.webConfig.saveChild();
        PersistenceManager.save(this);
        this.triggerLinks.saveChild();
    }

    @Override
    public void delete() {
        this.triggerLinks.deleteChild();
        this.webConfig.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Transient
    public String getUrl() {
        return this.getWebConfig().getUrl();
    }

    public void setUrl(String value) {
        this.getWebConfig().setUrl(value);
    }

    @Column(name="payload")
    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String value) {
        this.payload = value;
    }

    @Column(name="push_type")
    @Enumerated(value=EnumType.STRING)
    public ActionPushType getPushType() {
        return this.pushType;
    }

    public void setPushType(ActionPushType value) {
        if (value != null) {
            this.pushType = value;
        }
    }

    @ManyToOne
    @JoinColumn(name="fk_config_integration_webservice")
    public WebserviceIntegrationConfig getWebConfig() {
        return this.webConfig.get();
    }

    public void setWebConfig(WebserviceIntegrationConfig config) {
        this.webConfig.set(config);
    }

    @Override
    public String toString() {
        String value = this.getLabel();
        return value == null ? "<No Label>" : value;
    }

    @Transient
    public List<List<Operator>> getPayloadOperators() {
        return this.payloadOps;
    }

    public void setPayloadOperators(List<List<Operator>> ops) {
        this.payloadOps = ops;
    }

    public static class Props
    extends PersistentObject.Props {
        public PersistentObject.DerivedProperty<String> URL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ConfigAction.class), "url");
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<ActionTriggerLink> TRIGGER_LINKS;
        public PropertiedObject.Property<ActionPushType> PUSH_TYPE;
        public PropertiedObject.Property<String> PAYLOAD;
        public PropertiedObject.Property<WebserviceIntegrationConfig> WEB_CONFIG;
    }
}

