/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.colour;

import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.persistence.cache.LocalCachedReference;
import au.com.ordermate.persistence.reference.QueryReference;
import java.awt.Color;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import ordermate.database.misc.colour.ConfigColorSet;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Type;

@Entity
@Table(name="config_colour")
@AccessType(value="property")
public class ConfigColor
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private Color color;
    private String keyName;
    private Reference<ConfigColorSet> colorSet;

    public static ConfigColor getConfigColor(String name) {
        return PersistenceManager.getObject(ConfigColor.class, Query.select(ConfigColor.class).equals(ConfigColor.Properties.KEY_NAME, name).toString(), null);
    }

    public static Color getAssignedColor(String name) {
        ConfigColor color = ConfigColor.getConfigColor(name);
        if (color != null) {
            return color.getColor();
        }
        return null;
    }

    public static LocalCachedReference createLocalCachedReference(String name) {
        return new LocalCachedReference<ConfigColor>(new QueryReference<ConfigColor>(ConfigColor.class, Query.select(ConfigColor.class).equals(ConfigColor.Properties.KEY_NAME, name)));
    }

    public ConfigColor() {
        this.colorSet = this.createReference(ConfigColor.Properties.COLOR_SET);
    }

    @Column(name="colour")
    @Type(type="au.com.ordermate.persistence.hibernate.mapping.ColorMapping")
    public Color getColor() {
        return this.color;
    }

    public void setColor(Color value) {
        this.color = value;
    }

    public void setKeyName(String value) {
        this.keyName = value;
    }

    @Column(name="key_name")
    public String getKeyName() {
        return this.keyName;
    }

    public void setColorSet(ConfigColorSet value) {
        this.colorSet.set(value);
    }

    @ManyToOne
    @JoinColumn(name="FK_config_colour_set")
    public ConfigColorSet getColorSet() {
        return this.colorSet.get();
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property KEY_NAME;
        public PropertiedObject.Property COLOR_SET;
        public PropertiedObject.Property COLOR;
    }
}

