/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.customerdisplay;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.customerdisplay.CustomerDisplayMessage;
import ordermate.database.misc.customerdisplay.CustomerDisplayMessageType;
import ordermate.database.misc.customerdisplay.CustomerDisplayType;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.misc.resource.ConfigResourceType;

public abstract class AbstractCustomerDisplay
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    public static final String MAIN_BACKGROUND = "Main Background";
    public static final String MESSAGE_BACKGROUND = "Message Background";
    private static final String ADVERT = "-Advertising";
    private static final String BANNER = "-Banner";
    private static final String ORDER = "-Order";
    private Reference<Terminal> terminal;
    private SystemState systemState;
    private int bannerHeight;
    private int messageHeight;
    private int orderWidth;
    private int defaultDevice;
    private Reference<ConfigResourceSet> resourceSet;
    boolean bannerVisible;
    boolean messageVisible;
    private Reference<FontAttributes> messageAttributes;
    private PersistentWriteableList<CustomerDisplayMessage> messages;
    private transient CustomerDisplayMessage standbyMessage;
    private transient CustomerDisplayMessage welcomeMessage;
    private transient CustomerDisplayMessage farewellMessage;
    private transient String cachedLabel;

    public AbstractCustomerDisplay() {
        this.terminal = this.createReference(AbstractCustomerDisplay.Properties.TERMINAL);
        this.resourceSet = this.createReference(AbstractCustomerDisplay.Properties.RESOURCE_SET);
        this.bannerVisible = false;
        this.messageVisible = false;
        this.messageAttributes = this.createReference(AbstractCustomerDisplay.Properties.MESSAGE_ATTRIBUTES);
        this.messages = (PersistentWriteableList)this.createList(AbstractCustomerDisplay.Properties.MESSAGES);
    }

    public AbstractCustomerDisplay(Terminal theTerminal) {
        this.terminal = this.createReference(AbstractCustomerDisplay.Properties.TERMINAL);
        this.resourceSet = this.createReference(AbstractCustomerDisplay.Properties.RESOURCE_SET);
        this.bannerVisible = false;
        this.messageVisible = false;
        this.messageAttributes = this.createReference(AbstractCustomerDisplay.Properties.MESSAGE_ATTRIBUTES);
        this.messages = (PersistentWriteableList)this.createList(AbstractCustomerDisplay.Properties.MESSAGES);
        this.systemState = SystemState.ACTIVE_STATE;
        this.setTerminal(theTerminal);
        this.bannerHeight = 100;
        this.orderWidth = 500;
        this.messageHeight = 100;
        this.setMessageAttributes(new FontAttributes());
        this.getResourceSet();
        this.standbyMessage = new CustomerDisplayMessage(this, CustomerDisplayMessageType.Standby);
        this.standbyMessage.setMessage("Welcome to " + BusinessInfo.getInstance().getName());
        this.welcomeMessage = new CustomerDisplayMessage(this, CustomerDisplayMessageType.Welcome);
        this.welcomeMessage.setMessage("Hi, my name is !USER, welcome to " + BusinessInfo.getInstance().getName());
        this.farewellMessage = new CustomerDisplayMessage(this, CustomerDisplayMessageType.Farewell);
        this.farewellMessage.setMessage("Thank you for your patronage at " + BusinessInfo.getInstance().getName());
        this.defaultDevice = 1;
        this.addMessage(this.welcomeMessage);
        this.addMessage(this.farewellMessage);
        this.addMessage(this.standbyMessage);
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState value) {
        this.systemState = value;
    }

    public int getDefaultDevice() {
        return this.defaultDevice;
    }

    public void setDefaultDevice(int value) {
        this.defaultDevice = value;
    }

    public Terminal getTerminal() {
        return this.terminal.get();
    }

    protected void setTerminal(Terminal value) {
        if (this.terminal.get() != null && !this.terminal.get().equals(value)) {
            throw new IllegalArgumentException("The Customer Display is defined for a single terminal, one to one, we cannot redefine it.");
        }
        this.terminal.set(value);
    }

    public int getOrderWidth() {
        return this.orderWidth;
    }

    public void setOrderWidth(int value) {
        this.orderWidth = value;
    }

    public int getMessageHeight() {
        return this.messageHeight;
    }

    public void setMessageHeight(int value) {
        this.messageHeight = value;
    }

    public ConfigResourceSet getResourceSet() {
        if (this.resourceSet.get() == null) {
            this.createResourceSet();
        }
        return this.resourceSet.get();
    }

    protected void createResourceSet() {
        ConfigResourceSet mainSet = new ConfigResourceSet(this.getTerminal().getName() + " Display", null);
        mainSet.addResource(new ConfigResource(MESSAGE_BACKGROUND, ConfigResourceType.IMAGE));
        mainSet.addResource(new ConfigResource(MAIN_BACKGROUND, ConfigResourceType.IMAGE));
        new ConfigResourceSet(this.getTerminal().getName() + ADVERT, mainSet);
        new ConfigResourceSet(this.getTerminal().getName() + BANNER, mainSet);
        new ConfigResourceSet(this.getTerminal().getName() + ORDER, mainSet);
        this.setResourceSet(mainSet);
    }

    protected void setResourceSet(ConfigResourceSet value) {
        this.resourceSet.set(value);
    }

    public int getBannerHeight() {
        return this.bannerHeight;
    }

    public void setBannerHeight(int value) {
        this.bannerHeight = value;
    }

    public String getLabel() {
        if (this.cachedLabel == null) {
            StringBuilder SB = new StringBuilder(this.terminal.get().getLabel());
            SB.append(" ").append(this.getDisplayType().getLabel());
        }
        return this.cachedLabel;
    }

    public List<CustomerDisplayMessage> getMessages() {
        return this.messages;
    }

    protected void setMessages(List<CustomerDisplayMessage> value) {
        this.messages.set(value);
    }

    public void addMessage(CustomerDisplayMessage theMessage) {
        if (theMessage.getCustomerDisplay() != this) {
            throw new IllegalArgumentException("Cannot add another's message to myself.");
        }
        this.messages.add(theMessage);
    }

    public void removeMessage(CustomerDisplayMessage theMessage) {
        if (theMessage != null && CustomerDisplayMessageType.Custom.equals((Object)theMessage.getMessageType())) {
            this.messages.remove(theMessage);
            theMessage.deleteChild();
        }
    }

    public CustomerDisplayMessage getStandbyMessage() {
        if (this.standbyMessage == null) {
            this.standbyMessage = this.findMessage(CustomerDisplayMessageType.Standby);
        }
        return this.standbyMessage;
    }

    public CustomerDisplayMessage getWelcomeMessage() {
        if (this.welcomeMessage == null) {
            this.welcomeMessage = this.findMessage(CustomerDisplayMessageType.Welcome);
        }
        return this.welcomeMessage;
    }

    public CustomerDisplayMessage getFarewellMessage() {
        if (this.farewellMessage == null) {
            this.farewellMessage = this.findMessage(CustomerDisplayMessageType.Farewell);
        }
        return this.farewellMessage;
    }

    protected CustomerDisplayMessage findMessage(CustomerDisplayMessageType type) {
        for (CustomerDisplayMessage message : this.messages) {
            if (!type.equals((Object)message.getMessageType())) continue;
            return message;
        }
        CustomerDisplayMessage message = new CustomerDisplayMessage(this, type);
        this.addMessage(message);
        return message;
    }

    public List<CustomerDisplayMessage> getCustomMessages() {
        ArrayList<CustomerDisplayMessage> normalList = new ArrayList<CustomerDisplayMessage>();
        for (CustomerDisplayMessage message : this.messages) {
            if (!CustomerDisplayMessageType.Custom.equals((Object)message.getMessageType())) continue;
            normalList.add(message);
        }
        return normalList;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        this.resourceSet.saveChild();
        this.messageAttributes.saveChild();
        PersistenceManager.save(this);
        this.messages.saveChild();
    }

    @Override
    public void delete() {
        this.resourceSet.deleteChild();
        this.messageAttributes.deleteChild();
        this.messages.deleteChild();
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public ConfigResourceSet getAdvertisementSet() {
        return this.findConfigResourceSet(ADVERT);
    }

    public ConfigResourceSet getBannerSet() {
        return this.findConfigResourceSet(BANNER);
    }

    public ConfigResourceSet getOrderSet() {
        return this.findConfigResourceSet(ORDER);
    }

    public FontAttributes getMessageAttributes() {
        return this.messageAttributes.get();
    }

    public void setMessageAttributes(FontAttributes value) {
        this.messageAttributes.set(value);
    }

    protected ConfigResourceSet findConfigResourceSet(String name) {
        for (ConfigResourceSet set : this.getResourceSet().getChildren()) {
            if (!set.getLabel().endsWith(name)) continue;
            return set;
        }
        return new ConfigResourceSet(this.getTerminal().getLabel() + name, this.getResourceSet());
    }

    public abstract CustomerDisplayType getDisplayType();

    public List<PropertiedObject.Property<FontAttributes>> getFontProperties() {
        ArrayList<PropertiedObject.Property<FontAttributes>> fontList = new ArrayList<PropertiedObject.Property<FontAttributes>>();
        fontList.add(AbstractCustomerDisplay.Properties.MESSAGE_ATTRIBUTES);
        return fontList;
    }

    public boolean isMessageVisible() {
        return this.messageVisible;
    }

    public boolean isBannerVisible() {
        return this.bannerVisible;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<Terminal> TERMINAL;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property BANNER_HEIGHT;
        public PropertiedObject.Property MESSAGE_HEIGHT;
        public PropertiedObject.Property ORDER_WIDTH;
        public PropertiedObject.Property<ConfigResourceSet> RESOURCE_SET;
        public PersistentObject.DerivedProperty<String> LABEL = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AbstractCustomerDisplay.class), "label");
        public PropertiedObject.Property<CustomerDisplayMessage> MESSAGES;
        public PropertiedObject.Property<FontAttributes> MESSAGE_ATTRIBUTES;
        public PropertiedObject.Property DEFAULT_DEVICE;
        public PersistentObject.DerivedProperty<CustomerDisplayType> DISPLAY_TYPE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AbstractCustomerDisplay.class), "displayType");
        public PersistentObject.DerivedProperty<CustomerDisplayMessage> STANDBY_MESSAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AbstractCustomerDisplay.class), "standbyMessage");
        public PersistentObject.DerivedProperty<CustomerDisplayMessage> WELCOME_MESSAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AbstractCustomerDisplay.class), "welcomeMessage");
        public PersistentObject.DerivedProperty<CustomerDisplayMessage> FAREWELL_MESSAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)AbstractCustomerDisplay.class), "farewellMessage");
    }
}

