/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.customerdisplay;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.SaveableChild;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.CustomerDisplayMessageType;
import ordermate.database.sales.Customer;
import ordermate.database.users.User;

public class CustomerDisplayMessage
extends PersistentObject
implements SaveableChild {
    public static final Props Properties = new Props();
    public static final String USER_FLAG = "!USER";
    public static final String CUSTOMER_FLAG = "!CUST";
    private Reference<AbstractCustomerDisplay> customerDisplay;
    private String message;
    private CustomerDisplayMessageType messageType;

    public CustomerDisplayMessage() {
        this.customerDisplay = this.createReference(CustomerDisplayMessage.Properties.CUSTOMER_DISPLAY);
    }

    public CustomerDisplayMessage(AbstractCustomerDisplay display, CustomerDisplayMessageType theType) {
        this.customerDisplay = this.createReference(CustomerDisplayMessage.Properties.CUSTOMER_DISPLAY);
        this.setCustomerDisplay(display);
        this.message = "<No Message>";
        this.messageType = theType;
        if (this.messageType == null) {
            this.messageType = CustomerDisplayMessageType.Custom;
        }
    }

    public AbstractCustomerDisplay getCustomerDisplay() {
        return this.customerDisplay.get();
    }

    protected void setCustomerDisplay(AbstractCustomerDisplay value) {
        this.customerDisplay.set(value);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String value) {
        if (this.message == null) {
            this.message = "";
        }
        this.message = value;
    }

    public CustomerDisplayMessageType getMessageType() {
        return this.messageType;
    }

    protected void setMessageType(CustomerDisplayMessageType newType) {
        this.messageType = newType;
    }

    public String getContextualMessage(User user, Customer customer) {
        String newMessage = this.message;
        if (user != null && user.getFirstName() != null) {
            newMessage = newMessage.replace(USER_FLAG, user.getFirstName().trim());
        }
        String repCustomer = "";
        if (customer != null && customer.getFirstName() != null) {
            repCustomer = customer.getFirstName().trim();
        }
        newMessage = newMessage.replace(CUSTOMER_FLAG, repCustomer);
        return newMessage;
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void saveChild() {
        PersistenceManager.saveChild(this);
    }

    @Override
    public void deleteChild() {
        PersistenceManager.deleteChild(this);
    }

    @Override
    public boolean hasChildChanged() {
        return PersistenceManager.hasChildChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<AbstractCustomerDisplay> CUSTOMER_DISPLAY;
        public PropertiedObject.Property<String> MESSAGE;
        public PropertiedObject.Property<CustomerDisplayMessageType> MESSAGE_TYPE;
    }
}

