/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.customerdisplay;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.CustomerDisplayType;
import ordermate.database.misc.resource.ConfigResource;
import ordermate.database.misc.resource.ConfigResourceSet;
import ordermate.database.misc.resource.ConfigResourceType;

public class OrderCustomerDisplay
extends AbstractCustomerDisplay {
    public static final String HEADER_BACKGROUND = "Header Background";
    public static final String ORDER_BACKGROUND = "Order Background";
    public static final String TOTAL_BACKGROUND = "Total Background";
    public static final Props Properties = new Props();
    private Reference<FontAttributes> headerAttributes;
    private Reference<FontAttributes> footerAttributes;
    private Reference<FontAttributes> lineAttributes;
    private Reference<FontAttributes> optionAttributes;
    private Reference<FontAttributes> plusAttributes;
    private Reference<FontAttributes> minusAttributes;
    private int orderHeaderHeight;
    private int orderTotalHeight;

    public OrderCustomerDisplay() {
        this.headerAttributes = this.createReference(OrderCustomerDisplay.Properties.HEADER_ATTRIBUTES);
        this.footerAttributes = this.createReference(OrderCustomerDisplay.Properties.FOOTER_ATTRIBUTES);
        this.lineAttributes = this.createReference(OrderCustomerDisplay.Properties.LINE_ATTRIBUTES);
        this.optionAttributes = this.createReference(OrderCustomerDisplay.Properties.OPTION_ATTRIBUTES);
        this.plusAttributes = this.createReference(OrderCustomerDisplay.Properties.PLUS_ATTRIBUTES);
        this.minusAttributes = this.createReference(OrderCustomerDisplay.Properties.MINUS_ATTRIBUTES);
        this.orderHeaderHeight = 80;
        this.orderTotalHeight = 150;
    }

    public OrderCustomerDisplay(Terminal theTerminal) {
        super(theTerminal);
        this.headerAttributes = this.createReference(OrderCustomerDisplay.Properties.HEADER_ATTRIBUTES);
        this.footerAttributes = this.createReference(OrderCustomerDisplay.Properties.FOOTER_ATTRIBUTES);
        this.lineAttributes = this.createReference(OrderCustomerDisplay.Properties.LINE_ATTRIBUTES);
        this.optionAttributes = this.createReference(OrderCustomerDisplay.Properties.OPTION_ATTRIBUTES);
        this.plusAttributes = this.createReference(OrderCustomerDisplay.Properties.PLUS_ATTRIBUTES);
        this.minusAttributes = this.createReference(OrderCustomerDisplay.Properties.MINUS_ATTRIBUTES);
        this.orderHeaderHeight = 80;
        this.orderTotalHeight = 150;
        this.setHeaderAttributes(new FontAttributes());
        this.setLineAttributes(new FontAttributes());
        this.setOptionAttributes(new FontAttributes());
        this.setPlusAttributes(new FontAttributes());
        this.setMinusAttributes(new FontAttributes());
        this.setFooterAttributes(new FontAttributes());
    }

    public FontAttributes getHeaderAttributes() {
        return this.headerAttributes.get();
    }

    public void setHeaderAttributes(FontAttributes value) {
        this.headerAttributes.set(value);
    }

    public FontAttributes getLineAttributes() {
        return this.lineAttributes.get();
    }

    public void setLineAttributes(FontAttributes value) {
        this.lineAttributes.set(value);
    }

    public FontAttributes getOptionAttributes() {
        return this.optionAttributes.get();
    }

    public void setOptionAttributes(FontAttributes value) {
        this.optionAttributes.set(value);
    }

    public FontAttributes getPlusAttributes() {
        return this.plusAttributes.get();
    }

    public void setPlusAttributes(FontAttributes value) {
        this.plusAttributes.set(value);
    }

    public FontAttributes getMinusAttributes() {
        return this.minusAttributes.get();
    }

    public void setMinusAttributes(FontAttributes value) {
        this.minusAttributes.set(value);
    }

    public FontAttributes getFooterAttributes() {
        return this.footerAttributes.get();
    }

    public void setFooterAttributes(FontAttributes value) {
        this.footerAttributes.set(value);
    }

    @Override
    public void save() {
        this.headerAttributes.saveChild();
        this.lineAttributes.saveChild();
        this.optionAttributes.saveChild();
        this.plusAttributes.saveChild();
        this.minusAttributes.saveChild();
        this.footerAttributes.saveChild();
        super.save();
    }

    @Override
    public void delete() {
        this.headerAttributes.deleteChild();
        this.lineAttributes.deleteChild();
        this.optionAttributes.deleteChild();
        this.plusAttributes.deleteChild();
        this.minusAttributes.deleteChild();
        this.footerAttributes.deleteChild();
        super.delete();
    }

    @Override
    protected void createResourceSet() {
        super.createResourceSet();
        ConfigResourceSet mainSet = this.getResourceSet();
        mainSet.addResource(new ConfigResource(ORDER_BACKGROUND, ConfigResourceType.IMAGE));
        mainSet.addResource(new ConfigResource(HEADER_BACKGROUND, ConfigResourceType.IMAGE));
        mainSet.addResource(new ConfigResource(TOTAL_BACKGROUND, ConfigResourceType.IMAGE));
    }

    @Override
    public CustomerDisplayType getDisplayType() {
        return CustomerDisplayType.Order;
    }

    @Override
    public List<PropertiedObject.Property<FontAttributes>> getFontProperties() {
        List<PropertiedObject.Property<FontAttributes>> list = super.getFontProperties();
        list.add(OrderCustomerDisplay.Properties.HEADER_ATTRIBUTES);
        list.add(OrderCustomerDisplay.Properties.FOOTER_ATTRIBUTES);
        list.add(OrderCustomerDisplay.Properties.LINE_ATTRIBUTES);
        list.add(OrderCustomerDisplay.Properties.OPTION_ATTRIBUTES);
        list.add(OrderCustomerDisplay.Properties.PLUS_ATTRIBUTES);
        list.add(OrderCustomerDisplay.Properties.MINUS_ATTRIBUTES);
        return list;
    }

    public int getOrderHeaderHeight() {
        return this.orderHeaderHeight;
    }

    public int getOrderTotalHeight() {
        return this.orderTotalHeight;
    }

    public static class Props
    extends AbstractCustomerDisplay.Props {
        public PropertiedObject.Property<FontAttributes> HEADER_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> LINE_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> OPTION_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> PLUS_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> MINUS_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> FOOTER_ATTRIBUTES;
    }
}

