/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.customerdisplay;

import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import java.util.List;
import ordermate.database.feedback.FeedbackQuestion;
import ordermate.database.gui.FontAttributes;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.customerdisplay.AbstractCustomerDisplay;
import ordermate.database.misc.customerdisplay.CustomerDisplayType;

public class QAndACustomerDisplay
extends AbstractCustomerDisplay {
    public static final Props Properties = new Props();
    private Reference<FeedbackQuestion> mainQuestion;
    private Reference<FontAttributes> questionAttributes;
    private Reference<FontAttributes> answerAttributes;
    private Reference<FontAttributes> ackAttributes;
    private int topPanelHeight;

    public QAndACustomerDisplay() {
        this.mainQuestion = this.createReference(QAndACustomerDisplay.Properties.MAIN_QUESTION);
        this.questionAttributes = this.createReference(QAndACustomerDisplay.Properties.QUESTION_ATTRIBUTES);
        this.answerAttributes = this.createReference(QAndACustomerDisplay.Properties.ANSWER_ATTRIBUTES);
        this.ackAttributes = this.createReference(QAndACustomerDisplay.Properties.ACK_ATTRIBUTES);
        this.topPanelHeight = 160;
    }

    public QAndACustomerDisplay(Terminal terminal) {
        super(terminal);
        this.mainQuestion = this.createReference(QAndACustomerDisplay.Properties.MAIN_QUESTION);
        this.questionAttributes = this.createReference(QAndACustomerDisplay.Properties.QUESTION_ATTRIBUTES);
        this.answerAttributes = this.createReference(QAndACustomerDisplay.Properties.ANSWER_ATTRIBUTES);
        this.ackAttributes = this.createReference(QAndACustomerDisplay.Properties.ACK_ATTRIBUTES);
        this.topPanelHeight = 160;
        this.setQuestionAttributes(new FontAttributes());
        this.setAnswerAttributes(new FontAttributes());
        this.setAckAttributes(new FontAttributes());
    }

    @Override
    public CustomerDisplayType getDisplayType() {
        return CustomerDisplayType.QAndA;
    }

    public FeedbackQuestion getMainQuestion() {
        return this.mainQuestion.get();
    }

    public void setMainQuestion(FeedbackQuestion value) {
        this.mainQuestion.set(value);
    }

    public FontAttributes getQuestionAttributes() {
        return this.questionAttributes.get();
    }

    public void setQuestionAttributes(FontAttributes value) {
        this.questionAttributes.set(value);
    }

    public FontAttributes getAnswerAttributes() {
        return this.answerAttributes.get();
    }

    public void setAnswerAttributes(FontAttributes value) {
        this.answerAttributes.set(value);
    }

    public FontAttributes getAckAttributes() {
        return this.ackAttributes.get();
    }

    public void setAckAttributes(FontAttributes value) {
        this.ackAttributes.set(value);
    }

    @Override
    public void save() {
        this.questionAttributes.saveChild();
        this.answerAttributes.saveChild();
        this.ackAttributes.saveChild();
        super.save();
    }

    @Override
    public void delete() {
        this.questionAttributes.deleteChild();
        this.answerAttributes.deleteChild();
        this.ackAttributes.deleteChild();
        super.delete();
    }

    @Override
    public List<PropertiedObject.Property<FontAttributes>> getFontProperties() {
        List<PropertiedObject.Property<FontAttributes>> fontList = super.getFontProperties();
        fontList.add(QAndACustomerDisplay.Properties.QUESTION_ATTRIBUTES);
        fontList.add(QAndACustomerDisplay.Properties.ANSWER_ATTRIBUTES);
        fontList.add(QAndACustomerDisplay.Properties.ACK_ATTRIBUTES);
        return fontList;
    }

    public int getQuestionPanelHeight() {
        return this.topPanelHeight;
    }

    public static class Props
    extends AbstractCustomerDisplay.Props {
        public PropertiedObject.Property<FeedbackQuestion> MAIN_QUESTION;
        public PropertiedObject.Property<FontAttributes> QUESTION_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> ANSWER_ATTRIBUTES;
        public PropertiedObject.Property<FontAttributes> ACK_ATTRIBUTES;
    }
}

