/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.license;

import java.io.Serializable;
import ordermate.database.misc.license.LicenseType;
import ordermate.encryption.SHA1;

public interface License {
    public int getLicenseValue(LicenseType var1);

    public void setLicenseValue(LicenseType var1, int var2);

    public boolean getBoolean(LicenseType var1);

    public String generateLicenseKey(String var1);

    public boolean isValid(String var1, String var2);

    public String getAbn();

    public void setAbn(String var1);

    public String getTestValuesToAppendForLicense();

    public static class LicenseHelper
    implements Serializable {
        private License license;

        public LicenseHelper(License theLicense) {
            this.license = theLicense;
        }

        public String toString() {
            StringBuilder SB = new StringBuilder();
            for (LicenseType type : LicenseType.values()) {
                SB.append(type.getDescription()).append(" : ").append(this.license.getLicenseValue(type));
                SB.append(",\n");
            }
            return SB.toString();
        }

        public String generateLicenseKey(String macAddress) {
            return this.createSHA1(macAddress).toString();
        }

        public boolean isValid(String validHash, String macAddress) {
            return this.license.generateLicenseKey(macAddress).equalsIgnoreCase(validHash);
        }

        private SHA1 createSHA1(String macAddress) {
            String start = "clintonsmumcouldhavecodedthisfaster";
            StringBuilder data = new StringBuilder("clintonsmumcouldhavecodedthisfaster".substring(5, 19));
            data.append(macAddress.toUpperCase());
            data.append(this.license.getAbn());
            for (LicenseType type : LicenseType.values()) {
                this.addStringValue(data, type);
            }
            data.append(this.license.getTestValuesToAppendForLicense());
            SHA1 sha = new SHA1();
            sha.update(data.toString().getBytes(), 0, data.length());
            sha.finalize();
            return sha;
        }

        private void addStringValue(StringBuilder SB, LicenseType type) {
            int value = this.license.getLicenseValue(type);
            if (value > 0) {
                SB.append(type.name()).append(":").append(value);
            }
        }
    }
}

