/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.license;

import au.com.ordermate.persistence.Executable;
import au.com.ordermate.util.MACAddress;
import au.com.ordermate.util.StringUtils;
import java.sql.Connection;
import java.util.List;
import ordermate.OrderMate;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicenseManager;
import ordermate.dbconnection.DatabaseControl;
import ordermate.security.impl.SecurityManager;
import ordermate.security.impl.db.DBSecurityDetails;

public final class LicenseChanger
extends Executable {
    private final int status;
    private final LicenseType licenseType;

    public LicenseChanger(LicenseType licenseType, int status) {
        this.status = status;
        this.licenseType = licenseType;
    }

    public Object execute() {
        try {
            if (PersistentLicenseManager.getInstance().isValid(SecurityManager.getSecurityDetails().getLicenseHash(), SecurityManager.getSecurityDetails().getRecordedMacAddress())) {
                PersistentLicenseManager.getInstance().setLicenseValue(this.licenseType, this.status);
                String address = SecurityManager.getSecurityDetails().getRecordedMacAddress();
                List<String> addresses = MACAddress.getMacAddress();
                boolean found = false;
                if (address != null) {
                    for (String nextAddress : addresses) {
                        if (!address.equalsIgnoreCase(nextAddress)) continue;
                        found = true;
                        break;
                    }
                }
                if (!found) {
                    for (String nextAddress : addresses) {
                        if (!LicenseChanger.isRealAddress(nextAddress)) continue;
                        address = nextAddress;
                        break;
                    }
                }
                if (address == null) {
                    OrderMate.LOG.error("Cannot update the license, no valid MAC Address found.");
                    return null;
                }
                OrderMate.LOG.info("Updating license with Mac Address:" + address);
                String licenseKey = PersistentLicenseManager.getInstance().generateLicenseKey(address);
                DatabaseControl dc = new DatabaseControl(true);
                Connection connection = dc.getDBConnection();
                DBSecurityDetails details = new DBSecurityDetails();
                details.setLicenseHash(licenseKey);
                connection.close();
                PersistentLicenseManager.getInstance().save();
            } else {
                OrderMate.LOG.error("Request to update licence cannot be performed, current license is invalid.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static boolean isRealAddress(String macAddress) {
        return !StringUtils.isEmpty(macAddress) && !macAddress.startsWith("0000");
    }
}

