/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.license;

import au.com.ordermate.configuration.Config;
import au.com.ordermate.oquery.Query;
import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Transient;
import ordermate.OrderMate;
import ordermate.database.hardware.Terminal;
import ordermate.database.misc.BusinessInfo;
import ordermate.database.misc.license.License;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.license.PersistentLicense;
import ordermate.integration.PropertyIntegrator;
import ordermate.integration.property.RMSIntegrator;
import ordermate.integration.respak.RespakIntegrator;
import ordermate.security.Security;
import ordermate.security.SecurityService;

public class PersistentLicenseManager
implements License,
Saveable {
    private static final PersistentLicenseManager instance = new PersistentLicenseManager();
    private List<PersistentLicense> allLicenses = new ArrayList<PersistentLicense>();
    private License.LicenseHelper licenseHelper = new License.LicenseHelper(this);

    private PersistentLicenseManager() {
        this.getAllLicenses();
    }

    public static PersistentLicenseManager getInstance() {
        return instance;
    }

    @Transient
    public List<PersistentLicense> getAllLicenses() {
        if (this.allLicenses == null || this.allLicenses.isEmpty()) {
            this.updateLicenses();
        }
        return Collections.unmodifiableList(this.allLicenses);
    }

    @Transient
    public synchronized void refreshCachedLicenses() {
        OrderMate.LOG.info("PersistenceLicenseManager::refreshCachedLicenses ::  Clearing the cached licenses");
        this.allLicenses = null;
        this.updateLicenses();
    }

    synchronized void updateLicenses() {
        this.allLicenses = PersistenceManager.getObjectList(PersistentLicense.class, Query.select(PersistentLicense.class).toString());
    }

    protected PersistentLicense getLicenseFor(LicenseType type) {
        PersistentLicense license = this.getPersistenceLicense(type);
        if (license == null) {
            String error = "There is no valid License for '" + type.getDescription() + "' persistent! Please add this type via a proper OrderMate update level...";
            OrderMate.LOG.error(error);
            throw new IllegalArgumentException(error);
        }
        return license;
    }

    private PersistentLicense getPersistenceLicense(LicenseType type) {
        List<PersistentLicense> licenses = this.getAllLicenses();
        for (PersistentLicense license : licenses) {
            if (!license.getLicenseType().equals((Object)type)) continue;
            return license;
        }
        return null;
    }

    public void copy(License licenseToCopy, String hash, String macAddress) {
        if (!licenseToCopy.isValid(hash, macAddress)) {
            throw new IllegalArgumentException("Cannot copy license that does not have valid hash.  Set the validity hash first then copy.");
        }
        this.setAbn(licenseToCopy.getAbn());
        for (LicenseType type : LicenseType.values()) {
            this.setLicenseValue(type, licenseToCopy.getLicenseValue(type));
        }
    }

    public boolean hasLicenseFor(PropertyIntegrator integrator) {
        if (integrator instanceof RMSIntegrator) {
            return this.getBoolean(LicenseType.RMSIntegrationEnabled);
        }
        if (integrator instanceof RespakIntegrator) {
            return this.getBoolean(LicenseType.ReservationIntegrationEnabled);
        }
        return true;
    }

    @Transient
    public SecurityService getSecurityService() {
        try {
            String server = Config.getStringValue("app_server");
            InetAddress address = InetAddress.getByName(server);
            return Security.getSecurityService(address);
        }
        catch (Exception e) {
            String server = Config.getStringValue("app_server");
            OrderMate.LOG.error("Could not obtain SecurityService from app server at " + server, (Throwable)e);
            return null;
        }
    }

    public boolean isDeliveryModeAvailable(Terminal terminal) {
        return true;
    }

    @Override
    public String generateLicenseKey(String macAddress) {
        return this.licenseHelper.generateLicenseKey(macAddress);
    }

    public String toString() {
        return this.licenseHelper.toString();
    }

    @Override
    public boolean isValid(String validHash, String macAddress) {
        return this.generateLicenseKey(macAddress).equalsIgnoreCase(validHash);
    }

    @Override
    @Transient
    public String getAbn() {
        return BusinessInfo.getInstance().getAbn();
    }

    @Override
    public void setAbn(String string) {
    }

    @Override
    public String getTestValuesToAppendForLicense() {
        return "";
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        for (PersistentLicense lic : this.allLicenses) {
            lic.save();
        }
    }

    @Override
    public void delete() {
    }

    @Override
    public boolean hasChanged() {
        return true;
    }

    @Override
    public boolean getBoolean(LicenseType type) {
        int value = this.getLicenseValue(type);
        return value != 0;
    }

    @Override
    public int getLicenseValue(LicenseType type) {
        PersistentLicense license = this.getPersistenceLicense(type);
        return license != null ? license.getValue() : 0;
    }

    @Override
    public void setLicenseValue(LicenseType type, int value) {
        if (type == null) {
            throw new IllegalArgumentException("Cannot set a null license type");
        }
        PersistentLicense license = this.getPersistenceLicense(type);
        if (license == null) {
            OrderMate.LOG.warn("Cannot find license, making a new one for: " + (Object)((Object)type));
            license = new PersistentLicense(type);
            license.save();
            this.allLicenses.add(license);
        }
        license.setValue(value);
    }
}

