/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.licenseoption;

import java.util.HashMap;
import java.util.Map;
import ordermate.database.misc.license.LicenseType;
import ordermate.database.misc.licenseoption.AbstractOrderMatePosLicenseOption;
import ordermate.database.misc.licenseoption.OrderMatePosLicenseOption;

public class OrderMatePosLicenseOptionRegister {
    private Map<LicenseType, OrderMatePosLicenseOption> licenseMap;
    private static final OrderMatePosLicenseOptionRegister instance = new OrderMatePosLicenseOptionRegister();

    public static OrderMatePosLicenseOptionRegister getInstance() {
        return instance;
    }

    OrderMatePosLicenseOptionRegister() {
        this.createDefaultLicenses();
    }

    private void createDefaultLicenses() {
        this.licenseMap = new HashMap<LicenseType, OrderMatePosLicenseOption>();
        this.licenseMap.put(LicenseType.ServermateEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.ServermateEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.NumWaitermateTerminals, new AbstractOrderMatePosLicenseOption<Integer>(LicenseType.NumWaitermateTerminals.getDescription(), 0));
        this.licenseMap.put(LicenseType.StockControlEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.StockControlEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.NumHomeDelivery, new AbstractOrderMatePosLicenseOption<Integer>(LicenseType.NumHomeDelivery.getDescription(), 0));
        this.licenseMap.put(LicenseType.ReservationIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.ReservationIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.RMSIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.RMSIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.MYOBIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.MYOBIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.MelwaysMapsEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.MelwaysMapsEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.LiquorfileIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.LiquorfileIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.EftposIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.EftposIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.NumTouchPrepExpress, new AbstractOrderMatePosLicenseOption<Integer>(LicenseType.NumTouchPrepExpress.getDescription(), 0));
        this.licenseMap.put(LicenseType.NumCustomerDisplay, new AbstractOrderMatePosLicenseOption<Integer>(LicenseType.NumCustomerDisplay.getDescription(), 0));
        this.licenseMap.put(LicenseType.OnlineOrderingIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.OnlineOrderingIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.CustomerLoyaltyEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.CustomerLoyaltyEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.StockControlMultipleAreasEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.StockControlMultipleAreasEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.CouponsIntegrationEnabled, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.CouponsIntegrationEnabled.getDescription(), Boolean.FALSE));
        this.licenseMap.put(LicenseType.WRCustomerSales, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRCustomerSales.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRIntegratedPayment, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRIntegratedPayment.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WROnlineOrder, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WROnlineOrder.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRPayAtTable, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRPayAtTable.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRReporting, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRReporting.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRSalesByTime, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRSalesByTime.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRTimesheet, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRTimesheet.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRUser, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRUser.getDescription(), Boolean.TRUE));
        this.licenseMap.put(LicenseType.WRBarTabs, new AbstractOrderMatePosLicenseOption<Boolean>(LicenseType.WRBarTabs.getDescription(), Boolean.TRUE));
    }

    public OrderMatePosLicenseOption getOrderMatePosLicenseOption(LicenseType toObtainLicenseOptionsFor) {
        OrderMatePosLicenseOption toReturn = this.licenseMap.get((Object)toObtainLicenseOptionsFor);
        if (toReturn == null) {
            throw new IllegalStateException("LicenseType " + (Object)((Object)toObtainLicenseOptionsFor) + " has no known OrderMatePosLicenseOption!");
        }
        return toReturn;
    }
}

