/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.resource;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import java.util.List;
import ordermate.database.misc.resource.ConfigResource;

public class ConfigResourceSet
extends PersistentObject
implements Saveable {
    public static final Props Properties = new Props();
    private String label;
    private Reference<ConfigResourceSet> parent;
    private PersistentWriteableList<ConfigResourceSet> children;
    private PersistentWriteableList<ConfigResource> resources;

    public ConfigResourceSet() {
        this.parent = this.createReference(ConfigResourceSet.Properties.PARENT);
        this.children = this.createWriteableList(ConfigResourceSet.Properties.CHILDREN);
        this.resources = this.createWriteableList(ConfigResourceSet.Properties.RESOURCES);
    }

    public ConfigResourceSet(String theLabel, ConfigResourceSet yourParent) {
        this.parent = this.createReference(ConfigResourceSet.Properties.PARENT);
        this.children = this.createWriteableList(ConfigResourceSet.Properties.CHILDREN);
        this.resources = this.createWriteableList(ConfigResourceSet.Properties.RESOURCES);
        this.setLabel(theLabel);
        this.setParent(yourParent);
        if (yourParent != null) {
            yourParent.addChild(this);
        }
    }

    protected void addChild(ConfigResourceSet newChild) {
        if (!this.children.contains(newChild)) {
            this.children.add(newChild);
        }
    }

    protected void removeChild(ConfigResourceSet toRemove) {
        this.children.remove(toRemove);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
        if (this.label == null || this.label.trim().isEmpty()) {
            this.label = "<No Label>";
        }
    }

    public ConfigResourceSet getParent() {
        return this.parent.get();
    }

    protected void setParent(ConfigResourceSet resourceSet) {
        this.parent.set(resourceSet);
    }

    public List<ConfigResourceSet> getChildren() {
        return this.children.getUnmodifiable();
    }

    protected void setChildren(List<ConfigResourceSet> newChildren) {
        this.children.set(newChildren);
    }

    public List<ConfigResource> getResources() {
        return this.resources.getUnmodifiable();
    }

    public ConfigResource getResource(String name) {
        for (ConfigResource resource : this.resources) {
            if (!name.equals(resource.getLabel())) continue;
            return resource;
        }
        return null;
    }

    protected void setResources(List<ConfigResource> newResources) {
        this.resources.set(newResources);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
        this.children.saveChild();
        this.resources.saveChild();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        if (!this.parent.isNull() && this.parent.isExpanded()) {
            this.parent.get().removeChild(this);
        }
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public void addResource(ConfigResource configResource) {
        if (configResource == null) {
            throw new IllegalArgumentException("Cannot add a null resource to the set.");
        }
        if (!this.resources.contains(configResource)) {
            this.resources.add(configResource);
            configResource.setResourceSet(this);
        }
    }

    public void removeResource(ConfigResource toRemove) {
        if (toRemove != null) {
            this.resources.remove(toRemove);
            toRemove.setResourceSet(null);
        }
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<ConfigResourceSet> PARENT;
        public PropertiedObject.Property<ConfigResourceSet> CHILDREN;
        public PropertiedObject.Property<ConfigResource> RESOURCES;
    }
}

