/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.resource;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.image.ImageFormat;
import au.com.ordermate.util.image.ImageHelper;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@Table(name="config_image_small")
@AccessType(value="property")
@Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
public class ConfigSmallImage
extends PersistentObject
implements Saveable {
    public static final int SMALL_IMAGE_SIZE = 64000;
    public static final Props Properties = new Props();
    private String label;
    private ImageFormat format = ImageFormat.JPG;
    private String description;
    private long byteLength;
    private long imageWidth;
    private long imageHeight;
    private byte[] imageData;
    private transient BufferedImage image;

    @Deprecated
    public ConfigSmallImage() {
    }

    public ConfigSmallImage(ConfigSmallImage copy) {
        ArrayList toCopy = new ArrayList();
        Collections.addAll(toCopy, ConfigSmallImage.Properties.LABEL, ConfigSmallImage.Properties.FORMAT, ConfigSmallImage.Properties.DESCRIPTION);
        for (PropertiedObject.Property prop : toCopy) {
            this.setPropertyValue(prop, copy.getPropertyValue(prop));
        }
        this.setByteLength(copy.getByteLength());
        this.setImageWidth(copy.getImageWidth());
        this.setImageHeight(copy.getImageHeight());
        this.setImageData(copy.getImageData());
    }

    public ConfigSmallImage(String label) {
        this.label = label;
    }

    @Column(name="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String value) {
        this.label = value;
    }

    @Column(name="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String value) {
        this.description = value;
    }

    @Column(name="image_format")
    @Enumerated(value=EnumType.STRING)
    public ImageFormat getFormat() {
        return this.format;
    }

    public void setFormat(ImageFormat value) {
        this.format = value;
    }

    @Column(name="byte_length")
    public long getByteLength() {
        return this.byteLength;
    }

    protected void setByteLength(long value) {
        this.byteLength = value;
    }

    @Column(name="image_width")
    public long getImageWidth() {
        return this.imageWidth;
    }

    protected void setImageWidth(long value) {
        this.imageWidth = value;
    }

    @Column(name="image_height")
    public long getImageHeight() {
        return this.imageHeight;
    }

    protected void setImageHeight(long value) {
        this.imageHeight = value;
    }

    @Column(name="image_data")
    public byte[] getImageData() {
        return this.imageData;
    }

    public void setImageData(byte[] value) {
        this.imageData = value;
        this.byteLength = value != null ? (long)value.length : 0L;
    }

    @Transient
    public BufferedImage getImage() {
        if (this.image == null) {
            this.resolveImage();
        }
        return this.image;
    }

    public void setImage(Image value) {
        if (value != null) {
            ImageHelper helper = new ImageHelper();
            this.setImageData(helper.shrinkToByteSize(value, 64000, this.getFormat()));
            this.setImageWidth(value.getWidth(null));
            this.setImageHeight(value.getHeight(null));
        } else {
            this.setImageData(null);
            this.setImageWidth(0L);
            this.setImageHeight(0L);
        }
        this.resolveImage();
    }

    private void resolveImage() {
        if (this.getImageData() != null) {
            ImageHelper helper = new ImageHelper();
            this.image = helper.readInFromBytes(this.getImageData());
        } else {
            this.image = null;
        }
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    @Override
    public void save() {
        PersistenceManager.save(this);
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property<ImageFormat> FORMAT;
        public PropertiedObject.Property<String> DESCRIPTION;
        public PropertiedObject.Property BYTE_LENGTH;
        public PropertiedObject.Property IMAGE_WIDTH;
        public PropertiedObject.Property IMAGE_HEIGHT;
        public PropertiedObject.Property IMAGE_DATA;
        public PersistentObject.DerivedProperty IMAGE = new PersistentObject.DerivedProperty((Class<? extends PersistentObject>)((Class<PersistentObject>)ConfigSmallImage.class), "image");
    }
}

