/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.misc.resource;

import au.com.ordermate.persistence.PersistenceManager;
import au.com.ordermate.persistence.PersistentObject;
import au.com.ordermate.persistence.PersistentWriteableList;
import au.com.ordermate.persistence.PropertiedObject;
import au.com.ordermate.persistence.Reference;
import au.com.ordermate.persistence.SaveContext;
import au.com.ordermate.persistence.Saveable;
import au.com.ordermate.util.image.ImageFormat;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.Sequenced;
import ordermate.database.dbconstants.SystemState;
import ordermate.database.inventory.triggers.AbstractTrigger;
import ordermate.database.inventory.triggers.DefaultTrigger;
import ordermate.database.inventory.triggers.TriggerLink;
import ordermate.database.inventory.triggers.activation.TriggerActivated;
import ordermate.database.inventory.triggers.activation.TriggerActivationContext;
import ordermate.database.inventory.triggers.activation.TriggerActivationStrategy;
import ordermate.database.misc.resource.ConfigSmallImage;
import ordermate.database.misc.resource.DocketImageTrigger;

public class DocketImage
extends PersistentObject
implements Saveable,
Sequenced,
TriggerActivated {
    public static final Props Properties = new Props();
    private String imageGroup;
    private String label;
    private int sequence;
    private boolean highDpi;
    private SystemState systemState;
    private TriggerActivationStrategy triggerActivationStrategy;
    private Reference<ConfigSmallImage> image;
    private PersistentWriteableList<DocketImageTrigger> triggerLinks;
    private transient byte[] pushToDocket;

    @Deprecated
    public DocketImage() {
        this.image = this.createReference(DocketImage.Properties.IMAGE);
        this.triggerLinks = this.createWriteableList(DocketImage.Properties.TRIGGER_LINKS);
    }

    public DocketImage(String group, String label) {
        this.image = this.createReference(DocketImage.Properties.IMAGE);
        this.triggerLinks = this.createWriteableList(DocketImage.Properties.TRIGGER_LINKS);
        this.imageGroup = group;
        this.label = label;
        this.setImage(new ConfigSmallImage("Docket Image:" + this.imageGroup + " " + label));
        this.image.get().setFormat(ImageFormat.PNG);
        this.systemState = SystemState.ACTIVE_STATE;
        this.sequence = 1;
        this.highDpi = true;
        DefaultTrigger trigger = AbstractTrigger.getDefaultTriggerIfExists();
        if (trigger != null) {
            this.triggerLinks.add(new DocketImageTrigger(this, trigger));
        }
        this.triggerActivationStrategy = TriggerActivationStrategy.ALL_TRIGGERS;
    }

    public String getImageGroup() {
        return this.imageGroup;
    }

    public void setImageGroup(String imageGroup) {
        this.imageGroup = imageGroup;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isHighDpi() {
        return this.highDpi;
    }

    public void setHighDpi(boolean value) {
        this.highDpi = value;
    }

    @Override
    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public SystemState getSystemState() {
        return this.systemState;
    }

    public void setSystemState(SystemState systemState) {
        this.systemState = systemState;
    }

    public ConfigSmallImage getImage() {
        return this.image.get();
    }

    protected void setImage(ConfigSmallImage image) {
        this.image.set(image);
    }

    public List<DocketImageTrigger> getTriggerLinks() {
        return this.triggerLinks.getUnmodifiable();
    }

    protected void setTriggerLinks(List<DocketImageTrigger> value) {
        this.triggerLinks = this.triggerLinks.clone();
        this.triggerLinks.set(value);
    }

    @Override
    public void prepareForSave(SaveContext context) {
    }

    public int compareTo(Object o) {
        return Sequenced.SequenceComparator.getInst().compare(this, o);
    }

    @Override
    public TriggerActivationStrategy getTriggerActivationStrategy() {
        return this.triggerActivationStrategy;
    }

    @Override
    public void setTriggerActivationStrategy(TriggerActivationStrategy value) {
        this.triggerActivationStrategy = value;
    }

    @Override
    public boolean isActive(TriggerActivationContext context) {
        return this.triggerActivationStrategy.isActive(this, context);
    }

    @Override
    public boolean removeTrigger(AbstractTrigger trigger) {
        DocketImageTrigger toRemove = null;
        for (DocketImageTrigger nextLink : this.triggerLinks) {
            if (!nextLink.getTrigger().equals(trigger)) continue;
            toRemove = nextLink;
        }
        return toRemove != null && this.triggerLinks.remove(toRemove);
    }

    @Override
    public TriggerLink addTrigger(AbstractTrigger trigger) {
        if (trigger == null) {
            return null;
        }
        for (DocketImageTrigger nextLink : this.triggerLinks) {
            if (!trigger.equals(nextLink.getTrigger())) continue;
            return nextLink;
        }
        DocketImageTrigger link = new DocketImageTrigger(this, trigger);
        this.triggerLinks.add(link);
        return link;
    }

    @Override
    public void save() {
        this.image.saveChild();
        PersistenceManager.save(this);
        this.triggerLinks.saveChild();
    }

    @Override
    public void delete() {
        PersistenceManager.delete(this);
        this.triggerLinks.deleteChild();
        this.image.deleteChild();
    }

    @Override
    public boolean hasChanged() {
        return PersistenceManager.hasChanged(this);
    }

    @Override
    public List<AbstractTrigger> getTriggers() {
        ArrayList<AbstractTrigger> triggers = new ArrayList<AbstractTrigger>(this.triggerLinks.size());
        for (TriggerLink triggerLink : this.triggerLinks) {
            triggers.add(triggerLink.getTrigger());
        }
        return triggers;
    }

    public static class Props
    extends PersistentObject.Props {
        public PropertiedObject.Property<String> IMAGE_GROUP;
        public PropertiedObject.Property<String> LABEL;
        public PropertiedObject.Property HIGH_DPI;
        public PropertiedObject.Property<ConfigSmallImage> IMAGE;
        public PropertiedObject.Property SEQUENCE;
        public PropertiedObject.Property<SystemState> SYSTEM_STATE;
        public PropertiedObject.Property<TriggerActivationStrategy> TRIGGER_ACTIVATION_STRATEGY;
        public PropertiedObject.Property<DocketImageTrigger> TRIGGER_LINKS;
    }
}

