/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.util.Price;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.FinanceTransaction;
import ordermate.database.print.InvoicePrintData;

public class ActivityStatementData
implements InvoicePrintData {
    private Price balance = Price.ZERO_DOLLAR;
    private final String invoiceNumber;
    private final long saleDate;
    private final Price saleAmount;
    private final Price paidAmount;
    private final String description;
    private final Price tax;

    public ActivityStatementData(DebtorSale sale) {
        this.description = "Sales";
        this.invoiceNumber = "#" + sale.getSaleAccount().getID();
        this.saleDate = sale.getSaleDate().getTime();
        this.saleAmount = sale.getTotal();
        this.tax = sale.getTax();
        this.paidAmount = Price.ZERO_DOLLAR;
    }

    public ActivityStatementData(FinanceTransaction payment) {
        this.description = payment.getSubType().getLabel();
        StringBuilder sb = new StringBuilder();
        if (payment.getDebtorPayments().size() > 3) {
            sb.append(payment.getDebtorPayments().size());
            sb.append(" invoices");
        } else {
            Iterator<DebtorPayment> it = payment.getDebtorPayments().iterator();
            while (it.hasNext()) {
                DebtorPayment dp;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                if ((dp = it.next()).getSale() == null) continue;
                sb.append("#");
                sb.append(dp.getSale().getInvoiceNumber());
            }
        }
        this.invoiceNumber = sb.toString();
        this.saleDate = payment.getCreationTime().getTime();
        this.saleAmount = Price.ZERO_DOLLAR;
        this.tax = Price.ZERO_DOLLAR;
        this.paidAmount = payment.getPaid();
    }

    @Override
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @Override
    public Date getSaleDate() {
        return new Date(this.saleDate);
    }

    @Override
    public double getSaleAmount() {
        return this.saleAmount.doubleValue();
    }

    @Override
    public double getPaidAmount() {
        return this.paidAmount.doubleValue();
    }

    public void setBalance(double newBalance) {
        this.balance = new Price(newBalance, 0.01);
    }

    @Override
    public double getBalance() {
        return this.balance.doubleValue();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.saleDate + "-" + this.description + this.saleAmount + "-" + this.paidAmount + " bal>" + this.balance;
    }

    public Price getTax() {
        return this.tax;
    }

    public static class TimeOrderComparator
    implements Comparator<ActivityStatementData> {
        @Override
        public int compare(ActivityStatementData o1, ActivityStatementData o2) {
            return o1.getSaleDate().compareTo(o2.getSaleDate());
        }
    }
}

