/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.reports.PrintData;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.sales.AbstractSalesRemove;
import ordermate.database.sales.SalesAdd;
import ordermate.database.sales.SalesComponent;
import ordermate.database.sales.SalesOption;

public class ComponentPrintData
implements PrintData {
    private String shortPortion;
    private String portion;
    private String size;
    private String shortSize;
    private String name;
    private String menuGroup;
    private String[] pricedOptions;
    private String[] options;
    private String[] pricedPluses;
    private String[] pluses;
    private String[] pricedMinuses;
    private String[] minuses;

    public String getShortPortion() {
        return this.shortPortion;
    }

    public String getPortion() {
        return this.portion;
    }

    public String getSize() {
        return this.size;
    }

    public String getShortSize() {
        return this.shortSize;
    }

    public String getName() {
        return this.name;
    }

    public String getMenuGroup() {
        return this.menuGroup;
    }

    public String[] getPricedOptions() {
        return this.pricedOptions;
    }

    public String[] getOptions() {
        return this.options;
    }

    public String[] getPricedPluses() {
        return this.pricedPluses;
    }

    public String[] getPluses() {
        return this.pluses;
    }

    public String[] getPricedMinuses() {
        return this.pricedMinuses;
    }

    public String[] getMinuses() {
        return this.minuses;
    }

    static List<ComponentPrintData> getComponentPrintData(List<SalesComponent> components) {
        ArrayList<ComponentPrintData> newPrintData = new ArrayList<ComponentPrintData>(components.size());
        for (SalesComponent component : components) {
            newPrintData.add(ComponentPrintData.createPrintData(component));
        }
        return newPrintData;
    }

    private static ComponentPrintData createPrintData(SalesComponent component) {
        ComponentPrintData printData = new ComponentPrintData();
        printData.name = component.getInventoryItem().getLabel();
        printData.menuGroup = component.getInventoryItem().getMenuGroup().getLabel();
        printData.portion = component.getUnit().getPortionLabel();
        printData.shortPortion = component.getUnit().getPortion().getFraction();
        printData.size = component.getUnit().getSizeLabel();
        printData.shortSize = component.getUnit().getSize().getShortName();
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> pricedOptions = new ArrayList<String>();
        if (component.hasOption()) {
            for (SalesOption option : component.getCurrentOptions()) {
                options.add(option.getLabel());
                if (option.getModificationPrice().isZero()) continue;
                pricedOptions.add(option.getLabel());
            }
        }
        printData.options = options.toArray(new String[options.size()]);
        printData.pricedOptions = pricedOptions.toArray(new String[pricedOptions.size()]);
        ArrayList<String> pluses = new ArrayList<String>();
        ArrayList<String> pricedPluses = new ArrayList<String>();
        if (component.hasPlusses()) {
            for (SalesAdd plus : component.getCurrentPluses()) {
                pluses.add(plus.getLabel());
                if (plus.getModificationPrice().isZero()) continue;
                pricedPluses.add(plus.getLabel());
            }
        }
        printData.pluses = pluses.toArray(new String[pluses.size()]);
        printData.pricedPluses = pricedPluses.toArray(new String[pricedPluses.size()]);
        ArrayList<String> minuses = new ArrayList<String>();
        ArrayList<String> pricedMinuses = new ArrayList<String>();
        if (component.hasMinuses()) {
            for (AbstractSalesRemove minus : component.getCurrentMinuses()) {
                minuses.add(minus.getLabel());
                if (minus.getModificationPrice().isZero()) continue;
                pricedMinuses.add(minus.getLabel());
            }
        }
        printData.minuses = minuses.toArray(new String[minuses.size()]);
        printData.pricedMinuses = pricedMinuses.toArray(new String[pricedMinuses.size()]);
        return printData;
    }
}

