/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.print.InvoicePrintData;

public class DebtorStatementLinePrintData
implements InvoicePrintData {
    private Price balance = new Price(0.0, 0.0);
    private String invoiceNumber;
    private Date saleDate;
    private Price totalAmount;
    private Price due;
    private Price paidAmount;
    private Price tax;
    private String description;
    private String paymentStatus;

    private DebtorStatementLinePrintData(DebtorSale newSale, Price newBalance) {
        DebtorSale sale = newSale;
        this.balance = newBalance;
        this.invoiceNumber = "#" + newSale.getSaleAccount().getID();
        this.saleDate = sale.getSaleDate();
        this.totalAmount = sale.getTotal();
        this.tax = sale.getTax();
        this.due = sale.getDue();
        this.paidAmount = sale.getTotalPaid();
        this.description = newSale.getSaleAccount().getDescription();
        if (newSale.hasNote()) {
            this.description = this.description + " -  " + newSale.getInvoiceNote();
        }
        this.paymentStatus = sale.isPaid() ? "PAID" : (sale.isOverdue() ? "OVERDUE" : "");
    }

    @Override
    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    @Override
    public Date getSaleDate() {
        return this.saleDate;
    }

    public double getTotalAmount() {
        return this.totalAmount.doubleValue();
    }

    @Override
    public double getSaleAmount() {
        return this.getTotalAmount();
    }

    public double getDue() {
        return this.due.doubleValue();
    }

    @Override
    public double getPaidAmount() {
        return this.paidAmount.doubleValue();
    }

    @Override
    public double getBalance() {
        return this.balance.doubleValue();
    }

    public String getPaymentStatus() {
        return this.paymentStatus;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public static List getDebtorStatementLinePrintData(List debtorSales, Price openingBalance) {
        Price balance = openingBalance;
        if (balance == null) {
            balance = new Price(0.0, 0.0);
        }
        ArrayList<DebtorStatementLinePrintData> printData = new ArrayList<DebtorStatementLinePrintData>();
        for (DebtorSale currentSale : debtorSales) {
            balance = balance.add(currentSale.getDue());
            printData.add(new DebtorStatementLinePrintData(currentSale, balance));
        }
        return printData;
    }

    public Price getTax() {
        return this.tax;
    }
}

