/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.reports.PrintData;
import au.com.ordermate.util.Price;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import ordermate.database.finance.debtors.AbstractDebtor;
import ordermate.database.finance.debtors.DebtorsSummary;

public class DebtorSummaryPrintData
implements PrintData {
    private String accountName;
    private String group;
    private Price creditLimit;
    private Date lastActivity;
    private DebtorsSummary summary;

    public DebtorSummaryPrintData(AbstractDebtor debtor) {
        this.summary = DebtorsSummary.summarize(debtor);
        this.accountName = debtor.getLabel();
        this.group = debtor.getGroup() != null ? debtor.getGroup().getName() : "No Group";
        this.creditLimit = debtor.getCreditLimit();
        this.lastActivity = debtor.getLastActivityDate();
    }

    public static List getDebtorSummaryPrintData(List debtors) {
        ArrayList<DebtorSummaryPrintData> allPrintData = new ArrayList<DebtorSummaryPrintData>(debtors.size());
        for (AbstractDebtor debtor : debtors) {
            DebtorSummaryPrintData printData = new DebtorSummaryPrintData(debtor);
            allPrintData.add(printData);
        }
        return allPrintData;
    }

    public String getAccountName() {
        return this.accountName;
    }

    public String getGroup() {
        return this.group;
    }

    public Price getCreditLimit() {
        return this.creditLimit;
    }

    public Date getLastActivity() {
        return this.lastActivity;
    }

    public Price getCurrent() {
        return this.summary.getCurrent();
    }

    public Price getThirtyDays() {
        return this.summary.getThirtyDays();
    }

    public Price getSixtyDays() {
        return this.summary.getSixtyDays();
    }

    public Price getSixtyPlusDays() {
        return this.summary.getSixtyPlusDays();
    }

    public Price getOutstanding() {
        return this.summary.getOutstanding();
    }
}

