/*
 * Decompiled with CFR 0.152.
 */
package ordermate.database.print;

import au.com.ordermate.reports.PrintData;
import au.com.ordermate.util.Price;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import ordermate.database.finance.debtors.transactions.DebtorPayment;
import ordermate.database.finance.debtors.transactions.DebtorSale;
import ordermate.database.finance.transactions.CashTransaction;
import ordermate.database.finance.transactions.FinanceTransaction;
import org.apache.commons.lang.StringUtils;

public class FinanceTransactionPrintData
implements PrintData {
    private String type;
    private String description;
    private double value;
    private Date date;
    private String reference;

    public String getType() {
        return this.type;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReference() {
        return this.reference;
    }

    public double getValue() {
        return this.value;
    }

    public Date getDate() {
        return this.date;
    }

    public static List<FinanceTransactionPrintData> getFinanceTransactionPrintData(DebtorSale sale) {
        ArrayList<FinanceTransactionPrintData> allPrintData = new ArrayList<FinanceTransactionPrintData>();
        for (DebtorPayment debtorPayment : sale.getPayments()) {
            FinanceTransactionPrintData printData = new FinanceTransactionPrintData();
            String type = debtorPayment.getFinanceTransaction().getSubType().getLabel();
            printData.type = StringUtils.capitalize((String)StringUtils.lowerCase((String)type));
            FinanceTransaction transaction = debtorPayment.getFinanceTransaction();
            printData.description = transaction instanceof CashTransaction ? FinanceTransactionPrintData.getCashTransactionDesc((CashTransaction)transaction) : printData.type;
            printData.reference = transaction.getTransactionReference();
            printData.date = new Date(transaction.getCreationTime().getTime());
            printData.value = debtorPayment.getAmount().doubleValue();
            allPrintData.add(printData);
        }
        return allPrintData;
    }

    public static List<FinanceTransactionPrintData> getFinanceTransactionPrintData(List transactions) {
        ArrayList<FinanceTransactionPrintData> allPrintData = new ArrayList<FinanceTransactionPrintData>(transactions.size());
        for (FinanceTransaction transaction : transactions) {
            FinanceTransactionPrintData printData = new FinanceTransactionPrintData();
            String type = transaction.getSubType().getLabel();
            printData.type = StringUtils.capitalize((String)StringUtils.lowerCase((String)type));
            Price tip = transaction.getTip();
            Price surch = transaction.getSurcharge();
            if (transaction instanceof CashTransaction) {
                printData.description = FinanceTransactionPrintData.getCashTransactionDesc((CashTransaction)transaction);
            } else {
                StringBuilder SB = new StringBuilder(printData.type);
                if (transaction.getMaskedCardNumber() != null && !transaction.getMaskedCardNumber().isEmpty()) {
                    SB.append(" (").append(transaction.getMaskedCardNumber()).append(")");
                }
                if (surch != null && !Price.ZERO_DOLLAR.equals(surch)) {
                    SB.append(" Surch: ").append(surch);
                } else {
                    surch = null;
                }
                if (tip != null && !Price.ZERO_DOLLAR.equals(tip)) {
                    SB.append(" (Tip: ").append(tip).append(")");
                } else {
                    tip = null;
                }
                printData.description = SB.toString();
            }
            Price paid = transaction.getPaid();
            if (tip != null) {
                paid = paid.add(tip);
            }
            printData.reference = transaction.getTransactionReference();
            printData.date = new Date(transaction.getCreationTime().getTime());
            printData.value = paid.doubleValue();
            allPrintData.add(printData);
        }
        return allPrintData;
    }

    private static String getCashTransactionDesc(CashTransaction cashTransaction) {
        String cashDescription = "";
        cashDescription = cashTransaction.getChange().isZero() ? "Cash" : "Cash (Tendered " + cashTransaction.getTendered() + ", Change " + cashTransaction.getChange() + ")";
        return cashDescription;
    }
}

